/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.superpom;

import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.superpom.SuperPomProvider;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=SuperPomProvider.class)
public class DefaultSuperPomProvider
implements SuperPomProvider {
    private Model superModel;
    @Requirement
    private ModelReader modelReader;

    public Model getSuperModel(String version) {
        if (this.superModel == null) {
            String resource = "/org/apache/maven/model/pom-" + version + ".xml";
            InputStream is = this.getClass().getResourceAsStream(resource);
            if (is == null) {
                throw new IllegalStateException("The super POM " + resource + " was not found" + ", please verify the integrity of your Maven installation");
            }
            try {
                this.superModel = this.modelReader.read(is, null);
            }
            catch (IOException e) {
                throw new IllegalStateException("The super POM " + resource + " is damaged" + ", please verify the integrity of your Maven installation", e);
            }
        }
        return this.superModel;
    }
}

