/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.normalization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.merge.MavenModelMerger;
import org.apache.maven.model.normalization.ModelNormalizer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ModelNormalizer.class)
public class DefaultModelNormalizer
implements ModelNormalizer {
    private DuplicateMerger merger = new DuplicateMerger();

    @Override
    public void mergeDuplicates(Model model, ModelBuildingRequest request) {
        Build build = model.getBuild();
        if (build != null) {
            List original = build.getPlugins();
            LinkedHashMap<String, Plugin> normalized = new LinkedHashMap<String, Plugin>();
            for (Plugin plugin : original) {
                String key = plugin.getKey();
                Plugin first = (Plugin)normalized.get(key);
                if (first != null) {
                    this.merger.mergePlugin(plugin, first);
                }
                normalized.put(key, plugin);
            }
            build.setPlugins(new ArrayList(normalized.values()));
        }
        if (request.getValidationLevel() < 30) {
            LinkedHashMap<String, Dependency> dependencies = new LinkedHashMap<String, Dependency>();
            for (Dependency dependency : model.getDependencies()) {
                dependencies.put(dependency.getManagementKey(), dependency);
            }
            model.setDependencies(new ArrayList(dependencies.values()));
        }
    }

    @Override
    public void injectDefaultValues(Model model, ModelBuildingRequest request) {
        this.injectDependencyDefaults(model.getDependencies());
        Build build = model.getBuild();
        if (build != null) {
            for (Plugin plugin : build.getPlugins()) {
                this.injectDependencyDefaults(plugin.getDependencies());
            }
        }
    }

    private void injectDependencyDefaults(List<Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            if (!StringUtils.isEmpty((String)dependency.getScope())) continue;
            dependency.setScope("compile");
        }
    }

    private static class DuplicateMerger
    extends MavenModelMerger {
        private DuplicateMerger() {
        }

        public void mergePlugin(Plugin target, Plugin source) {
            super.mergePlugin(target, source, false, Collections.emptyMap());
        }
    }
}

