/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.inheritance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.inheritance.InheritanceAssembler;
import org.apache.maven.model.merge.MavenModelMerger;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=InheritanceAssembler.class)
public class DefaultInheritanceAssembler
implements InheritanceAssembler {
    private InheritanceModelMerger merger = new InheritanceModelMerger();

    public void assembleModelInheritance(Model child, Model parent, ModelBuildingRequest request) {
        HashMap<String, String> hints = new HashMap<String, String>();
        hints.put("child-path-adjustment", this.getChildPathAdjustment(child, parent));
        this.merger.merge(child, parent, false, hints);
    }

    private String getChildPathAdjustment(Model child, Model parent) {
        String adjustment = "";
        if (parent != null) {
            String childArtifactId = child.getArtifactId();
            for (String module : parent.getModules()) {
                int lastSlash;
                String moduleName;
                if ((module = module.replace('\\', '/')).regionMatches(true, module.length() - 4, ".xml", 0, 4)) {
                    module = module.substring(0, module.lastIndexOf(47) + 1);
                }
                if ((moduleName = module).endsWith("/")) {
                    moduleName = moduleName.substring(0, moduleName.length() - 1);
                }
                if (!(moduleName = moduleName.substring((lastSlash = moduleName.lastIndexOf(47)) + 1)).equals(childArtifactId) || lastSlash < 0) continue;
                adjustment = module.substring(0, lastSlash);
                break;
            }
        }
        return adjustment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InheritanceModelMerger
    extends MavenModelMerger {
        private InheritanceModelMerger() {
        }

        protected void mergePluginContainer_Plugins(PluginContainer target, PluginContainer source, boolean sourceDominant, Map<Object, Object> context) {
            List src = source.getPlugins();
            if (!src.isEmpty()) {
                Object key;
                List tgt = target.getPlugins();
                LinkedHashMap<Object, Plugin> merged = new LinkedHashMap<Object, Plugin>((src.size() + tgt.size()) * 2);
                for (Plugin element : src) {
                    key = this.getPluginKey(element);
                    if (!element.isInherited()) continue;
                    Plugin plugin = new Plugin();
                    plugin.setGroupId(element.getGroupId());
                    plugin.setArtifactId(element.getArtifactId());
                    this.mergePlugin(plugin, element, sourceDominant, context);
                    merged.put(key, plugin);
                }
                for (Plugin element : tgt) {
                    key = this.getPluginKey(element);
                    Plugin existing = (Plugin)merged.get(key);
                    if (existing != null) {
                        this.mergePlugin(element, existing, sourceDominant, context);
                    }
                    merged.put(key, element);
                }
                target.setPlugins(new ArrayList(merged.values()));
            }
        }

        protected void mergeReporting_Plugins(Reporting target, Reporting source, boolean sourceDominant, Map<Object, Object> context) {
            List src = source.getPlugins();
            if (!src.isEmpty()) {
                Object key;
                List tgt = target.getPlugins();
                LinkedHashMap<Object, ReportPlugin> merged = new LinkedHashMap<Object, ReportPlugin>((src.size() + tgt.size()) * 2);
                for (ReportPlugin element : src) {
                    key = this.getReportPluginKey(element);
                    if (!element.isInherited()) continue;
                    ReportPlugin plugin = new ReportPlugin();
                    plugin.setGroupId(element.getGroupId());
                    plugin.setArtifactId(element.getArtifactId());
                    this.mergeReportPlugin(plugin, element, sourceDominant, context);
                    merged.put(key, plugin);
                }
                for (ReportPlugin element : tgt) {
                    key = this.getReportPluginKey(element);
                    ReportPlugin existing = (ReportPlugin)merged.get(key);
                    if (existing != null) {
                        this.mergeReportPlugin(element, existing, sourceDominant, context);
                    }
                    merged.put(key, element);
                }
                target.setPlugins(new ArrayList(merged.values()));
            }
        }
    }
}

