/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.slf4j;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.apache.maven.slf4j.OutputChoice;
import org.slf4j.helpers.Reporter;

public class SimpleLoggerConfiguration {
    private static final String CONFIGURATION_FILE = "maven.logger.properties";
    @Deprecated(since="4.0.0")
    private static final String LEGACY_CONFIGURATION_FILE = "simplelogger.properties";
    static final int DEFAULT_LOG_LEVEL_DEFAULT = 20;
    int defaultLogLevel = 20;
    private static final boolean SHOW_DATE_TIME_DEFAULT = false;
    boolean showDateTime = false;
    private static final String DATE_TIME_FORMAT_STR_DEFAULT = null;
    DateTimeFormatter dateFormatter = null;
    private static final boolean SHOW_THREAD_NAME_DEFAULT = true;
    boolean showThreadName = true;
    private static final boolean SHOW_THREAD_ID_DEFAULT = false;
    boolean showThreadId = false;
    static final boolean SHOW_LOG_NAME_DEFAULT = true;
    boolean showLogName = true;
    private static final boolean SHOW_SHORT_LOG_NAME_DEFAULT = false;
    boolean showShortLogName = false;
    private static final boolean LEVEL_IN_BRACKETS_DEFAULT = false;
    boolean levelInBrackets = false;
    private static final String LOG_FILE_DEFAULT = "System.err";
    private String logFile = "System.err";
    OutputChoice outputChoice = null;
    private static final boolean CACHE_OUTPUT_STREAM_DEFAULT = false;
    private boolean cacheOutputStream = false;
    private static final String WARN_LEVELS_STRING_DEFAULT = "WARN";
    String warnLevelString = "WARN";
    private final Properties properties = new Properties();

    void init() {
        this.dateFormatter = null;
        this.loadProperties();
        String defaultLogLevelString = this.getStringProperty("maven.logger.defaultLogLevel", null);
        if (defaultLogLevelString != null) {
            this.defaultLogLevel = SimpleLoggerConfiguration.stringToLevel(defaultLogLevelString);
        }
        this.showLogName = this.getBooleanProperty("maven.logger.showLogName", true);
        this.showShortLogName = this.getBooleanProperty("maven.logger.showShortLogName", false);
        this.showDateTime = this.getBooleanProperty("maven.logger.showDateTime", false);
        this.showThreadName = this.getBooleanProperty("maven.logger.showThreadName", true);
        this.showThreadId = this.getBooleanProperty("maven.logger.showThreadId", false);
        String dateTimeFormatStr = this.getStringProperty("maven.logger.dateTimeFormat", DATE_TIME_FORMAT_STR_DEFAULT);
        this.levelInBrackets = this.getBooleanProperty("maven.logger.levelInBrackets", false);
        this.warnLevelString = this.getStringProperty("maven.logger.warnLevelString", WARN_LEVELS_STRING_DEFAULT);
        this.logFile = this.getStringProperty("maven.logger.logFile", this.logFile);
        this.cacheOutputStream = this.getBooleanProperty("maven.logger.cacheOutputStream", false);
        this.outputChoice = SimpleLoggerConfiguration.computeOutputChoice(this.logFile, this.cacheOutputStream);
        if (dateTimeFormatStr != null) {
            try {
                this.dateFormatter = DateTimeFormatter.ofPattern(dateTimeFormatStr);
            }
            catch (IllegalArgumentException e) {
                Reporter.error((String)"Bad date format in maven.logger.properties; will output relative time", (Throwable)e);
            }
        }
    }

    private void loadProperties() {
        InputStream in2;
        ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
        ClassLoader toUseCL = threadCL != null ? threadCL : ClassLoader.getSystemClassLoader();
        boolean mavenPropsLoaded = false;
        try {
            in2 = toUseCL.getResourceAsStream(CONFIGURATION_FILE);
            try {
                if (in2 != null) {
                    this.properties.load(in2);
                    mavenPropsLoaded = true;
                }
            }
            finally {
                if (in2 != null) {
                    in2.close();
                }
            }
        }
        catch (IOException in2) {
            // empty catch block
        }
        try {
            in2 = toUseCL.getResourceAsStream(LEGACY_CONFIGURATION_FILE);
            try {
                if (in2 != null) {
                    Properties legacyProps = new Properties();
                    legacyProps.load(in2);
                    if (!mavenPropsLoaded) {
                        Reporter.warn((String)"Using deprecated simplelogger.properties. Please migrate to maven.logger.properties");
                    }
                    for (String propName : legacyProps.stringPropertyNames()) {
                        String mavenKey = propName.replace("org.slf4j.simpleLogger.", "maven.logger.");
                        if (this.properties.containsKey(mavenKey)) continue;
                        this.properties.setProperty(mavenKey, legacyProps.getProperty(propName));
                    }
                }
            }
            finally {
                if (in2 != null) {
                    in2.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String getStringProperty(String name, String defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : prop;
    }

    boolean getBooleanProperty(String name, boolean defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    String getStringProperty(String name) {
        String prop = null;
        try {
            String legacyName;
            prop = System.getProperty(name);
            if (prop == null && name.startsWith("maven.logger.") && (prop = System.getProperty(legacyName = name.replace("maven.logger.", "org.slf4j.simpleLogger."))) != null) {
                Reporter.warn((String)("Using deprecated property " + legacyName + ". Please migrate to " + name));
            }
        }
        catch (SecurityException legacyName) {
            // empty catch block
        }
        if (prop == null && (prop = this.properties.getProperty(name)) == null && name.startsWith("maven.logger.") && (prop = this.properties.getProperty(legacyName = name.replace("maven.logger.", "org.slf4j.simpleLogger."))) != null) {
            Reporter.warn((String)("Using deprecated property " + legacyName + ". Please migrate to " + name));
        }
        return prop;
    }

    static int stringToLevel(String levelStr) {
        if ("trace".equalsIgnoreCase(levelStr)) {
            return 0;
        }
        if ("debug".equalsIgnoreCase(levelStr)) {
            return 10;
        }
        if ("info".equalsIgnoreCase(levelStr)) {
            return 20;
        }
        if ("warn".equalsIgnoreCase(levelStr)) {
            return 30;
        }
        if ("error".equalsIgnoreCase(levelStr)) {
            return 40;
        }
        if ("off".equalsIgnoreCase(levelStr)) {
            return 50;
        }
        return 20;
    }

    private static OutputChoice computeOutputChoice(String logFile, boolean cacheOutputStream) {
        if (LOG_FILE_DEFAULT.equalsIgnoreCase(logFile)) {
            return new OutputChoice(cacheOutputStream ? OutputChoice.OutputChoiceType.CACHED_SYS_ERR : OutputChoice.OutputChoiceType.SYS_ERR);
        }
        if ("System.out".equalsIgnoreCase(logFile)) {
            return new OutputChoice(cacheOutputStream ? OutputChoice.OutputChoiceType.CACHED_SYS_OUT : OutputChoice.OutputChoiceType.SYS_OUT);
        }
        try {
            FileOutputStream fos = new FileOutputStream(logFile);
            PrintStream printStream = new PrintStream(fos);
            return new OutputChoice(printStream);
        }
        catch (FileNotFoundException e) {
            Reporter.error((String)("Could not open [" + logFile + "]. Defaulting to System.err"), (Throwable)e);
            return new OutputChoice(OutputChoice.OutputChoiceType.SYS_ERR);
        }
    }
}

