/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.slf4j;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.function.Consumer;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.jline.MessageUtils;
import org.apache.maven.slf4j.MavenBaseLogger;
import org.apache.maven.slf4j.SimpleLoggerConfiguration;

public class MavenSimpleLogger
extends MavenBaseLogger {
    private String traceRenderedLevel;
    private String debugRenderedLevel;
    private String infoRenderedLevel;
    private String warnRenderedLevel;
    private String errorRenderedLevel;
    static Consumer<String> logSink;

    public static void setLogSink(Consumer<String> logSink) {
        MavenSimpleLogger.logSink = logSink;
    }

    MavenSimpleLogger(String name) {
        super(name);
    }

    @Override
    protected String renderLevel(int level) {
        if (this.traceRenderedLevel == null) {
            this.traceRenderedLevel = MessageUtils.builder().trace((Object)"TRACE").build();
            this.debugRenderedLevel = MessageUtils.builder().debug((Object)"DEBUG").build();
            this.infoRenderedLevel = MessageUtils.builder().info((Object)"INFO").build();
            this.warnRenderedLevel = MessageUtils.builder().warning((Object)"WARNING").build();
            this.errorRenderedLevel = MessageUtils.builder().error((Object)"ERROR").build();
        }
        switch (level) {
            case 0: {
                return this.traceRenderedLevel;
            }
            case 10: {
                return this.debugRenderedLevel;
            }
            case 20: {
                return this.infoRenderedLevel;
            }
            case 30: {
                return this.warnRenderedLevel;
            }
        }
        return this.errorRenderedLevel;
    }

    @Override
    protected void write(StringBuilder buf, Throwable t) {
        Consumer<String> sink = logSink;
        if (sink != null) {
            sink.accept(buf.toString());
            if (t != null) {
                this.writeThrowable(t, sink);
            }
        } else {
            super.write(buf, t);
        }
    }

    @Override
    protected void writeThrowable(Throwable t, PrintStream stream) {
        this.writeThrowable(t, stream::println);
    }

    protected void writeThrowable(Throwable t, Consumer<String> stream) {
        if (t == null) {
            return;
        }
        MessageBuilder builder = MessageUtils.builder().failure((Object)t.getClass().getName());
        if (t.getMessage() != null) {
            builder.a((CharSequence)": ").failure((Object)t.getMessage());
        }
        stream.accept(builder.toString());
        this.printStackTrace(t, stream, "");
    }

    protected void printStackTrace(Throwable t, Consumer<String> stream, String prefix) {
        MessageBuilder builder = MessageUtils.builder();
        for (StackTraceElement stackTraceElement : t.getStackTrace()) {
            builder.a((CharSequence)prefix);
            builder.a((CharSequence)"    ");
            builder.strong((Object)"at");
            builder.a((CharSequence)" ");
            builder.a((CharSequence)stackTraceElement.getClassName());
            builder.a((CharSequence)".");
            builder.a((CharSequence)stackTraceElement.getMethodName());
            builder.a((CharSequence)"(");
            builder.strong((Object)this.getLocation(stackTraceElement));
            builder.a((CharSequence)")");
            stream.accept(builder.toString());
            builder.setLength(0);
        }
        for (Serializable serializable : t.getSuppressed()) {
            this.writeThrowable((Throwable)serializable, stream, "Suppressed", prefix + "    ");
        }
        Throwable cause = t.getCause();
        if (cause != null && t != cause) {
            this.writeThrowable(cause, stream, "Caused by", prefix);
        }
    }

    protected void writeThrowable(Throwable t, Consumer<String> stream, String caption, String prefix) {
        MessageBuilder builder = MessageUtils.builder().a((CharSequence)prefix).strong((Object)caption).a((CharSequence)": ").a((CharSequence)t.getClass().getName());
        if (t.getMessage() != null) {
            builder.a((CharSequence)": ").failure((Object)t.getMessage());
        }
        stream.accept(builder.toString());
        this.printStackTrace(t, stream, prefix);
    }

    protected String getLocation(StackTraceElement e) {
        assert (e != null);
        if (e.isNativeMethod()) {
            return "Native Method";
        }
        if (e.getFileName() == null) {
            return "Unknown Source";
        }
        if (e.getLineNumber() >= 0) {
            return e.getFileName() + ":" + e.getLineNumber();
        }
        return e.getFileName();
    }

    public void configure(int defaultLogLevel) {
        String levelString = this.recursivelyComputeLevelString();
        this.currentLogLevel = levelString != null ? SimpleLoggerConfiguration.stringToLevel(levelString) : defaultLogLevel;
    }

    public void setLogLevel(int logLevel) {
        this.currentLogLevel = logLevel;
    }
}

