/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.resolver;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.DownloadedArtifact;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.Version;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.services.ArtifactResolverException;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.Sources;
import org.apache.maven.api.services.VersionRangeResolverException;
import org.apache.maven.api.services.model.ModelResolver;
import org.apache.maven.api.services.model.ModelResolverException;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.impl.RequestTraceHelper;

@Named
@Singleton
public class DefaultModelResolver
implements ModelResolver {
    @Override
    @Nonnull
    public ModelSource resolveModel(@Nonnull Session session, @Nullable List<RemoteRepository> repositories, @Nonnull Parent parent, @Nonnull AtomicReference<Parent> modified) throws ModelResolverException {
        ModelResolver.ModelResolverResult result = this.resolveModel(new ModelResolver.ModelResolverRequest(session, null, repositories, parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), null), parent.getLocation((Object)"version"), "parent");
        if (result.version() != null) {
            modified.set(parent.withVersion(result.version()));
        }
        return result.source();
    }

    @Override
    @Nonnull
    public ModelSource resolveModel(@Nonnull Session session, @Nullable List<RemoteRepository> repositories, @Nonnull Dependency dependency, @Nonnull AtomicReference<Dependency> modified) throws ModelResolverException {
        ModelResolver.ModelResolverResult result = this.resolveModel(new ModelResolver.ModelResolverRequest(session, null, repositories, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier()), dependency.getLocation((Object)"version"), "dependency");
        if (result.version() != null) {
            modified.set(dependency.withVersion(result.version()));
        }
        return result.source();
    }

    @Override
    @Nonnull
    public ModelResolver.ModelResolverResult resolveModel(@Nonnull ModelResolver.ModelResolverRequest request) throws ModelResolverException {
        return this.resolveModel(request, null, null);
    }

    public ModelResolver.ModelResolverResult resolveModel(@Nonnull ModelResolver.ModelResolverRequest request, InputLocation location, String modelType) throws ModelResolverException {
        return InternalSession.from(request.session()).request(request, r -> this.doResolveModel((ModelResolver.ModelResolverRequest)r, location, modelType));
    }

    public ModelResolver.ModelResolverResult doResolveModel(@Nonnull ModelResolver.ModelResolverRequest request, InputLocation location, String modelType) throws ModelResolverException {
        Session session = request.session();
        String groupId = request.groupId();
        String artifactId = request.artifactId();
        String version = request.version();
        String classifier = request.classifier();
        List repositories = request.repositories();
        RequestTraceHelper.ResolverTrace trace = RequestTraceHelper.enter(session, request);
        try {
            ArtifactCoordinates coords = session.createArtifactCoordinates(groupId, artifactId, version, classifier, "pom", null);
            if (coords.getVersionConstraint().getVersionRange() != null && coords.getVersionConstraint().getVersionRange().getUpperBoundary() == null) {
                throw new ModelResolverException("The requested " + (String)(modelType != null ? modelType + " " : "") + "version range '" + version + "'" + (String)(location != null ? " (at " + location + ")" : "") + " does not specify an upper bound", groupId, artifactId, version);
            }
            String newVersion = ((Version)session.resolveHighestVersion(coords, repositories).orElseThrow(() -> new ModelResolverException("No versions matched the requested " + (String)(modelType != null ? modelType + " " : "") + "version range '" + version + "'", groupId, artifactId, version))).toString();
            String resultVersion = version.equals(newVersion) ? null : newVersion;
            Path path = this.getPath(session, repositories, groupId, artifactId, newVersion, classifier);
            ModelResolver.ModelResolverResult modelResolverResult = new ModelResolver.ModelResolverResult(request, Sources.resolvedSource((Path)path, (String)(groupId + ":" + artifactId + ":" + newVersion)), resultVersion);
            return modelResolverResult;
        }
        catch (ArtifactResolverException | VersionRangeResolverException e) {
            throw new ModelResolverException(e.getMessage() + " (remote repositories: " + (repositories != null ? repositories : session.getRemoteRepositories()).stream().map(Object::toString).collect(Collectors.joining(", ")) + ")", groupId, artifactId, version, e);
        }
        finally {
            RequestTraceHelper.exit(trace);
        }
    }

    protected Path getPath(Session session, List<RemoteRepository> repositories, String groupId, String artifactId, String version, String classifier) {
        DownloadedArtifact resolved = session.resolveArtifact(session.createArtifactCoordinates(groupId, artifactId, version, classifier, "pom", null), repositories);
        return resolved.getPath();
    }
}

