/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.ArtifactInstaller;
import org.apache.maven.api.services.ArtifactInstallerException;
import org.apache.maven.api.services.ArtifactInstallerRequest;
import org.apache.maven.impl.ImplUtils;
import org.apache.maven.impl.InternalSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;

@Named
@Singleton
public class DefaultArtifactInstaller
implements ArtifactInstaller {
    private final RepositorySystem repositorySystem;

    @Inject
    DefaultArtifactInstaller(@Nonnull RepositorySystem repositorySystem) {
        this.repositorySystem = ImplUtils.nonNull(repositorySystem);
    }

    public void install(ArtifactInstallerRequest request) throws ArtifactInstallerException, IllegalArgumentException {
        ImplUtils.nonNull(request, "request");
        InternalSession session = InternalSession.from((Session)request.getSession());
        try {
            InstallRequest installRequest = new InstallRequest().setArtifacts(session.toArtifacts(request.getArtifacts()));
            this.repositorySystem.install(session.getSession(), installRequest);
        }
        catch (InstallationException e) {
            throw new ArtifactInstallerException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

