/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class RepositoryBase
extends IdentifiableBase
implements Serializable,
InputLocationTracker {
    final String name;
    final String url;
    final String layout;
    final Map<Object, InputLocation> locations;

    protected RepositoryBase(Builder builder) {
        super(builder);
        String string = builder.name != null ? builder.name : (this.name = builder.base != null ? builder.base.name : null);
        String string2 = builder.url != null ? builder.url : (this.url = builder.base != null ? builder.base.url : null);
        this.layout = builder.layout != null ? builder.layout : (builder.base != null ? builder.base.layout : null);
        Map newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<Object, InputLocation> mutableLocations = new HashMap<Object, InputLocation>(((IdentifiableBase)this).locations);
        mutableLocations.put("name", newlocs.containsKey("name") ? (InputLocation)newlocs.get("name") : (InputLocation)oldlocs.get("name"));
        mutableLocations.put("url", newlocs.containsKey("url") ? (InputLocation)newlocs.get("url") : (InputLocation)oldlocs.get("url"));
        mutableLocations.put("layout", newlocs.containsKey("layout") ? (InputLocation)newlocs.get("layout") : (InputLocation)oldlocs.get("layout"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLayout() {
        return this.layout;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Override
    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    @Override
    @Nonnull
    public Builder with() {
        return RepositoryBase.newBuilder(this);
    }

    @Override
    @Nonnull
    public RepositoryBase withId(String id) {
        return RepositoryBase.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public RepositoryBase withName(String name) {
        return RepositoryBase.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public RepositoryBase withUrl(String url) {
        return RepositoryBase.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public RepositoryBase withLayout(String layout) {
        return RepositoryBase.newBuilder(this, true).layout(layout).build();
    }

    @Nonnull
    public static RepositoryBase newInstance() {
        return RepositoryBase.newInstance(true);
    }

    @Nonnull
    public static RepositoryBase newInstance(boolean withDefaults) {
        return RepositoryBase.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return RepositoryBase.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(RepositoryBase from) {
        return RepositoryBase.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(RepositoryBase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends IdentifiableBase.Builder {
        RepositoryBase base;
        String name;
        String url;
        String layout;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.layout = "default";
            }
        }

        protected Builder(RepositoryBase base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.name = base.name;
                this.url = base.url;
                this.layout = base.layout;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public RepositoryBase build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.name != null && this.name != this.base.name || this.url != null && this.url != this.base.url || this.layout != null && this.layout != this.base.layout)) {
                return this.base;
            }
            return new RepositoryBase(this);
        }
    }
}

