/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.TrackableBase;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class IdentifiableBase
extends TrackableBase
implements Serializable {
    final String id;

    IdentifiableBase(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public Builder with() {
        return IdentifiableBase.newBuilder(this);
    }

    @Nonnull
    public IdentifiableBase withId(String id) {
        return this.with().id(id).build();
    }

    @Nonnull
    public static IdentifiableBase newInstance() {
        return IdentifiableBase.newInstance(true);
    }

    @Nonnull
    public static IdentifiableBase newInstance(boolean withDefaults) {
        return IdentifiableBase.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return IdentifiableBase.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(IdentifiableBase from) {
        return IdentifiableBase.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(IdentifiableBase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends TrackableBase.Builder {
        IdentifiableBase base;
        String id;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.id = "default";
            }
        }

        Builder(IdentifiableBase base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @Nonnull
        public IdentifiableBase build() {
            if (this.base != null && (this.id == null || this.id == this.base.id)) {
                return this.base;
            }
            return new IdentifiableBase(this.id != null ? this.id : (this.base != null ? this.base.id : null));
        }
    }
}

