// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.plugin.descriptor;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * A parameter description.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Parameter
    implements Serializable
{
    /**
     * The name of the parameter, to be used while configuring this parameter from the Mojo's declared defaults
     * or from the POM.
     */
    final String name;
    /**
     * Specifies an alias which can be used to configure this parameter from the POM.
     * This is primarily useful to improve user-friendliness, where Mojo field names are not intuitive to the
     * user or are otherwise not conducive to configuration via the POM.
     */
    final String alias;
    /**
     * The Java type for this parameter. This is used to validate the result of any expressions used to calculate
     * the value which should be injected into the Mojo for this parameter.
     */
    final String type;
    /**
     * Whether this parameter is required for the Mojo to function. This is used to validate the configuration
     * for a Mojo before it is injected, and before the Mojo is executed from some half-state.
     */
    final boolean required;
    /**
     * Specifies that this parameter can be configured directly by the user (as in the case of POM-specified
     * configuration). This is useful when you want to force the user to use common POM elements rather than
     * plugin configurations, as in the case where you want to use the artifact's final name as a parameter. In
     * this case, you want the user to modify {@code <build><finalName/></build>} rather
     * than specifying a value for finalName directly in the plugin configuration section. It is also useful to
     * ensure that - for example - a List-typed parameter which expects items of type Artifact doesn't get a List
     * full of Strings.
     */
    final boolean editable;
    /**
     * The description of this parameter's use inside the Mojo.
     */
    final String description;
    /**
     * Specify the version when the parameter was added to the API. Similar to Javadoc since.
     */
    final String since;
    /**
     * Description with the reason of parameter deprecation. Similar to Javadoc {@code @deprecated}.
     * This will trigger a warning when a user tries to configure a parameter marked as deprecated.
     */
    final String deprecated;
    /**
     * Parameter expression, to let user override default value with a user property, system property or project property.
     */
    final String expression;
    /**
     * The default value, as an expression that will be evaluated at injection or run-time.
     */
    final String defaultValue;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Parameter(Builder builder) {
        this.name = builder.name != null ? builder.name : (builder.base != null ? builder.base.name : null);
        this.alias = builder.alias != null ? builder.alias : (builder.base != null ? builder.base.alias : null);
        this.type = builder.type != null ? builder.type : (builder.base != null ? builder.base.type : null);
        this.required = builder.required != null ? builder.required : (builder.base != null ? builder.base.required : false);
        this.editable = builder.editable != null ? builder.editable : (builder.base != null ? builder.base.editable : true);
        this.description = builder.description != null ? builder.description : (builder.base != null ? builder.base.description : null);
        this.since = builder.since != null ? builder.since : (builder.base != null ? builder.base.since : null);
        this.deprecated = builder.deprecated != null ? builder.deprecated : (builder.base != null ? builder.base.deprecated : null);
        this.expression = builder.expression != null ? builder.expression : (builder.base != null ? builder.base.expression : null);
        this.defaultValue = builder.defaultValue != null ? builder.defaultValue : (builder.base != null ? builder.base.defaultValue : null);
    }

    /**
     * The name of the parameter, to be used while configuring this parameter from the Mojo's declared defaults
     * or from the POM.
     *
     * @return a {@code String}
     */
    public String getName() {
        return this.name;
    }

    /**
     * Specifies an alias which can be used to configure this parameter from the POM.
     * This is primarily useful to improve user-friendliness, where Mojo field names are not intuitive to the
     * user or are otherwise not conducive to configuration via the POM.
     *
     * @return a {@code String}
     */
    public String getAlias() {
        return this.alias;
    }

    /**
     * The Java type for this parameter. This is used to validate the result of any expressions used to calculate
     * the value which should be injected into the Mojo for this parameter.
     *
     * @return a {@code String}
     */
    public String getType() {
        return this.type;
    }

    /**
     * Whether this parameter is required for the Mojo to function. This is used to validate the configuration
     * for a Mojo before it is injected, and before the Mojo is executed from some half-state.
     *
     * @return a {@code boolean}
     */
    public boolean isRequired() {
        return this.required;
    }

    /**
     * Specifies that this parameter can be configured directly by the user (as in the case of POM-specified
     * configuration). This is useful when you want to force the user to use common POM elements rather than
     * plugin configurations, as in the case where you want to use the artifact's final name as a parameter. In
     * this case, you want the user to modify {@code <build><finalName/></build>} rather
     * than specifying a value for finalName directly in the plugin configuration section. It is also useful to
     * ensure that - for example - a List-typed parameter which expects items of type Artifact doesn't get a List
     * full of Strings.
     *
     * @return a {@code boolean}
     */
    public boolean isEditable() {
        return this.editable;
    }

    /**
     * The description of this parameter's use inside the Mojo.
     *
     * @return a {@code String}
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Specify the version when the parameter was added to the API. Similar to Javadoc since.
     *
     * @return a {@code String}
     */
    public String getSince() {
        return this.since;
    }

    /**
     * Description with the reason of parameter deprecation. Similar to Javadoc {@code @deprecated}.
     * This will trigger a warning when a user tries to configure a parameter marked as deprecated.
     *
     * @return a {@code String}
     */
    public String getDeprecated() {
        return this.deprecated;
    }

    /**
     * Parameter expression, to let user override default value with a user property, system property or project property.
     *
     * @return a {@code String}
     */
    public String getExpression() {
        return this.expression;
    }

    /**
     * The default value, as an expression that will be evaluated at injection or run-time.
     *
     * @return a {@code String}
     */
    public String getDefaultValue() {
        return this.defaultValue;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Parameter} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code Parameter} with the specified name
     */
    @Nonnull
    public Parameter withName(String name) {
        return newBuilder(this, true).name(name).build();
    }
    /**
     * Creates a new {@code Parameter} instance using the specified alias.
     *
     * @param alias the new {@code String} to use
     * @return a {@code Parameter} with the specified alias
     */
    @Nonnull
    public Parameter withAlias(String alias) {
        return newBuilder(this, true).alias(alias).build();
    }
    /**
     * Creates a new {@code Parameter} instance using the specified type.
     *
     * @param type the new {@code String} to use
     * @return a {@code Parameter} with the specified type
     */
    @Nonnull
    public Parameter withType(String type) {
        return newBuilder(this, true).type(type).build();
    }
    /**
     * Creates a new {@code Parameter} instance using the specified required.
     *
     * @param required the new {@code boolean} to use
     * @return a {@code Parameter} with the specified required
     */
    @Nonnull
    public Parameter withRequired(boolean required) {
        return newBuilder(this, true).required(required).build();
    }
    /**
     * Creates a new {@code Parameter} instance using the specified editable.
     *
     * @param editable the new {@code boolean} to use
     * @return a {@code Parameter} with the specified editable
     */
    @Nonnull
    public Parameter withEditable(boolean editable) {
        return newBuilder(this, true).editable(editable).build();
    }
    /**
     * Creates a new {@code Parameter} instance using the specified description.
     *
     * @param description the new {@code String} to use
     * @return a {@code Parameter} with the specified description
     */
    @Nonnull
    public Parameter withDescription(String description) {
        return newBuilder(this, true).description(description).build();
    }
    /**
     * Creates a new {@code Parameter} instance using the specified since.
     *
     * @param since the new {@code String} to use
     * @return a {@code Parameter} with the specified since
     */
    @Nonnull
    public Parameter withSince(String since) {
        return newBuilder(this, true).since(since).build();
    }
    /**
     * Creates a new {@code Parameter} instance using the specified deprecated.
     *
     * @param deprecated the new {@code String} to use
     * @return a {@code Parameter} with the specified deprecated
     */
    @Nonnull
    public Parameter withDeprecated(String deprecated) {
        return newBuilder(this, true).deprecated(deprecated).build();
    }
    /**
     * Creates a new {@code Parameter} instance using the specified expression.
     *
     * @param expression the new {@code String} to use
     * @return a {@code Parameter} with the specified expression
     */
    @Nonnull
    public Parameter withExpression(String expression) {
        return newBuilder(this, true).expression(expression).build();
    }
    /**
     * Creates a new {@code Parameter} instance using the specified defaultValue.
     *
     * @param defaultValue the new {@code String} to use
     * @return a {@code Parameter} with the specified defaultValue
     */
    @Nonnull
    public Parameter withDefaultValue(String defaultValue) {
        return newBuilder(this, true).defaultValue(defaultValue).build();
    }

    /**
     * Creates a new {@code Parameter} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Parameter}
     */
    @Nonnull
    public static Parameter newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Parameter} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Parameter}
     */
    @Nonnull
    public static Parameter newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Parameter} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Parameter} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Parameter} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Parameter} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Parameter from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Parameter} builder instance using the specified object as a basis.
     *
     * @param from the {@code Parameter} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Parameter from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Parameter instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Parameter base;
        String name;
        String alias;
        String type;
        Boolean required;
        Boolean editable;
        String description;
        String since;
        String deprecated;
        String expression;
        String defaultValue;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                this.required = false;
                this.editable = true;
            }
        }

        protected Builder(Parameter base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.alias = base.alias;
                this.type = base.type;
                this.required = base.required;
                this.editable = base.editable;
                this.description = base.description;
                this.since = base.since;
                this.deprecated = base.deprecated;
                this.expression = base.expression;
                this.defaultValue = base.defaultValue;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Nonnull
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        @Nonnull
        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        @Nonnull
        public Builder editable(boolean editable) {
            this.editable = editable;
            return this;
        }

        @Nonnull
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder since(String since) {
            this.since = since;
            return this;
        }

        @Nonnull
        public Builder deprecated(String deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        @Nonnull
        public Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        @Nonnull
        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }


        @Nonnull
        public Parameter build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (name == null || name == base.name)
                    && (alias == null || alias == base.alias)
                    && (type == null || type == base.type)
                    && (required == null || required == base.required)
                    && (editable == null || editable == base.editable)
                    && (description == null || description == base.description)
                    && (since == null || since == base.since)
                    && (deprecated == null || deprecated == base.deprecated)
                    && (expression == null || expression == base.expression)
                    && (defaultValue == null || defaultValue == base.defaultValue)
            ) {
                return base;
            }
            return new Parameter(this);
        }
    }

}
