/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ConfigurationContainer;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.ReportSet;
import org.apache.maven.api.xml.XmlNode;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class ReportPlugin
extends ConfigurationContainer
implements Serializable,
InputLocationTracker {
    final String groupId;
    final String artifactId;
    final String version;
    final List<ReportSet> reportSets;
    final Map<Object, InputLocation> locations;
    private Map<String, ReportSet> reportSetMap = null;

    protected ReportPlugin(Builder builder) {
        super(builder);
        String string = builder.groupId != null ? builder.groupId : (this.groupId = builder.base != null ? builder.base.groupId : null);
        String string2 = builder.artifactId != null ? builder.artifactId : (this.artifactId = builder.base != null ? builder.base.artifactId : null);
        String string3 = builder.version != null ? builder.version : (this.version = builder.base != null ? builder.base.version : null);
        this.reportSets = ImmutableCollections.copy(builder.reportSets != null ? builder.reportSets : (builder.base != null ? builder.base.reportSets : null));
        Map newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<Object, InputLocation> mutableLocations = new HashMap<Object, InputLocation>(((ConfigurationContainer)this).locations);
        mutableLocations.put("groupId", newlocs.containsKey("groupId") ? (InputLocation)newlocs.get("groupId") : (InputLocation)oldlocs.get("groupId"));
        mutableLocations.put("artifactId", newlocs.containsKey("artifactId") ? (InputLocation)newlocs.get("artifactId") : (InputLocation)oldlocs.get("artifactId"));
        mutableLocations.put("version", newlocs.containsKey("version") ? (InputLocation)newlocs.get("version") : (InputLocation)oldlocs.get("version"));
        mutableLocations.put("reportSets", newlocs.containsKey("reportSets") ? (InputLocation)newlocs.get("reportSets") : (InputLocation)oldlocs.get("reportSets"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    @Nonnull
    public List<ReportSet> getReportSets() {
        return this.reportSets;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Override
    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    @Override
    @Nonnull
    public Builder with() {
        return ReportPlugin.newBuilder(this);
    }

    @Override
    @Nonnull
    public ReportPlugin withInherited(String inherited) {
        return ReportPlugin.newBuilder(this, true).inherited(inherited).build();
    }

    @Override
    @Nonnull
    public ReportPlugin withConfiguration(XmlNode configuration) {
        return ReportPlugin.newBuilder(this, true).configuration(configuration).build();
    }

    @Nonnull
    public ReportPlugin withGroupId(String groupId) {
        return ReportPlugin.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public ReportPlugin withArtifactId(String artifactId) {
        return ReportPlugin.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public ReportPlugin withVersion(String version) {
        return ReportPlugin.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public ReportPlugin withReportSets(Collection<ReportSet> reportSets) {
        return ReportPlugin.newBuilder(this, true).reportSets(reportSets).build();
    }

    @Nonnull
    public static ReportPlugin newInstance() {
        return ReportPlugin.newInstance(true);
    }

    @Nonnull
    public static ReportPlugin newInstance(boolean withDefaults) {
        return ReportPlugin.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return ReportPlugin.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(ReportPlugin from) {
        return ReportPlugin.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(ReportPlugin from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public void flushReportSetMap() {
        this.reportSetMap = null;
    }

    public Map<String, ReportSet> getReportSetsAsMap() {
        if (this.reportSetMap == null) {
            this.reportSetMap = new LinkedHashMap<String, ReportSet>();
            if (this.getReportSets() != null) {
                for (ReportSet reportSet : this.getReportSets()) {
                    this.reportSetMap.put(reportSet.getId(), reportSet);
                }
            }
        }
        return this.reportSetMap;
    }

    public String getKey() {
        return ReportPlugin.constructKey(this.getGroupId(), this.getArtifactId());
    }

    public static String constructKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    @NotThreadSafe
    public static class Builder
    extends ConfigurationContainer.Builder {
        ReportPlugin base;
        String groupId;
        String artifactId;
        String version;
        Collection<ReportSet> reportSets;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.groupId = "org.apache.maven.plugins";
            }
        }

        protected Builder(ReportPlugin base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.reportSets = base.reportSets;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder inherited(String inherited) {
            this.inherited = inherited;
            return this;
        }

        @Override
        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder reportSets(Collection<ReportSet> reportSets) {
            this.reportSets = reportSets;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public ReportPlugin build() {
            if (!(this.base == null || this.inherited != null && this.inherited != this.base.inherited || this.configuration != null && this.configuration != this.base.configuration || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.reportSets != null && this.reportSets != this.base.reportSets)) {
                return this.base;
            }
            return new ReportPlugin(this);
        }
    }
}

