// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.xml.XmlNode;

/**
 * Represents a set of reports and configuration to be used to generate them.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class ReportSet
    extends ConfigurationContainer
    implements Serializable, InputLocationTracker
{
    /**
     * The unique id for this report set, to be used during POM inheritance and profile injection
     * for merging of report sets.
     */
    final String id;
    /**
     * The list of reports from this plugin which should be generated from this set.
     */
    final List<String> reports;
    /** Locations (this potentially hides the same name field from the super class) */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected ReportSet(Builder builder) {
        super(builder);
        this.id = builder.id != null ? builder.id : (builder.base != null ? builder.base.id : null);
        this.reports = ImmutableCollections.copy(builder.reports != null ? builder.reports : (builder.base != null ? builder.base.reports : null));
        Map<Object, InputLocation> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map<Object, InputLocation> oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        Map<Object, InputLocation> mutableLocations = new HashMap<>(super.locations);
        mutableLocations.put("id", newlocs.containsKey("id") ? newlocs.get("id") : oldlocs.get("id"));
        mutableLocations.put("reports", newlocs.containsKey("reports") ? newlocs.get("reports") : oldlocs.get("reports"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    /**
     * The unique id for this report set, to be used during POM inheritance and profile injection
     * for merging of report sets.
     *
     * @return a {@code String}
     */
    public String getId() {
        return this.id;
    }

    /**
     * The list of reports from this plugin which should be generated from this set.
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getReports() {
        return this.reports;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
    * Gets the keys of the locations of the input source.
    */
    public Set<Object> getLocationKeys() {
        return locations != null ? locations.keySet() : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code ReportSet} instance using the specified inherited.
     *
     * @param inherited the new {@code String} to use
     * @return a {@code ReportSet} with the specified inherited
     */
    @Nonnull
    public ReportSet withInherited(String inherited) {
        return newBuilder(this, true).inherited(inherited).build();
    }
    /**
     * Creates a new {@code ReportSet} instance using the specified configuration.
     *
     * @param configuration the new {@code XmlNode} to use
     * @return a {@code ReportSet} with the specified configuration
     */
    @Nonnull
    public ReportSet withConfiguration(XmlNode configuration) {
        return newBuilder(this, true).configuration(configuration).build();
    }
    /**
     * Creates a new {@code ReportSet} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code ReportSet} with the specified id
     */
    @Nonnull
    public ReportSet withId(String id) {
        return newBuilder(this, true).id(id).build();
    }
    /**
     * Creates a new {@code ReportSet} instance using the specified reports.
     *
     * @param reports the new {@code Collection<String>} to use
     * @return a {@code ReportSet} with the specified reports
     */
    @Nonnull
    public ReportSet withReports(Collection<String> reports) {
        return newBuilder(this, true).reports(reports).build();
    }

    /**
     * Creates a new {@code ReportSet} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code ReportSet}
     */
    @Nonnull
    public static ReportSet newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code ReportSet} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code ReportSet}
     */
    @Nonnull
    public static ReportSet newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code ReportSet} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code ReportSet} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code ReportSet} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code ReportSet} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(ReportSet from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code ReportSet} builder instance using the specified object as a basis.
     *
     * @param from the {@code ReportSet} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(ReportSet from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create ReportSet instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends ConfigurationContainer.Builder
    {
        ReportSet base;
        String id;
        Collection<String> reports;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.id = "default";
            }
        }

        protected Builder(ReportSet base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
                this.reports = base.reports;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder inherited(String inherited) {
            this.inherited = inherited;
            return this;
        }

        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder reports(Collection<String> reports) {
            this.reports = reports;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public ReportSet build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (inherited == null || inherited == base.inherited)
                    && (configuration == null || configuration == base.configuration)
                    && (id == null || id == base.id)
                    && (reports == null || reports == base.reports)
            ) {
                return base;
            }
            return new ReportSet(this);
        }
    }


            
    @Override
    public String toString() {
        return getId();
    }
            
          
}
