/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.FileSet;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Resource
extends FileSet
implements Serializable,
InputLocationTracker {
    final String targetPath;
    final String filtering;
    final String mergeId;
    final InputLocation targetPathLocation;
    final InputLocation filteringLocation;
    final InputLocation mergeIdLocation;

    Resource(Collection<String> includes, Collection<String> excludes, String directory, String targetPath, String filtering, String mergeId, Map<Object, InputLocation> locations, InputLocation location, InputLocation includesLocation, InputLocation excludesLocation, InputLocation directoryLocation, InputLocation targetPathLocation, InputLocation filteringLocation, InputLocation mergeIdLocation) {
        super(includes, excludes, directory, locations, location, includesLocation, excludesLocation, directoryLocation);
        this.targetPath = targetPath;
        this.filtering = filtering;
        this.mergeId = mergeId;
        this.targetPathLocation = targetPathLocation;
        this.filteringLocation = filteringLocation;
        this.mergeIdLocation = mergeIdLocation;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public String getFiltering() {
        return this.filtering;
    }

    public String getMergeId() {
        return this.mergeId;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "targetPath": {
                    return this.targetPathLocation;
                }
                case "filtering": {
                    return this.filteringLocation;
                }
                case "mergeId": {
                    return this.mergeIdLocation;
                }
            }
        }
        return super.getLocation(key);
    }

    @Override
    @Nonnull
    public Builder with() {
        return Resource.newBuilder(this);
    }

    @Override
    @Nonnull
    public Resource withIncludes(Collection<String> includes) {
        return ((Builder)this.with().includes((Collection)includes)).build();
    }

    @Override
    @Nonnull
    public Resource withExcludes(Collection<String> excludes) {
        return ((Builder)this.with().excludes((Collection)excludes)).build();
    }

    @Override
    @Nonnull
    public Resource withDirectory(String directory) {
        return this.with().directory(directory).build();
    }

    @Nonnull
    public Resource withTargetPath(String targetPath) {
        return this.with().targetPath(targetPath).build();
    }

    @Nonnull
    public Resource withFiltering(String filtering) {
        return this.with().filtering(filtering).build();
    }

    @Nonnull
    public Resource withMergeId(String mergeId) {
        return this.with().mergeId(mergeId).build();
    }

    @Nonnull
    public static Resource newInstance() {
        return Resource.newInstance(true);
    }

    @Nonnull
    public static Resource newInstance(boolean withDefaults) {
        return Resource.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Resource.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Resource from) {
        return Resource.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Resource from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isFiltering() {
        return this.getFiltering() != null ? Boolean.parseBoolean(this.getFiltering()) : false;
    }

    @Override
    public String toString() {
        return "Resource {targetPath: " + this.getTargetPath() + ", filtering: " + this.isFiltering() + ", " + super.toString() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends FileSet.Builder {
        Resource base;
        String targetPath;
        String filtering;
        String mergeId;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Resource base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.targetPath = base.targetPath;
                this.filtering = base.filtering;
                this.mergeId = base.mergeId;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder includes(Collection<String> includes) {
            this.includes = includes;
            return this;
        }

        @Override
        @Nonnull
        public Builder excludes(Collection<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        @Override
        @Nonnull
        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Nonnull
        public Builder targetPath(String targetPath) {
            this.targetPath = targetPath;
            return this;
        }

        @Nonnull
        public Builder filtering(String filtering) {
            this.filtering = filtering;
            return this;
        }

        @Nonnull
        public Builder mergeId(String mergeId) {
            this.mergeId = mergeId;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Resource build() {
            if (!(this.base == null || this.includes != null && this.includes != this.base.includes || this.excludes != null && this.excludes != this.base.excludes || this.directory != null && this.directory != this.base.directory || this.targetPath != null && this.targetPath != this.base.targetPath || this.filtering != null && this.filtering != this.base.filtering || this.mergeId != null && this.mergeId != this.base.mergeId)) {
                return this.base;
            }
            Map locations = null;
            InputLocation location = null;
            InputLocation includesLocation = null;
            InputLocation excludesLocation = null;
            InputLocation directoryLocation = null;
            InputLocation targetPathLocation = null;
            InputLocation filteringLocation = null;
            InputLocation mergeIdLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = (InputLocation)locations.remove("");
                includesLocation = (InputLocation)locations.remove("includes");
                excludesLocation = (InputLocation)locations.remove("excludes");
                directoryLocation = (InputLocation)locations.remove("directory");
                targetPathLocation = (InputLocation)locations.remove("targetPath");
                filteringLocation = (InputLocation)locations.remove("filtering");
                mergeIdLocation = (InputLocation)locations.remove("mergeId");
            }
            return new Resource(this.includes != null ? this.includes : (this.base != null ? this.base.includes : null), this.excludes != null ? this.excludes : (this.base != null ? this.base.excludes : null), this.directory != null ? this.directory : (this.base != null ? this.base.directory : null), this.targetPath != null ? this.targetPath : (this.base != null ? this.base.targetPath : null), this.filtering != null ? this.filtering : (this.base != null ? this.base.filtering : null), this.mergeId != null ? this.mergeId : (this.base != null ? this.base.mergeId : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), includesLocation != null ? includesLocation : (this.base != null ? this.base.includesLocation : null), excludesLocation != null ? excludesLocation : (this.base != null ? this.base.excludesLocation : null), directoryLocation != null ? directoryLocation : (this.base != null ? this.base.directoryLocation : null), targetPathLocation != null ? targetPathLocation : (this.base != null ? this.base.targetPathLocation : null), filteringLocation != null ? filteringLocation : (this.base != null ? this.base.filteringLocation : null), mergeIdLocation != null ? mergeIdLocation : (this.base != null ? this.base.mergeIdLocation : null));
        }
    }
}

