/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginContainer;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PluginManagement
extends PluginContainer
implements Serializable,
InputLocationTracker {
    PluginManagement(Collection<Plugin> plugins, Map<Object, InputLocation> locations, InputLocation location, InputLocation pluginsLocation) {
        super(plugins, locations, location, pluginsLocation);
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            ((String)key).getClass();
        }
        return super.getLocation(key);
    }

    @Override
    @Nonnull
    public Builder with() {
        return PluginManagement.newBuilder(this);
    }

    @Override
    @Nonnull
    public PluginManagement withPlugins(Collection<Plugin> plugins) {
        return ((Builder)this.with().plugins((Collection)plugins)).build();
    }

    @Nonnull
    public static PluginManagement newInstance() {
        return PluginManagement.newInstance(true);
    }

    @Nonnull
    public static PluginManagement newInstance(boolean withDefaults) {
        return PluginManagement.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PluginManagement.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PluginManagement from) {
        return PluginManagement.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PluginManagement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends PluginContainer.Builder {
        PluginManagement base;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(PluginManagement base, boolean forceCopy) {
            super(base, forceCopy);
            if (!forceCopy) {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public PluginManagement build() {
            if (this.base != null && (this.plugins == null || this.plugins == this.base.plugins)) {
                return this.base;
            }
            Map locations = null;
            InputLocation location = null;
            InputLocation pluginsLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = (InputLocation)locations.remove("");
                pluginsLocation = (InputLocation)locations.remove("plugins");
            }
            return new PluginManagement(this.plugins != null ? this.plugins : (this.base != null ? this.base.plugins : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), pluginsLocation != null ? pluginsLocation : (this.base != null ? this.base.pluginsLocation : null));
        }
    }
}

