/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ConfigurationContainer;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.xml.Dom;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Plugin
extends ConfigurationContainer
implements Serializable,
InputLocationTracker {
    final String groupId;
    final String artifactId;
    final String version;
    final String extensions;
    final List<PluginExecution> executions;
    final List<Dependency> dependencies;
    final InputLocation groupIdLocation;
    final InputLocation artifactIdLocation;
    final InputLocation versionLocation;
    final InputLocation extensionsLocation;
    final InputLocation executionsLocation;
    final InputLocation dependenciesLocation;
    private Map<String, PluginExecution> executionMap = null;

    Plugin(String inherited, Dom configuration, String groupId, String artifactId, String version, String extensions, Collection<PluginExecution> executions, Collection<Dependency> dependencies, Map<Object, InputLocation> locations, InputLocation location, InputLocation inheritedLocation, InputLocation configurationLocation, InputLocation groupIdLocation, InputLocation artifactIdLocation, InputLocation versionLocation, InputLocation extensionsLocation, InputLocation executionsLocation, InputLocation dependenciesLocation) {
        super(inherited, configuration, locations, location, inheritedLocation, configurationLocation);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.extensions = extensions;
        this.executions = ImmutableCollections.copy(executions);
        this.dependencies = ImmutableCollections.copy(dependencies);
        this.groupIdLocation = groupIdLocation;
        this.artifactIdLocation = artifactIdLocation;
        this.versionLocation = versionLocation;
        this.extensionsLocation = extensionsLocation;
        this.executionsLocation = executionsLocation;
        this.dependenciesLocation = dependenciesLocation;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getExtensions() {
        return this.extensions;
    }

    @Nonnull
    public List<PluginExecution> getExecutions() {
        return this.executions;
    }

    @Nonnull
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "groupId": {
                    return this.groupIdLocation;
                }
                case "artifactId": {
                    return this.artifactIdLocation;
                }
                case "version": {
                    return this.versionLocation;
                }
                case "extensions": {
                    return this.extensionsLocation;
                }
                case "executions": {
                    return this.executionsLocation;
                }
                case "dependencies": {
                    return this.dependenciesLocation;
                }
            }
        }
        return super.getLocation(key);
    }

    @Override
    @Nonnull
    public Builder with() {
        return Plugin.newBuilder(this);
    }

    @Override
    @Nonnull
    public Plugin withInherited(String inherited) {
        return this.with().inherited(inherited).build();
    }

    @Override
    @Nonnull
    public Plugin withConfiguration(Dom configuration) {
        return this.with().configuration(configuration).build();
    }

    @Nonnull
    public Plugin withGroupId(String groupId) {
        return this.with().groupId(groupId).build();
    }

    @Nonnull
    public Plugin withArtifactId(String artifactId) {
        return this.with().artifactId(artifactId).build();
    }

    @Nonnull
    public Plugin withVersion(String version) {
        return this.with().version(version).build();
    }

    @Nonnull
    public Plugin withExtensions(String extensions) {
        return this.with().extensions(extensions).build();
    }

    @Nonnull
    public Plugin withExecutions(Collection<PluginExecution> executions) {
        return this.with().executions(executions).build();
    }

    @Nonnull
    public Plugin withDependencies(Collection<Dependency> dependencies) {
        return this.with().dependencies(dependencies).build();
    }

    @Nonnull
    public static Plugin newInstance() {
        return Plugin.newInstance(true);
    }

    @Nonnull
    public static Plugin newInstance(boolean withDefaults) {
        return Plugin.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Plugin.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Plugin from) {
        return Plugin.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Plugin from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isExtensions() {
        return this.getExtensions() != null ? Boolean.parseBoolean(this.getExtensions()) : false;
    }

    public void flushExecutionMap() {
        this.executionMap = null;
    }

    public Map<String, PluginExecution> getExecutionsAsMap() {
        if (this.executionMap == null) {
            this.executionMap = new LinkedHashMap<String, PluginExecution>();
            for (PluginExecution exec : this.getExecutions()) {
                if (this.executionMap.containsKey(exec.getId())) {
                    throw new IllegalStateException("You cannot have two plugin executions with the same (or missing) <id/> elements.\nOffending execution\n\nId: '" + exec.getId() + "'\nPlugin:'" + this.getKey() + "'\n\n");
                }
                this.executionMap.put(exec.getId(), exec);
            }
        }
        return this.executionMap;
    }

    public String getId() {
        StringBuilder id = new StringBuilder(128);
        id.append(this.getGroupId() == null ? "[unknown-group-id]" : this.getGroupId());
        id.append(":");
        id.append(this.getArtifactId() == null ? "[unknown-artifact-id]" : this.getArtifactId());
        id.append(":");
        id.append(this.getVersion() == null ? "[unknown-version]" : this.getVersion());
        return id.toString();
    }

    public String getKey() {
        return Plugin.constructKey(this.getGroupId(), this.getArtifactId());
    }

    public static String constructKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public boolean equals(Object other) {
        if (other instanceof Plugin) {
            Plugin otherPlugin = (Plugin)other;
            return this.getKey().equals(otherPlugin.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "Plugin [" + this.getKey() + "]";
    }

    @NotThreadSafe
    public static class Builder
    extends ConfigurationContainer.Builder {
        Plugin base;
        String groupId;
        String artifactId;
        String version;
        String extensions;
        Collection<PluginExecution> executions;
        Collection<Dependency> dependencies;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.groupId = "org.apache.maven.plugins";
            }
        }

        Builder(Plugin base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.extensions = base.extensions;
                this.executions = base.executions;
                this.dependencies = base.dependencies;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder inherited(String inherited) {
            this.inherited = inherited;
            return this;
        }

        @Override
        @Nonnull
        public Builder configuration(Dom configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder extensions(String extensions) {
            this.extensions = extensions;
            return this;
        }

        @Nonnull
        public Builder executions(Collection<PluginExecution> executions) {
            this.executions = executions;
            return this;
        }

        @Nonnull
        public Builder dependencies(Collection<Dependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Plugin build() {
            if (!(this.base == null || this.inherited != null && this.inherited != this.base.inherited || this.configuration != null && this.configuration != this.base.configuration || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.extensions != null && this.extensions != this.base.extensions || this.executions != null && this.executions != this.base.executions || this.dependencies != null && this.dependencies != this.base.dependencies)) {
                return this.base;
            }
            Map locations = null;
            InputLocation location = null;
            InputLocation inheritedLocation = null;
            InputLocation configurationLocation = null;
            InputLocation groupIdLocation = null;
            InputLocation artifactIdLocation = null;
            InputLocation versionLocation = null;
            InputLocation extensionsLocation = null;
            InputLocation executionsLocation = null;
            InputLocation dependenciesLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = (InputLocation)locations.remove("");
                inheritedLocation = (InputLocation)locations.remove("inherited");
                configurationLocation = (InputLocation)locations.remove("configuration");
                groupIdLocation = (InputLocation)locations.remove("groupId");
                artifactIdLocation = (InputLocation)locations.remove("artifactId");
                versionLocation = (InputLocation)locations.remove("version");
                extensionsLocation = (InputLocation)locations.remove("extensions");
                executionsLocation = (InputLocation)locations.remove("executions");
                dependenciesLocation = (InputLocation)locations.remove("dependencies");
            }
            return new Plugin(this.inherited != null ? this.inherited : (this.base != null ? this.base.inherited : null), (Dom)(this.configuration != null ? this.configuration : (this.base != null ? this.base.configuration : null)), this.groupId != null ? this.groupId : (this.base != null ? this.base.groupId : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), this.extensions != null ? this.extensions : (this.base != null ? this.base.extensions : null), this.executions != null ? this.executions : (this.base != null ? this.base.executions : null), this.dependencies != null ? this.dependencies : (this.base != null ? this.base.dependencies : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), inheritedLocation != null ? inheritedLocation : (this.base != null ? this.base.inheritedLocation : null), configurationLocation != null ? configurationLocation : (this.base != null ? this.base.configurationLocation : null), groupIdLocation != null ? groupIdLocation : (this.base != null ? this.base.groupIdLocation : null), artifactIdLocation != null ? artifactIdLocation : (this.base != null ? this.base.artifactIdLocation : null), versionLocation != null ? versionLocation : (this.base != null ? this.base.versionLocation : null), extensionsLocation != null ? extensionsLocation : (this.base != null ? this.base.extensionsLocation : null), executionsLocation != null ? executionsLocation : (this.base != null ? this.base.executionsLocation : null), dependenciesLocation != null ? dependenciesLocation : (this.base != null ? this.base.dependenciesLocation : null));
        }
    }
}

