/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class IssueManagement
implements Serializable,
InputLocationTracker {
    final String system;
    final String url;
    final InputLocation location;
    final InputLocation systemLocation;
    final InputLocation urlLocation;
    final Map<Object, InputLocation> locations;

    IssueManagement(String system, String url, Map<Object, InputLocation> locations, InputLocation location, InputLocation systemLocation, InputLocation urlLocation) {
        this.system = system;
        this.url = url;
        this.locations = ImmutableCollections.copy(locations);
        this.location = location;
        this.systemLocation = systemLocation;
        this.urlLocation = urlLocation;
    }

    public String getSystem() {
        return this.system;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "system": {
                    return this.systemLocation;
                }
                case "url": {
                    return this.urlLocation;
                }
            }
        }
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return IssueManagement.newBuilder(this);
    }

    @Nonnull
    public IssueManagement withSystem(String system) {
        return this.with().system(system).build();
    }

    @Nonnull
    public IssueManagement withUrl(String url) {
        return this.with().url(url).build();
    }

    @Nonnull
    public static IssueManagement newInstance() {
        return IssueManagement.newInstance(true);
    }

    @Nonnull
    public static IssueManagement newInstance(boolean withDefaults) {
        return IssueManagement.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return IssueManagement.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(IssueManagement from) {
        return IssueManagement.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(IssueManagement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        IssueManagement base;
        String system;
        String url;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(IssueManagement base, boolean forceCopy) {
            if (forceCopy) {
                this.system = base.system;
                this.url = base.url;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder system(String system) {
            this.system = system;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap<Object, InputLocation>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public IssueManagement build() {
            if (!(this.base == null || this.system != null && this.system != this.base.system || this.url != null && this.url != this.base.url)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation systemLocation = null;
            InputLocation urlLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = locations.remove("");
                systemLocation = locations.remove("system");
                urlLocation = locations.remove("url");
            }
            return new IssueManagement(this.system != null ? this.system : (this.base != null ? this.base.system : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), systemLocation != null ? systemLocation : (this.base != null ? this.base.systemLocation : null), urlLocation != null ? urlLocation : (this.base != null ? this.base.urlLocation : null));
        }
    }
}

