/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Notifier;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class CiManagement
implements Serializable,
InputLocationTracker {
    final String system;
    final String url;
    final List<Notifier> notifiers;
    final InputLocation location;
    final InputLocation systemLocation;
    final InputLocation urlLocation;
    final InputLocation notifiersLocation;
    final Map<Object, InputLocation> locations;

    CiManagement(String system, String url, Collection<Notifier> notifiers, Map<Object, InputLocation> locations, InputLocation location, InputLocation systemLocation, InputLocation urlLocation, InputLocation notifiersLocation) {
        this.system = system;
        this.url = url;
        this.notifiers = ImmutableCollections.copy(notifiers);
        this.locations = ImmutableCollections.copy(locations);
        this.location = location;
        this.systemLocation = systemLocation;
        this.urlLocation = urlLocation;
        this.notifiersLocation = notifiersLocation;
    }

    public String getSystem() {
        return this.system;
    }

    public String getUrl() {
        return this.url;
    }

    @Nonnull
    public List<Notifier> getNotifiers() {
        return this.notifiers;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "system": {
                    return this.systemLocation;
                }
                case "url": {
                    return this.urlLocation;
                }
                case "notifiers": {
                    return this.notifiersLocation;
                }
            }
        }
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return CiManagement.newBuilder(this);
    }

    @Nonnull
    public CiManagement withSystem(String system) {
        return this.with().system(system).build();
    }

    @Nonnull
    public CiManagement withUrl(String url) {
        return this.with().url(url).build();
    }

    @Nonnull
    public CiManagement withNotifiers(Collection<Notifier> notifiers) {
        return this.with().notifiers(notifiers).build();
    }

    @Nonnull
    public static CiManagement newInstance() {
        return CiManagement.newInstance(true);
    }

    @Nonnull
    public static CiManagement newInstance(boolean withDefaults) {
        return CiManagement.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return CiManagement.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(CiManagement from) {
        return CiManagement.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(CiManagement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        CiManagement base;
        String system;
        String url;
        Collection<Notifier> notifiers;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(CiManagement base, boolean forceCopy) {
            if (forceCopy) {
                this.system = base.system;
                this.url = base.url;
                this.notifiers = base.notifiers;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder system(String system) {
            this.system = system;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder notifiers(Collection<Notifier> notifiers) {
            this.notifiers = notifiers;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap<Object, InputLocation>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public CiManagement build() {
            if (!(this.base == null || this.system != null && this.system != this.base.system || this.url != null && this.url != this.base.url || this.notifiers != null && this.notifiers != this.base.notifiers)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation systemLocation = null;
            InputLocation urlLocation = null;
            InputLocation notifiersLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = locations.remove("");
                systemLocation = locations.remove("system");
                urlLocation = locations.remove("url");
                notifiersLocation = locations.remove("notifiers");
            }
            return new CiManagement(this.system != null ? this.system : (this.base != null ? this.base.system : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), this.notifiers != null ? this.notifiers : (this.base != null ? this.base.notifiers : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), systemLocation != null ? systemLocation : (this.base != null ? this.base.systemLocation : null), urlLocation != null ? urlLocation : (this.base != null ? this.base.urlLocation : null), notifiersLocation != null ? notifiersLocation : (this.base != null ? this.base.notifiersLocation : null));
        }
    }
}

