/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ActivationFile;
import org.apache.maven.api.model.ActivationOS;
import org.apache.maven.api.model.ActivationProperty;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Activation
implements Serializable,
InputLocationTracker {
    final boolean activeByDefault;
    final String jdk;
    final ActivationOS os;
    final ActivationProperty property;
    final ActivationFile file;
    final InputLocation location;
    final InputLocation activeByDefaultLocation;
    final InputLocation jdkLocation;
    final InputLocation osLocation;
    final InputLocation propertyLocation;
    final InputLocation fileLocation;
    final Map<Object, InputLocation> locations;

    Activation(boolean activeByDefault, String jdk, ActivationOS os, ActivationProperty property, ActivationFile file, Map<Object, InputLocation> locations, InputLocation location, InputLocation activeByDefaultLocation, InputLocation jdkLocation, InputLocation osLocation, InputLocation propertyLocation, InputLocation fileLocation) {
        this.activeByDefault = activeByDefault;
        this.jdk = jdk;
        this.os = os;
        this.property = property;
        this.file = file;
        this.locations = ImmutableCollections.copy(locations);
        this.location = location;
        this.activeByDefaultLocation = activeByDefaultLocation;
        this.jdkLocation = jdkLocation;
        this.osLocation = osLocation;
        this.propertyLocation = propertyLocation;
        this.fileLocation = fileLocation;
    }

    public boolean isActiveByDefault() {
        return this.activeByDefault;
    }

    public String getJdk() {
        return this.jdk;
    }

    public ActivationOS getOs() {
        return this.os;
    }

    public ActivationProperty getProperty() {
        return this.property;
    }

    public ActivationFile getFile() {
        return this.file;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "activeByDefault": {
                    return this.activeByDefaultLocation;
                }
                case "jdk": {
                    return this.jdkLocation;
                }
                case "os": {
                    return this.osLocation;
                }
                case "property": {
                    return this.propertyLocation;
                }
                case "file": {
                    return this.fileLocation;
                }
            }
        }
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Activation.newBuilder(this);
    }

    @Nonnull
    public Activation withActiveByDefault(boolean activeByDefault) {
        return this.with().activeByDefault(activeByDefault).build();
    }

    @Nonnull
    public Activation withJdk(String jdk) {
        return this.with().jdk(jdk).build();
    }

    @Nonnull
    public Activation withOs(ActivationOS os) {
        return this.with().os(os).build();
    }

    @Nonnull
    public Activation withProperty(ActivationProperty property) {
        return this.with().property(property).build();
    }

    @Nonnull
    public Activation withFile(ActivationFile file) {
        return this.with().file(file).build();
    }

    @Nonnull
    public static Activation newInstance() {
        return Activation.newInstance(true);
    }

    @Nonnull
    public static Activation newInstance(boolean withDefaults) {
        return Activation.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Activation.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Activation from) {
        return Activation.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Activation from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Activation base;
        Boolean activeByDefault;
        String jdk;
        ActivationOS os;
        ActivationProperty property;
        ActivationFile file;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.activeByDefault = false;
            }
        }

        Builder(Activation base, boolean forceCopy) {
            if (forceCopy) {
                this.activeByDefault = base.activeByDefault;
                this.jdk = base.jdk;
                this.os = base.os;
                this.property = base.property;
                this.file = base.file;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder activeByDefault(boolean activeByDefault) {
            this.activeByDefault = activeByDefault;
            return this;
        }

        @Nonnull
        public Builder jdk(String jdk) {
            this.jdk = jdk;
            return this;
        }

        @Nonnull
        public Builder os(ActivationOS os) {
            this.os = os;
            return this;
        }

        @Nonnull
        public Builder property(ActivationProperty property) {
            this.property = property;
            return this;
        }

        @Nonnull
        public Builder file(ActivationFile file) {
            this.file = file;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap<Object, InputLocation>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Activation build() {
            if (!(this.base == null || this.activeByDefault != null && this.activeByDefault != this.base.activeByDefault || this.jdk != null && this.jdk != this.base.jdk || this.os != null && this.os != this.base.os || this.property != null && this.property != this.base.property || this.file != null && this.file != this.base.file)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation activeByDefaultLocation = null;
            InputLocation jdkLocation = null;
            InputLocation osLocation = null;
            InputLocation propertyLocation = null;
            InputLocation fileLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = locations.remove("");
                activeByDefaultLocation = locations.remove("activeByDefault");
                jdkLocation = locations.remove("jdk");
                osLocation = locations.remove("os");
                propertyLocation = locations.remove("property");
                fileLocation = locations.remove("file");
            }
            return new Activation(this.activeByDefault != null ? this.activeByDefault : (this.base != null ? this.base.activeByDefault : false), this.jdk != null ? this.jdk : (this.base != null ? this.base.jdk : null), this.os != null ? this.os : (this.base != null ? this.base.os : null), this.property != null ? this.property : (this.base != null ? this.base.property : null), this.file != null ? this.file : (this.base != null ? this.base.file : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), activeByDefaultLocation != null ? activeByDefaultLocation : (this.base != null ? this.base.activeByDefaultLocation : null), jdkLocation != null ? jdkLocation : (this.base != null ? this.base.jdkLocation : null), osLocation != null ? osLocation : (this.base != null ? this.base.osLocation : null), propertyLocation != null ? propertyLocation : (this.base != null ? this.base.propertyLocation : null), fileLocation != null ? fileLocation : (this.base != null ? this.base.fileLocation : null));
        }
    }
}

