// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Base class for the {@code Model} and the {@code Profile} objects.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class ModelBase
    implements Serializable, InputLocationTracker
{
    /**
     * The modules (sometimes called subprojects) to build as a part of this
     * project. Each module listed is a relative path to the directory containing the module.
     * To be consistent with the way default urls are calculated from parent, it is recommended
     * to have module names match artifact ids.
     */
    final List<String> modules;
    /**
     * Distribution information for a project that enables deployment of the site
     * and artifacts to remote web servers and repositories respectively.
     */
    final DistributionManagement distributionManagement;
    /**
     * Properties that can be used throughout the POM as a substitution, and
     * are used as filters in resources if enabled.
     * The format is {@code <name>value</name>}.
     */
    final Map<String, String> properties;
    /**
     * Default dependency information for projects that inherit from this one. The
     * dependencies in this section are not immediately resolved. Instead, when a POM derived
     * from this one declares a dependency described by a matching groupId and artifactId, the
     * version and other values from this section are used for that dependency if they were not
     * already specified.
     */
    final DependencyManagement dependencyManagement;
    /**
     * This element describes all of the dependencies associated with a
     * project.
     * These dependencies are used to construct a classpath for your
     * project during the build process. They are automatically downloaded from the
     * repositories defined in this project.
     * See <a href="https://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">the
     * dependency mechanism</a> for more information.
     */
    final List<Dependency> dependencies;
    /**
     * The lists of the remote repositories for discovering dependencies and
     * extensions.
     */
    final List<Repository> repositories;
    /**
     * The lists of the remote repositories for discovering plugins for builds and
     * reports.
     */
    final List<Repository> pluginRepositories;
    /**
     * This element includes the specification of report plugins to use
     * to generate the reports on the Maven-generated site.
     * These reports will be run when a user executes {@code mvn site}.
     * All of the reports will be included in the navigation bar for browsing.
     */
    final Reporting reporting;
    /** Location of the xml element for this object. */
    final InputLocation location;
    /** Location of the xml element for the field modules. */
    final InputLocation modulesLocation;
    /** Location of the xml element for the field distributionManagement. */
    final InputLocation distributionManagementLocation;
    /** Location of the xml element for the field properties. */
    final InputLocation propertiesLocation;
    /** Location of the xml element for the field dependencyManagement. */
    final InputLocation dependencyManagementLocation;
    /** Location of the xml element for the field dependencies. */
    final InputLocation dependenciesLocation;
    /** Location of the xml element for the field repositories. */
    final InputLocation repositoriesLocation;
    /** Location of the xml element for the field pluginRepositories. */
    final InputLocation pluginRepositoriesLocation;
    /** Location of the xml element for the field reporting. */
    final InputLocation reportingLocation;
    /** Other locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    ModelBase(
        Collection<String> modules,
        DistributionManagement distributionManagement,
        Map<String, String> properties,
        DependencyManagement dependencyManagement,
        Collection<Dependency> dependencies,
        Collection<Repository> repositories,
        Collection<Repository> pluginRepositories,
        Reporting reporting,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation modulesLocation,
        InputLocation distributionManagementLocation,
        InputLocation propertiesLocation,
        InputLocation dependencyManagementLocation,
        InputLocation dependenciesLocation,
        InputLocation repositoriesLocation,
        InputLocation pluginRepositoriesLocation,
        InputLocation reportingLocation
    )
    {
        this.modules = ImmutableCollections.copy( modules );
        this.distributionManagement = distributionManagement;
        this.properties = ImmutableCollections.copy( properties );
        this.dependencyManagement = dependencyManagement;
        this.dependencies = ImmutableCollections.copy( dependencies );
        this.repositories = ImmutableCollections.copy( repositories );
        this.pluginRepositories = ImmutableCollections.copy( pluginRepositories );
        this.reporting = reporting;
        this.locations = ImmutableCollections.copy( locations );
        this.location = location;
        this.modulesLocation = modulesLocation;
        this.distributionManagementLocation = distributionManagementLocation;
        this.propertiesLocation = propertiesLocation;
        this.dependencyManagementLocation = dependencyManagementLocation;
        this.dependenciesLocation = dependenciesLocation;
        this.repositoriesLocation = repositoriesLocation;
        this.pluginRepositoriesLocation = pluginRepositoriesLocation;
        this.reportingLocation = reportingLocation;
    }

    /**
     * The modules (sometimes called subprojects) to build as a part of this
     * project. Each module listed is a relative path to the directory containing the module.
     * To be consistent with the way default urls are calculated from parent, it is recommended
     * to have module names match artifact ids.
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getModules()
    {
        return this.modules;
    }

    /**
     * Distribution information for a project that enables deployment of the site
     * and artifacts to remote web servers and repositories respectively.
     *
     * @return a {@code DistributionManagement}
     */
    public DistributionManagement getDistributionManagement()
    {
        return this.distributionManagement;
    }

    /**
     * Properties that can be used throughout the POM as a substitution, and
     * are used as filters in resources if enabled.
     * The format is {@code <name>value</name>}.
     *
     * @return a {@code Map<String, String>}
     */
    @Nonnull
    public Map<String, String> getProperties()
    {
        return this.properties;
    }

    /**
     * Default dependency information for projects that inherit from this one. The
     * dependencies in this section are not immediately resolved. Instead, when a POM derived
     * from this one declares a dependency described by a matching groupId and artifactId, the
     * version and other values from this section are used for that dependency if they were not
     * already specified.
     *
     * @return a {@code DependencyManagement}
     */
    public DependencyManagement getDependencyManagement()
    {
        return this.dependencyManagement;
    }

    /**
     * This element describes all of the dependencies associated with a
     * project.
     * These dependencies are used to construct a classpath for your
     * project during the build process. They are automatically downloaded from the
     * repositories defined in this project.
     * See <a href="https://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">the
     * dependency mechanism</a> for more information.
     *
     * @return a {@code List<Dependency>}
     */
    @Nonnull
    public List<Dependency> getDependencies()
    {
        return this.dependencies;
    }

    /**
     * The lists of the remote repositories for discovering dependencies and
     * extensions.
     *
     * @return a {@code List<Repository>}
     */
    @Nonnull
    public List<Repository> getRepositories()
    {
        return this.repositories;
    }

    /**
     * The lists of the remote repositories for discovering plugins for builds and
     * reports.
     *
     * @return a {@code List<Repository>}
     */
    @Nonnull
    public List<Repository> getPluginRepositories()
    {
        return this.pluginRepositories;
    }

    /**
     * This element includes the specification of report plugins to use
     * to generate the reports on the Maven-generated site.
     * These reports will be run when a user executes {@code mvn site}.
     * All of the reports will be included in the navigation bar for browsing.
     *
     * @return a {@code Reporting}
     */
    public Reporting getReporting()
    {
        return this.reporting;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "":
                    return location;
                case "modules":
                    return modulesLocation;
                case "distributionManagement":
                    return distributionManagementLocation;
                case "properties":
                    return propertiesLocation;
                case "dependencyManagement":
                    return dependencyManagementLocation;
                case "dependencies":
                    return dependenciesLocation;
                case "repositories":
                    return repositoriesLocation;
                case "pluginRepositories":
                    return pluginRepositoriesLocation;
                case "reporting":
                    return reportingLocation;
            }
        }
        return locations != null ? locations.get( key ) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified modules.
     *
     * @param modules the new {@code Collection<String>} to use
     * @return a {@code ModelBase} with the specified modules
     */
    @Nonnull
    public ModelBase withModules( Collection<String> modules )
    {
        return with().modules( modules ).build();
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified distributionManagement.
     *
     * @param distributionManagement the new {@code DistributionManagement} to use
     * @return a {@code ModelBase} with the specified distributionManagement
     */
    @Nonnull
    public ModelBase withDistributionManagement( DistributionManagement distributionManagement )
    {
        return with().distributionManagement( distributionManagement ).build();
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified properties.
     *
     * @param properties the new {@code Map<String, String>} to use
     * @return a {@code ModelBase} with the specified properties
     */
    @Nonnull
    public ModelBase withProperties( Map<String, String> properties )
    {
        return with().properties( properties ).build();
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified dependencyManagement.
     *
     * @param dependencyManagement the new {@code DependencyManagement} to use
     * @return a {@code ModelBase} with the specified dependencyManagement
     */
    @Nonnull
    public ModelBase withDependencyManagement( DependencyManagement dependencyManagement )
    {
        return with().dependencyManagement( dependencyManagement ).build();
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified dependencies.
     *
     * @param dependencies the new {@code Collection<Dependency>} to use
     * @return a {@code ModelBase} with the specified dependencies
     */
    @Nonnull
    public ModelBase withDependencies( Collection<Dependency> dependencies )
    {
        return with().dependencies( dependencies ).build();
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified repositories.
     *
     * @param repositories the new {@code Collection<Repository>} to use
     * @return a {@code ModelBase} with the specified repositories
     */
    @Nonnull
    public ModelBase withRepositories( Collection<Repository> repositories )
    {
        return with().repositories( repositories ).build();
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified pluginRepositories.
     *
     * @param pluginRepositories the new {@code Collection<Repository>} to use
     * @return a {@code ModelBase} with the specified pluginRepositories
     */
    @Nonnull
    public ModelBase withPluginRepositories( Collection<Repository> pluginRepositories )
    {
        return with().pluginRepositories( pluginRepositories ).build();
    }
    /**
     * Creates a new {@code ModelBase} instance using the specified reporting.
     *
     * @param reporting the new {@code Reporting} to use
     * @return a {@code ModelBase} with the specified reporting
     */
    @Nonnull
    public ModelBase withReporting( Reporting reporting )
    {
        return with().reporting( reporting ).build();
    }

    /**
     * Creates a new {@code ModelBase} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code ModelBase}
     */
    @Nonnull
    public static ModelBase newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code ModelBase} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code ModelBase}
     */
    @Nonnull
    public static ModelBase newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code ModelBase} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code ModelBase} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code ModelBase} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code ModelBase} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( ModelBase from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code ModelBase} builder instance using the specified object as a basis.
     *
     * @param from the {@code ModelBase} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( ModelBase from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create ModelBase instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        ModelBase base;
        Collection<String> modules;
        DistributionManagement distributionManagement;
        Map<String, String> properties;
        DependencyManagement dependencyManagement;
        Collection<Dependency> dependencies;
        Collection<Repository> repositories;
        Collection<Repository> pluginRepositories;
        Reporting reporting;
        Map<Object, InputLocation> locations;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( ModelBase base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.modules = base.modules;
                this.distributionManagement = base.distributionManagement;
                this.properties = base.properties;
                this.dependencyManagement = base.dependencyManagement;
                this.dependencies = base.dependencies;
                this.repositories = base.repositories;
                this.pluginRepositories = base.pluginRepositories;
                this.reporting = base.reporting;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder modules( Collection<String> modules )
        {
            this.modules = modules;
            return this;
        }

        @Nonnull
        public Builder distributionManagement( DistributionManagement distributionManagement )
        {
            this.distributionManagement = distributionManagement;
            return this;
        }

        @Nonnull
        public Builder properties( Map<String, String> properties )
        {
            this.properties = properties;
            return this;
        }

        @Nonnull
        public Builder dependencyManagement( DependencyManagement dependencyManagement )
        {
            this.dependencyManagement = dependencyManagement;
            return this;
        }

        @Nonnull
        public Builder dependencies( Collection<Dependency> dependencies )
        {
            this.dependencies = dependencies;
            return this;
        }

        @Nonnull
        public Builder repositories( Collection<Repository> repositories )
        {
            this.repositories = repositories;
            return this;
        }

        @Nonnull
        public Builder pluginRepositories( Collection<Repository> pluginRepositories )
        {
            this.pluginRepositories = pluginRepositories;
            return this;
        }

        @Nonnull
        public Builder reporting( Reporting reporting )
        {
            this.reporting = reporting;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public ModelBase build()
        {
            if ( base != null
                    && ( modules == null || modules == base.modules )
                    && ( distributionManagement == null || distributionManagement == base.distributionManagement )
                    && ( properties == null || properties == base.properties )
                    && ( dependencyManagement == null || dependencyManagement == base.dependencyManagement )
                    && ( dependencies == null || dependencies == base.dependencies )
                    && ( repositories == null || repositories == base.repositories )
                    && ( pluginRepositories == null || pluginRepositories == base.pluginRepositories )
                    && ( reporting == null || reporting == base.reporting )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation modulesLocation = null;
            InputLocation distributionManagementLocation = null;
            InputLocation propertiesLocation = null;
            InputLocation dependencyManagementLocation = null;
            InputLocation dependenciesLocation = null;
            InputLocation repositoriesLocation = null;
            InputLocation pluginRepositoriesLocation = null;
            InputLocation reportingLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                modulesLocation = locations.remove( "modules" );
                distributionManagementLocation = locations.remove( "distributionManagement" );
                propertiesLocation = locations.remove( "properties" );
                dependencyManagementLocation = locations.remove( "dependencyManagement" );
                dependenciesLocation = locations.remove( "dependencies" );
                repositoriesLocation = locations.remove( "repositories" );
                pluginRepositoriesLocation = locations.remove( "pluginRepositories" );
                reportingLocation = locations.remove( "reporting" );
            }
            return new ModelBase(
                modules != null ? modules : ( base != null ? base.modules : null ),
                distributionManagement != null ? distributionManagement : ( base != null ? base.distributionManagement : null ),
                properties != null ? properties : ( base != null ? base.properties : null ),
                dependencyManagement != null ? dependencyManagement : ( base != null ? base.dependencyManagement : null ),
                dependencies != null ? dependencies : ( base != null ? base.dependencies : null ),
                repositories != null ? repositories : ( base != null ? base.repositories : null ),
                pluginRepositories != null ? pluginRepositories : ( base != null ? base.pluginRepositories : null ),
                reporting != null ? reporting : ( base != null ? base.reporting : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                modulesLocation != null ? modulesLocation : ( base != null ? base.modulesLocation : null ),
                distributionManagementLocation != null ? distributionManagementLocation : ( base != null ? base.distributionManagementLocation : null ),
                propertiesLocation != null ? propertiesLocation : ( base != null ? base.propertiesLocation : null ),
                dependencyManagementLocation != null ? dependencyManagementLocation : ( base != null ? base.dependencyManagementLocation : null ),
                dependenciesLocation != null ? dependenciesLocation : ( base != null ? base.dependenciesLocation : null ),
                repositoriesLocation != null ? repositoriesLocation : ( base != null ? base.repositoriesLocation : null ),
                pluginRepositoriesLocation != null ? pluginRepositoriesLocation : ( base != null ? base.pluginRepositoriesLocation : null ),
                reportingLocation != null ? reportingLocation : ( base != null ? base.reportingLocation : null )
            );
        }
    }

}
