// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The {@code <project>} element is the root of the descriptor.
 * The following table lists all of the possible child elements.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Model
    extends ModelBase
    implements Serializable, InputLocationTracker
{
    final String modelEncoding;
    /**
     * Originating POM file
     */
    final Path pomFile;
    /**
     * Declares to which version of project descriptor this POM conforms.
     */
    final String modelVersion;
    /**
     * The location of the parent project, if one exists. Values from the parent
     * project will be the default for this project if they are left unspecified. The location
     * is given as a group ID, artifact ID and version.
     */
    final Parent parent;
    /**
     * A universally unique identifier for a project. It is normal to
     * use a fully-qualified package name to distinguish it from other
     * projects with a similar name (eg. {@code org.apache.maven}).
     */
    final String groupId;
    /**
     * The identifier for this artifact that is unique within the group given by the
     * group ID. An artifact is something that is either produced or used by a project.
     * Examples of artifacts produced by Maven for a project include: JARs, source and binary
     * distributions, and WARs.
     */
    final String artifactId;
    /**
     * The current version of the artifact produced by this project.
     */
    final String version;
    /**
     * The type of artifact this project produces, for example {@code jar}
     * {@code war}
     * {@code ear}
     * {@code pom}.
     * Plugins can create their own packaging, and
     * therefore their own packaging types,
     * so this list does not contain all possible types.
     */
    final String packaging;
    /**
     * The full name of the project.
     */
    final String name;
    /**
     * A detailed description of the project, used by Maven whenever it needs to
     * describe the project, such as on the web site. While this element can be specified as
     * CDATA to enable the use of HTML tags within the description, it is discouraged to allow
     * plain text representation. If you need to modify the index page of the generated web
     * site, you are able to specify your own instead of adjusting this text.
     */
    final String description;
    /**
     * The URL to the project's homepage.
     * <br><b>Default value is</b>: parent value [+ path adjustment] + (artifactId or project.directory property), or just parent value if
     * project's {@code child.project.url.inherit.append.path="false"}
     */
    final String url;
    /**
     * When children inherit from project's url, append path or not? Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}
     * <br><b>Default value is</b>: {@code true}
     * <br><b>Since</b>: Maven 3.6.1
     */
    final String childProjectUrlInheritAppendPath;
    /**
     * The year of the project's inception, specified with 4 digits. This value is
     * used when generating copyright notices as well as being informational.
     */
    final String inceptionYear;
    /**
     * This element describes various attributes of the organization to which the
     * project belongs. These attributes are utilized when documentation is created (for
     * copyright notices and links).
     */
    final Organization organization;
    /**
     * This element describes all of the licenses for this project.
     * Each license is described by a {@code license} element, which
     * is then described by additional elements.
     * Projects should only list the license(s) that applies to the project
     * and not the licenses that apply to dependencies.
     * If multiple licenses are listed, it is assumed that the user can select
     * any of them, not that they must accept all.
     */
    final List<License> licenses;
    /**
     * Describes the committers of a project.
     */
    final List<Developer> developers;
    /**
     * Describes the contributors to a project that are not yet committers.
     */
    final List<Contributor> contributors;
    /**
     * Contains information about a project's mailing lists.
     */
    final List<MailingList> mailingLists;
    /**
     * Describes the prerequisites in the build environment for this project.
     */
    final Prerequisites prerequisites;
    /**
     * Specification for the SCM used by the project, such as CVS, Subversion, etc.
     */
    final Scm scm;
    /**
     * The project's issue management system information.
     */
    final IssueManagement issueManagement;
    /**
     * The project's continuous integration information.
     */
    final CiManagement ciManagement;
    /**
     * Information required to build the project.
     */
    final Build build;
    /**
     * A listing of project-local build profiles which will modify the build process
     * when activated.
     */
    final List<Profile> profiles;
    /** Location of the xml element for the field pomFile. */
    final InputLocation pomFileLocation;
    /** Location of the xml element for the field modelVersion. */
    final InputLocation modelVersionLocation;
    /** Location of the xml element for the field parent. */
    final InputLocation parentLocation;
    /** Location of the xml element for the field groupId. */
    final InputLocation groupIdLocation;
    /** Location of the xml element for the field artifactId. */
    final InputLocation artifactIdLocation;
    /** Location of the xml element for the field version. */
    final InputLocation versionLocation;
    /** Location of the xml element for the field packaging. */
    final InputLocation packagingLocation;
    /** Location of the xml element for the field name. */
    final InputLocation nameLocation;
    /** Location of the xml element for the field description. */
    final InputLocation descriptionLocation;
    /** Location of the xml element for the field url. */
    final InputLocation urlLocation;
    /** Location of the xml element for the field childProjectUrlInheritAppendPath. */
    final InputLocation childProjectUrlInheritAppendPathLocation;
    /** Location of the xml element for the field inceptionYear. */
    final InputLocation inceptionYearLocation;
    /** Location of the xml element for the field organization. */
    final InputLocation organizationLocation;
    /** Location of the xml element for the field licenses. */
    final InputLocation licensesLocation;
    /** Location of the xml element for the field developers. */
    final InputLocation developersLocation;
    /** Location of the xml element for the field contributors. */
    final InputLocation contributorsLocation;
    /** Location of the xml element for the field mailingLists. */
    final InputLocation mailingListsLocation;
    /** Location of the xml element for the field prerequisites. */
    final InputLocation prerequisitesLocation;
    /** Location of the xml element for the field scm. */
    final InputLocation scmLocation;
    /** Location of the xml element for the field issueManagement. */
    final InputLocation issueManagementLocation;
    /** Location of the xml element for the field ciManagement. */
    final InputLocation ciManagementLocation;
    /** Location of the xml element for the field build. */
    final InputLocation buildLocation;
    /** Location of the xml element for the field profiles. */
    final InputLocation profilesLocation;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Model(
        String modelEncoding,
        Collection<String> modules,
        DistributionManagement distributionManagement,
        Map<String, String> properties,
        DependencyManagement dependencyManagement,
        Collection<Dependency> dependencies,
        Collection<Repository> repositories,
        Collection<Repository> pluginRepositories,
        Reporting reporting,
        Path pomFile,
        String modelVersion,
        Parent parent,
        String groupId,
        String artifactId,
        String version,
        String packaging,
        String name,
        String description,
        String url,
        String childProjectUrlInheritAppendPath,
        String inceptionYear,
        Organization organization,
        Collection<License> licenses,
        Collection<Developer> developers,
        Collection<Contributor> contributors,
        Collection<MailingList> mailingLists,
        Prerequisites prerequisites,
        Scm scm,
        IssueManagement issueManagement,
        CiManagement ciManagement,
        Build build,
        Collection<Profile> profiles,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation modulesLocation,
        InputLocation distributionManagementLocation,
        InputLocation propertiesLocation,
        InputLocation dependencyManagementLocation,
        InputLocation dependenciesLocation,
        InputLocation repositoriesLocation,
        InputLocation pluginRepositoriesLocation,
        InputLocation reportingLocation,
        InputLocation pomFileLocation,
        InputLocation modelVersionLocation,
        InputLocation parentLocation,
        InputLocation groupIdLocation,
        InputLocation artifactIdLocation,
        InputLocation versionLocation,
        InputLocation packagingLocation,
        InputLocation nameLocation,
        InputLocation descriptionLocation,
        InputLocation urlLocation,
        InputLocation childProjectUrlInheritAppendPathLocation,
        InputLocation inceptionYearLocation,
        InputLocation organizationLocation,
        InputLocation licensesLocation,
        InputLocation developersLocation,
        InputLocation contributorsLocation,
        InputLocation mailingListsLocation,
        InputLocation prerequisitesLocation,
        InputLocation scmLocation,
        InputLocation issueManagementLocation,
        InputLocation ciManagementLocation,
        InputLocation buildLocation,
        InputLocation profilesLocation
    )
    {
        super(
            modules,
            distributionManagement,
            properties,
            dependencyManagement,
            dependencies,
            repositories,
            pluginRepositories,
            reporting,
            locations,
            location,
            modulesLocation,
            distributionManagementLocation,
            propertiesLocation,
            dependencyManagementLocation,
            dependenciesLocation,
            repositoriesLocation,
            pluginRepositoriesLocation,
            reportingLocation
        );
        this.modelEncoding = modelEncoding;
        this.pomFile = pomFile;
        this.modelVersion = modelVersion;
        this.parent = parent;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.packaging = packaging;
        this.name = name;
        this.description = description;
        this.url = url;
        this.childProjectUrlInheritAppendPath = childProjectUrlInheritAppendPath;
        this.inceptionYear = inceptionYear;
        this.organization = organization;
        this.licenses = ImmutableCollections.copy( licenses );
        this.developers = ImmutableCollections.copy( developers );
        this.contributors = ImmutableCollections.copy( contributors );
        this.mailingLists = ImmutableCollections.copy( mailingLists );
        this.prerequisites = prerequisites;
        this.scm = scm;
        this.issueManagement = issueManagement;
        this.ciManagement = ciManagement;
        this.build = build;
        this.profiles = ImmutableCollections.copy( profiles );
        this.pomFileLocation = pomFileLocation;
        this.modelVersionLocation = modelVersionLocation;
        this.parentLocation = parentLocation;
        this.groupIdLocation = groupIdLocation;
        this.artifactIdLocation = artifactIdLocation;
        this.versionLocation = versionLocation;
        this.packagingLocation = packagingLocation;
        this.nameLocation = nameLocation;
        this.descriptionLocation = descriptionLocation;
        this.urlLocation = urlLocation;
        this.childProjectUrlInheritAppendPathLocation = childProjectUrlInheritAppendPathLocation;
        this.inceptionYearLocation = inceptionYearLocation;
        this.organizationLocation = organizationLocation;
        this.licensesLocation = licensesLocation;
        this.developersLocation = developersLocation;
        this.contributorsLocation = contributorsLocation;
        this.mailingListsLocation = mailingListsLocation;
        this.prerequisitesLocation = prerequisitesLocation;
        this.scmLocation = scmLocation;
        this.issueManagementLocation = issueManagementLocation;
        this.ciManagementLocation = ciManagementLocation;
        this.buildLocation = buildLocation;
        this.profilesLocation = profilesLocation;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }

    /**
     * Originating POM file
     *
     * @return a {@code Path}
     */
    public Path getPomFile()
    {
        return this.pomFile;
    }

    /**
     * Declares to which version of project descriptor this POM conforms.
     *
     * @return a {@code String}
     */
    public String getModelVersion()
    {
        return this.modelVersion;
    }

    /**
     * The location of the parent project, if one exists. Values from the parent
     * project will be the default for this project if they are left unspecified. The location
     * is given as a group ID, artifact ID and version.
     *
     * @return a {@code Parent}
     */
    public Parent getParent()
    {
        return this.parent;
    }

    /**
     * A universally unique identifier for a project. It is normal to
     * use a fully-qualified package name to distinguish it from other
     * projects with a similar name (eg. {@code org.apache.maven}).
     *
     * @return a {@code String}
     */
    public String getGroupId()
    {
        return this.groupId;
    }

    /**
     * The identifier for this artifact that is unique within the group given by the
     * group ID. An artifact is something that is either produced or used by a project.
     * Examples of artifacts produced by Maven for a project include: JARs, source and binary
     * distributions, and WARs.
     *
     * @return a {@code String}
     */
    public String getArtifactId()
    {
        return this.artifactId;
    }

    /**
     * The current version of the artifact produced by this project.
     *
     * @return a {@code String}
     */
    public String getVersion()
    {
        return this.version;
    }

    /**
     * The type of artifact this project produces, for example {@code jar}
     * {@code war}
     * {@code ear}
     * {@code pom}.
     * Plugins can create their own packaging, and
     * therefore their own packaging types,
     * so this list does not contain all possible types.
     *
     * @return a {@code String}
     */
    public String getPackaging()
    {
        return this.packaging;
    }

    /**
     * The full name of the project.
     *
     * @return a {@code String}
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * A detailed description of the project, used by Maven whenever it needs to
     * describe the project, such as on the web site. While this element can be specified as
     * CDATA to enable the use of HTML tags within the description, it is discouraged to allow
     * plain text representation. If you need to modify the index page of the generated web
     * site, you are able to specify your own instead of adjusting this text.
     *
     * @return a {@code String}
     */
    public String getDescription()
    {
        return this.description;
    }

    /**
     * The URL to the project's homepage.
     * <br><b>Default value is</b>: parent value [+ path adjustment] + (artifactId or project.directory property), or just parent value if
     * project's {@code child.project.url.inherit.append.path="false"}
     *
     * @return a {@code String}
     */
    public String getUrl()
    {
        return this.url;
    }

    /**
     * When children inherit from project's url, append path or not? Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}
     * <br><b>Default value is</b>: {@code true}
     * <br><b>Since</b>: Maven 3.6.1
     *
     * @return a {@code String}
     */
    public String getChildProjectUrlInheritAppendPath()
    {
        return this.childProjectUrlInheritAppendPath;
    }

    /**
     * The year of the project's inception, specified with 4 digits. This value is
     * used when generating copyright notices as well as being informational.
     *
     * @return a {@code String}
     */
    public String getInceptionYear()
    {
        return this.inceptionYear;
    }

    /**
     * This element describes various attributes of the organization to which the
     * project belongs. These attributes are utilized when documentation is created (for
     * copyright notices and links).
     *
     * @return a {@code Organization}
     */
    public Organization getOrganization()
    {
        return this.organization;
    }

    /**
     * This element describes all of the licenses for this project.
     * Each license is described by a {@code license} element, which
     * is then described by additional elements.
     * Projects should only list the license(s) that applies to the project
     * and not the licenses that apply to dependencies.
     * If multiple licenses are listed, it is assumed that the user can select
     * any of them, not that they must accept all.
     *
     * @return a {@code List<License>}
     */
    @Nonnull
    public List<License> getLicenses()
    {
        return this.licenses;
    }

    /**
     * Describes the committers of a project.
     *
     * @return a {@code List<Developer>}
     */
    @Nonnull
    public List<Developer> getDevelopers()
    {
        return this.developers;
    }

    /**
     * Describes the contributors to a project that are not yet committers.
     *
     * @return a {@code List<Contributor>}
     */
    @Nonnull
    public List<Contributor> getContributors()
    {
        return this.contributors;
    }

    /**
     * Contains information about a project's mailing lists.
     *
     * @return a {@code List<MailingList>}
     */
    @Nonnull
    public List<MailingList> getMailingLists()
    {
        return this.mailingLists;
    }

    /**
     * Describes the prerequisites in the build environment for this project.
     *
     * @return a {@code Prerequisites}
     */
    public Prerequisites getPrerequisites()
    {
        return this.prerequisites;
    }

    /**
     * Specification for the SCM used by the project, such as CVS, Subversion, etc.
     *
     * @return a {@code Scm}
     */
    public Scm getScm()
    {
        return this.scm;
    }

    /**
     * The project's issue management system information.
     *
     * @return a {@code IssueManagement}
     */
    public IssueManagement getIssueManagement()
    {
        return this.issueManagement;
    }

    /**
     * The project's continuous integration information.
     *
     * @return a {@code CiManagement}
     */
    public CiManagement getCiManagement()
    {
        return this.ciManagement;
    }

    /**
     * Information required to build the project.
     *
     * @return a {@code Build}
     */
    public Build getBuild()
    {
        return this.build;
    }

    /**
     * A listing of project-local build profiles which will modify the build process
     * when activated.
     *
     * @return a {@code List<Profile>}
     */
    @Nonnull
    public List<Profile> getProfiles()
    {
        return this.profiles;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "pomFile":
                    return pomFileLocation;
                case "modelVersion":
                    return modelVersionLocation;
                case "parent":
                    return parentLocation;
                case "groupId":
                    return groupIdLocation;
                case "artifactId":
                    return artifactIdLocation;
                case "version":
                    return versionLocation;
                case "packaging":
                    return packagingLocation;
                case "name":
                    return nameLocation;
                case "description":
                    return descriptionLocation;
                case "url":
                    return urlLocation;
                case "childProjectUrlInheritAppendPath":
                    return childProjectUrlInheritAppendPathLocation;
                case "inceptionYear":
                    return inceptionYearLocation;
                case "organization":
                    return organizationLocation;
                case "licenses":
                    return licensesLocation;
                case "developers":
                    return developersLocation;
                case "contributors":
                    return contributorsLocation;
                case "mailingLists":
                    return mailingListsLocation;
                case "prerequisites":
                    return prerequisitesLocation;
                case "scm":
                    return scmLocation;
                case "issueManagement":
                    return issueManagementLocation;
                case "ciManagement":
                    return ciManagementLocation;
                case "build":
                    return buildLocation;
                case "profiles":
                    return profilesLocation;
            }
        }
        return super.getLocation( key );
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code Model} instance using the specified modules.
     *
     * @param modules the new {@code Collection<String>} to use
     * @return a {@code Model} with the specified modules
     */
    @Nonnull
    public Model withModules( Collection<String> modules )
    {
        return with().modules( modules ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified distributionManagement.
     *
     * @param distributionManagement the new {@code DistributionManagement} to use
     * @return a {@code Model} with the specified distributionManagement
     */
    @Nonnull
    public Model withDistributionManagement( DistributionManagement distributionManagement )
    {
        return with().distributionManagement( distributionManagement ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified properties.
     *
     * @param properties the new {@code Map<String, String>} to use
     * @return a {@code Model} with the specified properties
     */
    @Nonnull
    public Model withProperties( Map<String, String> properties )
    {
        return with().properties( properties ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified dependencyManagement.
     *
     * @param dependencyManagement the new {@code DependencyManagement} to use
     * @return a {@code Model} with the specified dependencyManagement
     */
    @Nonnull
    public Model withDependencyManagement( DependencyManagement dependencyManagement )
    {
        return with().dependencyManagement( dependencyManagement ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified dependencies.
     *
     * @param dependencies the new {@code Collection<Dependency>} to use
     * @return a {@code Model} with the specified dependencies
     */
    @Nonnull
    public Model withDependencies( Collection<Dependency> dependencies )
    {
        return with().dependencies( dependencies ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified repositories.
     *
     * @param repositories the new {@code Collection<Repository>} to use
     * @return a {@code Model} with the specified repositories
     */
    @Nonnull
    public Model withRepositories( Collection<Repository> repositories )
    {
        return with().repositories( repositories ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified pluginRepositories.
     *
     * @param pluginRepositories the new {@code Collection<Repository>} to use
     * @return a {@code Model} with the specified pluginRepositories
     */
    @Nonnull
    public Model withPluginRepositories( Collection<Repository> pluginRepositories )
    {
        return with().pluginRepositories( pluginRepositories ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified reporting.
     *
     * @param reporting the new {@code Reporting} to use
     * @return a {@code Model} with the specified reporting
     */
    @Nonnull
    public Model withReporting( Reporting reporting )
    {
        return with().reporting( reporting ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified pomFile.
     *
     * @param pomFile the new {@code Path} to use
     * @return a {@code Model} with the specified pomFile
     */
    @Nonnull
    public Model withPomFile( Path pomFile )
    {
        return with().pomFile( pomFile ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified modelVersion.
     *
     * @param modelVersion the new {@code String} to use
     * @return a {@code Model} with the specified modelVersion
     */
    @Nonnull
    public Model withModelVersion( String modelVersion )
    {
        return with().modelVersion( modelVersion ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified parent.
     *
     * @param parent the new {@code Parent} to use
     * @return a {@code Model} with the specified parent
     */
    @Nonnull
    public Model withParent( Parent parent )
    {
        return with().parent( parent ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified groupId.
     *
     * @param groupId the new {@code String} to use
     * @return a {@code Model} with the specified groupId
     */
    @Nonnull
    public Model withGroupId( String groupId )
    {
        return with().groupId( groupId ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified artifactId.
     *
     * @param artifactId the new {@code String} to use
     * @return a {@code Model} with the specified artifactId
     */
    @Nonnull
    public Model withArtifactId( String artifactId )
    {
        return with().artifactId( artifactId ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified version.
     *
     * @param version the new {@code String} to use
     * @return a {@code Model} with the specified version
     */
    @Nonnull
    public Model withVersion( String version )
    {
        return with().version( version ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified packaging.
     *
     * @param packaging the new {@code String} to use
     * @return a {@code Model} with the specified packaging
     */
    @Nonnull
    public Model withPackaging( String packaging )
    {
        return with().packaging( packaging ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code Model} with the specified name
     */
    @Nonnull
    public Model withName( String name )
    {
        return with().name( name ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified description.
     *
     * @param description the new {@code String} to use
     * @return a {@code Model} with the specified description
     */
    @Nonnull
    public Model withDescription( String description )
    {
        return with().description( description ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code Model} with the specified url
     */
    @Nonnull
    public Model withUrl( String url )
    {
        return with().url( url ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified childProjectUrlInheritAppendPath.
     *
     * @param childProjectUrlInheritAppendPath the new {@code String} to use
     * @return a {@code Model} with the specified childProjectUrlInheritAppendPath
     */
    @Nonnull
    public Model withChildProjectUrlInheritAppendPath( String childProjectUrlInheritAppendPath )
    {
        return with().childProjectUrlInheritAppendPath( childProjectUrlInheritAppendPath ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified inceptionYear.
     *
     * @param inceptionYear the new {@code String} to use
     * @return a {@code Model} with the specified inceptionYear
     */
    @Nonnull
    public Model withInceptionYear( String inceptionYear )
    {
        return with().inceptionYear( inceptionYear ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified organization.
     *
     * @param organization the new {@code Organization} to use
     * @return a {@code Model} with the specified organization
     */
    @Nonnull
    public Model withOrganization( Organization organization )
    {
        return with().organization( organization ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified licenses.
     *
     * @param licenses the new {@code Collection<License>} to use
     * @return a {@code Model} with the specified licenses
     */
    @Nonnull
    public Model withLicenses( Collection<License> licenses )
    {
        return with().licenses( licenses ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified developers.
     *
     * @param developers the new {@code Collection<Developer>} to use
     * @return a {@code Model} with the specified developers
     */
    @Nonnull
    public Model withDevelopers( Collection<Developer> developers )
    {
        return with().developers( developers ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified contributors.
     *
     * @param contributors the new {@code Collection<Contributor>} to use
     * @return a {@code Model} with the specified contributors
     */
    @Nonnull
    public Model withContributors( Collection<Contributor> contributors )
    {
        return with().contributors( contributors ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified mailingLists.
     *
     * @param mailingLists the new {@code Collection<MailingList>} to use
     * @return a {@code Model} with the specified mailingLists
     */
    @Nonnull
    public Model withMailingLists( Collection<MailingList> mailingLists )
    {
        return with().mailingLists( mailingLists ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified prerequisites.
     *
     * @param prerequisites the new {@code Prerequisites} to use
     * @return a {@code Model} with the specified prerequisites
     */
    @Nonnull
    public Model withPrerequisites( Prerequisites prerequisites )
    {
        return with().prerequisites( prerequisites ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified scm.
     *
     * @param scm the new {@code Scm} to use
     * @return a {@code Model} with the specified scm
     */
    @Nonnull
    public Model withScm( Scm scm )
    {
        return with().scm( scm ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified issueManagement.
     *
     * @param issueManagement the new {@code IssueManagement} to use
     * @return a {@code Model} with the specified issueManagement
     */
    @Nonnull
    public Model withIssueManagement( IssueManagement issueManagement )
    {
        return with().issueManagement( issueManagement ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified ciManagement.
     *
     * @param ciManagement the new {@code CiManagement} to use
     * @return a {@code Model} with the specified ciManagement
     */
    @Nonnull
    public Model withCiManagement( CiManagement ciManagement )
    {
        return with().ciManagement( ciManagement ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified build.
     *
     * @param build the new {@code Build} to use
     * @return a {@code Model} with the specified build
     */
    @Nonnull
    public Model withBuild( Build build )
    {
        return with().build( build ).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified profiles.
     *
     * @param profiles the new {@code Collection<Profile>} to use
     * @return a {@code Model} with the specified profiles
     */
    @Nonnull
    public Model withProfiles( Collection<Profile> profiles )
    {
        return with().profiles( profiles ).build();
    }

    /**
     * Creates a new {@code Model} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Model}
     */
    @Nonnull
    public static Model newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code Model} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Model}
     */
    @Nonnull
    public static Model newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code Model} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code Model} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code Model} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code Model} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Model from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code Model} builder instance using the specified object as a basis.
     *
     * @param from the {@code Model} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Model from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create Model instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends ModelBase.Builder
    {
        Model base;
        String modelEncoding;
        Path pomFile;
        String modelVersion;
        Parent parent;
        String groupId;
        String artifactId;
        String version;
        String packaging;
        String name;
        String description;
        String url;
        String childProjectUrlInheritAppendPath;
        String inceptionYear;
        Organization organization;
        Collection<License> licenses;
        Collection<Developer> developers;
        Collection<Contributor> contributors;
        Collection<MailingList> mailingLists;
        Prerequisites prerequisites;
        Scm scm;
        IssueManagement issueManagement;
        CiManagement ciManagement;
        Build build;
        Collection<Profile> profiles;

        Builder( boolean withDefaults )
        {
            super( withDefaults );
            if ( withDefaults )
            {
                this.packaging = "jar";
            }
        }

        Builder( Model base, boolean forceCopy )
        {
            super( base, forceCopy );
            if ( forceCopy )
            {
                this.pomFile = base.pomFile;
                this.modelVersion = base.modelVersion;
                this.parent = base.parent;
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.packaging = base.packaging;
                this.name = base.name;
                this.description = base.description;
                this.url = base.url;
                this.childProjectUrlInheritAppendPath = base.childProjectUrlInheritAppendPath;
                this.inceptionYear = base.inceptionYear;
                this.organization = base.organization;
                this.licenses = base.licenses;
                this.developers = base.developers;
                this.contributors = base.contributors;
                this.mailingLists = base.mailingLists;
                this.prerequisites = base.prerequisites;
                this.scm = base.scm;
                this.issueManagement = base.issueManagement;
                this.ciManagement = base.ciManagement;
                this.build = base.build;
                this.profiles = base.profiles;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder modelEncoding( String modelEncoding )
        {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder modules( Collection<String> modules )
        {
            this.modules = modules;
            return this;
        }

        @Nonnull
        public Builder distributionManagement( DistributionManagement distributionManagement )
        {
            this.distributionManagement = distributionManagement;
            return this;
        }

        @Nonnull
        public Builder properties( Map<String, String> properties )
        {
            this.properties = properties;
            return this;
        }

        @Nonnull
        public Builder dependencyManagement( DependencyManagement dependencyManagement )
        {
            this.dependencyManagement = dependencyManagement;
            return this;
        }

        @Nonnull
        public Builder dependencies( Collection<Dependency> dependencies )
        {
            this.dependencies = dependencies;
            return this;
        }

        @Nonnull
        public Builder repositories( Collection<Repository> repositories )
        {
            this.repositories = repositories;
            return this;
        }

        @Nonnull
        public Builder pluginRepositories( Collection<Repository> pluginRepositories )
        {
            this.pluginRepositories = pluginRepositories;
            return this;
        }

        @Nonnull
        public Builder reporting( Reporting reporting )
        {
            this.reporting = reporting;
            return this;
        }

        @Nonnull
        public Builder pomFile( Path pomFile )
        {
            this.pomFile = pomFile;
            return this;
        }

        @Nonnull
        public Builder modelVersion( String modelVersion )
        {
            this.modelVersion = modelVersion;
            return this;
        }

        @Nonnull
        public Builder parent( Parent parent )
        {
            this.parent = parent;
            return this;
        }

        @Nonnull
        public Builder groupId( String groupId )
        {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId( String artifactId )
        {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version( String version )
        {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder packaging( String packaging )
        {
            this.packaging = packaging;
            return this;
        }

        @Nonnull
        public Builder name( String name )
        {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder description( String description )
        {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder url( String url )
        {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder childProjectUrlInheritAppendPath( String childProjectUrlInheritAppendPath )
        {
            this.childProjectUrlInheritAppendPath = childProjectUrlInheritAppendPath;
            return this;
        }

        @Nonnull
        public Builder inceptionYear( String inceptionYear )
        {
            this.inceptionYear = inceptionYear;
            return this;
        }

        @Nonnull
        public Builder organization( Organization organization )
        {
            this.organization = organization;
            return this;
        }

        @Nonnull
        public Builder licenses( Collection<License> licenses )
        {
            this.licenses = licenses;
            return this;
        }

        @Nonnull
        public Builder developers( Collection<Developer> developers )
        {
            this.developers = developers;
            return this;
        }

        @Nonnull
        public Builder contributors( Collection<Contributor> contributors )
        {
            this.contributors = contributors;
            return this;
        }

        @Nonnull
        public Builder mailingLists( Collection<MailingList> mailingLists )
        {
            this.mailingLists = mailingLists;
            return this;
        }

        @Nonnull
        public Builder prerequisites( Prerequisites prerequisites )
        {
            this.prerequisites = prerequisites;
            return this;
        }

        @Nonnull
        public Builder scm( Scm scm )
        {
            this.scm = scm;
            return this;
        }

        @Nonnull
        public Builder issueManagement( IssueManagement issueManagement )
        {
            this.issueManagement = issueManagement;
            return this;
        }

        @Nonnull
        public Builder ciManagement( CiManagement ciManagement )
        {
            this.ciManagement = ciManagement;
            return this;
        }

        @Nonnull
        public Builder build( Build build )
        {
            this.build = build;
            return this;
        }

        @Nonnull
        public Builder profiles( Collection<Profile> profiles )
        {
            this.profiles = profiles;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public Model build()
        {
            if ( base != null
                    && ( modules == null || modules == base.modules )
                    && ( distributionManagement == null || distributionManagement == base.distributionManagement )
                    && ( properties == null || properties == base.properties )
                    && ( dependencyManagement == null || dependencyManagement == base.dependencyManagement )
                    && ( dependencies == null || dependencies == base.dependencies )
                    && ( repositories == null || repositories == base.repositories )
                    && ( pluginRepositories == null || pluginRepositories == base.pluginRepositories )
                    && ( reporting == null || reporting == base.reporting )
                    && ( pomFile == null || pomFile == base.pomFile )
                    && ( modelVersion == null || modelVersion == base.modelVersion )
                    && ( parent == null || parent == base.parent )
                    && ( groupId == null || groupId == base.groupId )
                    && ( artifactId == null || artifactId == base.artifactId )
                    && ( version == null || version == base.version )
                    && ( packaging == null || packaging == base.packaging )
                    && ( name == null || name == base.name )
                    && ( description == null || description == base.description )
                    && ( url == null || url == base.url )
                    && ( childProjectUrlInheritAppendPath == null || childProjectUrlInheritAppendPath == base.childProjectUrlInheritAppendPath )
                    && ( inceptionYear == null || inceptionYear == base.inceptionYear )
                    && ( organization == null || organization == base.organization )
                    && ( licenses == null || licenses == base.licenses )
                    && ( developers == null || developers == base.developers )
                    && ( contributors == null || contributors == base.contributors )
                    && ( mailingLists == null || mailingLists == base.mailingLists )
                    && ( prerequisites == null || prerequisites == base.prerequisites )
                    && ( scm == null || scm == base.scm )
                    && ( issueManagement == null || issueManagement == base.issueManagement )
                    && ( ciManagement == null || ciManagement == base.ciManagement )
                    && ( build == null || build == base.build )
                    && ( profiles == null || profiles == base.profiles )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation modulesLocation = null;
            InputLocation distributionManagementLocation = null;
            InputLocation propertiesLocation = null;
            InputLocation dependencyManagementLocation = null;
            InputLocation dependenciesLocation = null;
            InputLocation repositoriesLocation = null;
            InputLocation pluginRepositoriesLocation = null;
            InputLocation reportingLocation = null;
            InputLocation pomFileLocation = null;
            InputLocation modelVersionLocation = null;
            InputLocation parentLocation = null;
            InputLocation groupIdLocation = null;
            InputLocation artifactIdLocation = null;
            InputLocation versionLocation = null;
            InputLocation packagingLocation = null;
            InputLocation nameLocation = null;
            InputLocation descriptionLocation = null;
            InputLocation urlLocation = null;
            InputLocation childProjectUrlInheritAppendPathLocation = null;
            InputLocation inceptionYearLocation = null;
            InputLocation organizationLocation = null;
            InputLocation licensesLocation = null;
            InputLocation developersLocation = null;
            InputLocation contributorsLocation = null;
            InputLocation mailingListsLocation = null;
            InputLocation prerequisitesLocation = null;
            InputLocation scmLocation = null;
            InputLocation issueManagementLocation = null;
            InputLocation ciManagementLocation = null;
            InputLocation buildLocation = null;
            InputLocation profilesLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                modulesLocation = locations.remove( "modules" );
                distributionManagementLocation = locations.remove( "distributionManagement" );
                propertiesLocation = locations.remove( "properties" );
                dependencyManagementLocation = locations.remove( "dependencyManagement" );
                dependenciesLocation = locations.remove( "dependencies" );
                repositoriesLocation = locations.remove( "repositories" );
                pluginRepositoriesLocation = locations.remove( "pluginRepositories" );
                reportingLocation = locations.remove( "reporting" );
                pomFileLocation = locations.remove( "pomFile" );
                modelVersionLocation = locations.remove( "modelVersion" );
                parentLocation = locations.remove( "parent" );
                groupIdLocation = locations.remove( "groupId" );
                artifactIdLocation = locations.remove( "artifactId" );
                versionLocation = locations.remove( "version" );
                packagingLocation = locations.remove( "packaging" );
                nameLocation = locations.remove( "name" );
                descriptionLocation = locations.remove( "description" );
                urlLocation = locations.remove( "url" );
                childProjectUrlInheritAppendPathLocation = locations.remove( "childProjectUrlInheritAppendPath" );
                inceptionYearLocation = locations.remove( "inceptionYear" );
                organizationLocation = locations.remove( "organization" );
                licensesLocation = locations.remove( "licenses" );
                developersLocation = locations.remove( "developers" );
                contributorsLocation = locations.remove( "contributors" );
                mailingListsLocation = locations.remove( "mailingLists" );
                prerequisitesLocation = locations.remove( "prerequisites" );
                scmLocation = locations.remove( "scm" );
                issueManagementLocation = locations.remove( "issueManagement" );
                ciManagementLocation = locations.remove( "ciManagement" );
                buildLocation = locations.remove( "build" );
                profilesLocation = locations.remove( "profiles" );
            }
            return new Model(
                modelEncoding != null ? modelEncoding : ( base != null ? base.modelEncoding : "UTF-8" ),
                modules != null ? modules : ( base != null ? base.modules : null ),
                distributionManagement != null ? distributionManagement : ( base != null ? base.distributionManagement : null ),
                properties != null ? properties : ( base != null ? base.properties : null ),
                dependencyManagement != null ? dependencyManagement : ( base != null ? base.dependencyManagement : null ),
                dependencies != null ? dependencies : ( base != null ? base.dependencies : null ),
                repositories != null ? repositories : ( base != null ? base.repositories : null ),
                pluginRepositories != null ? pluginRepositories : ( base != null ? base.pluginRepositories : null ),
                reporting != null ? reporting : ( base != null ? base.reporting : null ),
                pomFile != null ? pomFile : ( base != null ? base.pomFile : null ),
                modelVersion != null ? modelVersion : ( base != null ? base.modelVersion : null ),
                parent != null ? parent : ( base != null ? base.parent : null ),
                groupId != null ? groupId : ( base != null ? base.groupId : null ),
                artifactId != null ? artifactId : ( base != null ? base.artifactId : null ),
                version != null ? version : ( base != null ? base.version : null ),
                packaging != null ? packaging : ( base != null ? base.packaging : null ),
                name != null ? name : ( base != null ? base.name : null ),
                description != null ? description : ( base != null ? base.description : null ),
                url != null ? url : ( base != null ? base.url : null ),
                childProjectUrlInheritAppendPath != null ? childProjectUrlInheritAppendPath : ( base != null ? base.childProjectUrlInheritAppendPath : null ),
                inceptionYear != null ? inceptionYear : ( base != null ? base.inceptionYear : null ),
                organization != null ? organization : ( base != null ? base.organization : null ),
                licenses != null ? licenses : ( base != null ? base.licenses : null ),
                developers != null ? developers : ( base != null ? base.developers : null ),
                contributors != null ? contributors : ( base != null ? base.contributors : null ),
                mailingLists != null ? mailingLists : ( base != null ? base.mailingLists : null ),
                prerequisites != null ? prerequisites : ( base != null ? base.prerequisites : null ),
                scm != null ? scm : ( base != null ? base.scm : null ),
                issueManagement != null ? issueManagement : ( base != null ? base.issueManagement : null ),
                ciManagement != null ? ciManagement : ( base != null ? base.ciManagement : null ),
                build != null ? build : ( base != null ? base.build : null ),
                profiles != null ? profiles : ( base != null ? base.profiles : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                modulesLocation != null ? modulesLocation : ( base != null ? base.modulesLocation : null ),
                distributionManagementLocation != null ? distributionManagementLocation : ( base != null ? base.distributionManagementLocation : null ),
                propertiesLocation != null ? propertiesLocation : ( base != null ? base.propertiesLocation : null ),
                dependencyManagementLocation != null ? dependencyManagementLocation : ( base != null ? base.dependencyManagementLocation : null ),
                dependenciesLocation != null ? dependenciesLocation : ( base != null ? base.dependenciesLocation : null ),
                repositoriesLocation != null ? repositoriesLocation : ( base != null ? base.repositoriesLocation : null ),
                pluginRepositoriesLocation != null ? pluginRepositoriesLocation : ( base != null ? base.pluginRepositoriesLocation : null ),
                reportingLocation != null ? reportingLocation : ( base != null ? base.reportingLocation : null ),
                pomFileLocation != null ? pomFileLocation : ( base != null ? base.pomFileLocation : null ),
                modelVersionLocation != null ? modelVersionLocation : ( base != null ? base.modelVersionLocation : null ),
                parentLocation != null ? parentLocation : ( base != null ? base.parentLocation : null ),
                groupIdLocation != null ? groupIdLocation : ( base != null ? base.groupIdLocation : null ),
                artifactIdLocation != null ? artifactIdLocation : ( base != null ? base.artifactIdLocation : null ),
                versionLocation != null ? versionLocation : ( base != null ? base.versionLocation : null ),
                packagingLocation != null ? packagingLocation : ( base != null ? base.packagingLocation : null ),
                nameLocation != null ? nameLocation : ( base != null ? base.nameLocation : null ),
                descriptionLocation != null ? descriptionLocation : ( base != null ? base.descriptionLocation : null ),
                urlLocation != null ? urlLocation : ( base != null ? base.urlLocation : null ),
                childProjectUrlInheritAppendPathLocation != null ? childProjectUrlInheritAppendPathLocation : ( base != null ? base.childProjectUrlInheritAppendPathLocation : null ),
                inceptionYearLocation != null ? inceptionYearLocation : ( base != null ? base.inceptionYearLocation : null ),
                organizationLocation != null ? organizationLocation : ( base != null ? base.organizationLocation : null ),
                licensesLocation != null ? licensesLocation : ( base != null ? base.licensesLocation : null ),
                developersLocation != null ? developersLocation : ( base != null ? base.developersLocation : null ),
                contributorsLocation != null ? contributorsLocation : ( base != null ? base.contributorsLocation : null ),
                mailingListsLocation != null ? mailingListsLocation : ( base != null ? base.mailingListsLocation : null ),
                prerequisitesLocation != null ? prerequisitesLocation : ( base != null ? base.prerequisitesLocation : null ),
                scmLocation != null ? scmLocation : ( base != null ? base.scmLocation : null ),
                issueManagementLocation != null ? issueManagementLocation : ( base != null ? base.issueManagementLocation : null ),
                ciManagementLocation != null ? ciManagementLocation : ( base != null ? base.ciManagementLocation : null ),
                buildLocation != null ? buildLocation : ( base != null ? base.buildLocation : null ),
                profilesLocation != null ? profilesLocation : ( base != null ? base.profilesLocation : null )
            );
        }
    }


            
    /**
     * Gets the base directory for the corresponding project (if any).
     *
     * @return The base directory for the corresponding project or {@code null} if this model does not belong to a local
     *         project (e.g. describes the metadata of some artifact from the repository).
     */
    public Path getProjectDirectory()
    {
        return ( pomFile != null ) ? pomFile.getParent() : null;
    }

    /**
     * @return the model id as {@code groupId:artifactId:packaging:version}
     */
    public String getId()
    {
        StringBuilder id = new StringBuilder( 64 );

        id.append( ( getGroupId() == null ) ? "[inherited]" : getGroupId() );
        id.append( ":" );
        id.append( getArtifactId() );
        id.append( ":" );
        id.append( getPackaging() );
        id.append( ":" );
        id.append( ( getVersion() == null ) ? "[inherited]" : getVersion() );

        return id.toString();
    }

    @Override
    public String toString()
    {
        return getId();
    }

    public boolean isChildProjectUrlInheritAppendPath()
    {
        return ( getChildProjectUrlInheritAppendPath() != null ) ? Boolean.parseBoolean( getChildProjectUrlInheritAppendPath() ) : true;
    }

            
          
}
