// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The {@code <build>} element contains informations required to build the project.
 * Default values are defined in Super POM.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Build
    extends BuildBase
    implements Serializable, InputLocationTracker
{
    /**
     * This element specifies a directory containing the source of the project. The
     * generated build system will compile the sources from this directory when the project is
     * built. The path given is relative to the project descriptor.
     * The default value is {@code src/main/java}.
     */
    final String sourceDirectory;
    /**
     * This element specifies a directory containing the script sources of the
     * project. This directory is meant to be different from the sourceDirectory, in that its
     * contents will be copied to the output directory in most cases (since scripts are
     * interpreted rather than compiled).
     * The default value is {@code src/main/scripts}.
     */
    final String scriptSourceDirectory;
    /**
     * This element specifies a directory containing the unit test source of the
     * project. The generated build system will compile these directories when the project is
     * being tested. The path given is relative to the project descriptor.
     * The default value is {@code src/test/java}.
     */
    final String testSourceDirectory;
    /**
     * The directory where compiled application classes are placed.
     * The default value is {@code target/classes}.
     */
    final String outputDirectory;
    /**
     * The directory where compiled test classes are placed.
     * The default value is {@code target/test-classes}.
     */
    final String testOutputDirectory;
    /**
     * A set of build extensions to use from this project.
     */
    final List<Extension> extensions;
    /** Location of the xml element for the field sourceDirectory. */
    final InputLocation sourceDirectoryLocation;
    /** Location of the xml element for the field scriptSourceDirectory. */
    final InputLocation scriptSourceDirectoryLocation;
    /** Location of the xml element for the field testSourceDirectory. */
    final InputLocation testSourceDirectoryLocation;
    /** Location of the xml element for the field outputDirectory. */
    final InputLocation outputDirectoryLocation;
    /** Location of the xml element for the field testOutputDirectory. */
    final InputLocation testOutputDirectoryLocation;
    /** Location of the xml element for the field extensions. */
    final InputLocation extensionsLocation;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Build(
        Collection<Plugin> plugins,
        PluginManagement pluginManagement,
        String defaultGoal,
        Collection<Resource> resources,
        Collection<Resource> testResources,
        String directory,
        String finalName,
        Collection<String> filters,
        String sourceDirectory,
        String scriptSourceDirectory,
        String testSourceDirectory,
        String outputDirectory,
        String testOutputDirectory,
        Collection<Extension> extensions,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation pluginsLocation,
        InputLocation pluginManagementLocation,
        InputLocation defaultGoalLocation,
        InputLocation resourcesLocation,
        InputLocation testResourcesLocation,
        InputLocation directoryLocation,
        InputLocation finalNameLocation,
        InputLocation filtersLocation,
        InputLocation sourceDirectoryLocation,
        InputLocation scriptSourceDirectoryLocation,
        InputLocation testSourceDirectoryLocation,
        InputLocation outputDirectoryLocation,
        InputLocation testOutputDirectoryLocation,
        InputLocation extensionsLocation
    )
    {
        super(
            plugins,
            pluginManagement,
            defaultGoal,
            resources,
            testResources,
            directory,
            finalName,
            filters,
            locations,
            location,
            pluginsLocation,
            pluginManagementLocation,
            defaultGoalLocation,
            resourcesLocation,
            testResourcesLocation,
            directoryLocation,
            finalNameLocation,
            filtersLocation
        );
        this.sourceDirectory = sourceDirectory;
        this.scriptSourceDirectory = scriptSourceDirectory;
        this.testSourceDirectory = testSourceDirectory;
        this.outputDirectory = outputDirectory;
        this.testOutputDirectory = testOutputDirectory;
        this.extensions = ImmutableCollections.copy( extensions );
        this.sourceDirectoryLocation = sourceDirectoryLocation;
        this.scriptSourceDirectoryLocation = scriptSourceDirectoryLocation;
        this.testSourceDirectoryLocation = testSourceDirectoryLocation;
        this.outputDirectoryLocation = outputDirectoryLocation;
        this.testOutputDirectoryLocation = testOutputDirectoryLocation;
        this.extensionsLocation = extensionsLocation;
    }

    /**
     * This element specifies a directory containing the source of the project. The
     * generated build system will compile the sources from this directory when the project is
     * built. The path given is relative to the project descriptor.
     * The default value is {@code src/main/java}.
     *
     * @return a {@code String}
     */
    public String getSourceDirectory()
    {
        return this.sourceDirectory;
    }

    /**
     * This element specifies a directory containing the script sources of the
     * project. This directory is meant to be different from the sourceDirectory, in that its
     * contents will be copied to the output directory in most cases (since scripts are
     * interpreted rather than compiled).
     * The default value is {@code src/main/scripts}.
     *
     * @return a {@code String}
     */
    public String getScriptSourceDirectory()
    {
        return this.scriptSourceDirectory;
    }

    /**
     * This element specifies a directory containing the unit test source of the
     * project. The generated build system will compile these directories when the project is
     * being tested. The path given is relative to the project descriptor.
     * The default value is {@code src/test/java}.
     *
     * @return a {@code String}
     */
    public String getTestSourceDirectory()
    {
        return this.testSourceDirectory;
    }

    /**
     * The directory where compiled application classes are placed.
     * The default value is {@code target/classes}.
     *
     * @return a {@code String}
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    }

    /**
     * The directory where compiled test classes are placed.
     * The default value is {@code target/test-classes}.
     *
     * @return a {@code String}
     */
    public String getTestOutputDirectory()
    {
        return this.testOutputDirectory;
    }

    /**
     * A set of build extensions to use from this project.
     *
     * @return a {@code List<Extension>}
     */
    @Nonnull
    public List<Extension> getExtensions()
    {
        return this.extensions;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "sourceDirectory":
                    return sourceDirectoryLocation;
                case "scriptSourceDirectory":
                    return scriptSourceDirectoryLocation;
                case "testSourceDirectory":
                    return testSourceDirectoryLocation;
                case "outputDirectory":
                    return outputDirectoryLocation;
                case "testOutputDirectory":
                    return testOutputDirectoryLocation;
                case "extensions":
                    return extensionsLocation;
            }
        }
        return super.getLocation( key );
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code Build} instance using the specified plugins.
     *
     * @param plugins the new {@code Collection<Plugin>} to use
     * @return a {@code Build} with the specified plugins
     */
    @Nonnull
    public Build withPlugins( Collection<Plugin> plugins )
    {
        return with().plugins( plugins ).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified pluginManagement.
     *
     * @param pluginManagement the new {@code PluginManagement} to use
     * @return a {@code Build} with the specified pluginManagement
     */
    @Nonnull
    public Build withPluginManagement( PluginManagement pluginManagement )
    {
        return with().pluginManagement( pluginManagement ).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified defaultGoal.
     *
     * @param defaultGoal the new {@code String} to use
     * @return a {@code Build} with the specified defaultGoal
     */
    @Nonnull
    public Build withDefaultGoal( String defaultGoal )
    {
        return with().defaultGoal( defaultGoal ).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified resources.
     *
     * @param resources the new {@code Collection<Resource>} to use
     * @return a {@code Build} with the specified resources
     */
    @Nonnull
    public Build withResources( Collection<Resource> resources )
    {
        return with().resources( resources ).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified testResources.
     *
     * @param testResources the new {@code Collection<Resource>} to use
     * @return a {@code Build} with the specified testResources
     */
    @Nonnull
    public Build withTestResources( Collection<Resource> testResources )
    {
        return with().testResources( testResources ).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified directory.
     *
     * @param directory the new {@code String} to use
     * @return a {@code Build} with the specified directory
     */
    @Nonnull
    public Build withDirectory( String directory )
    {
        return with().directory( directory ).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified finalName.
     *
     * @param finalName the new {@code String} to use
     * @return a {@code Build} with the specified finalName
     */
    @Nonnull
    public Build withFinalName( String finalName )
    {
        return with().finalName( finalName ).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified filters.
     *
     * @param filters the new {@code Collection<String>} to use
     * @return a {@code Build} with the specified filters
     */
    @Nonnull
    public Build withFilters( Collection<String> filters )
    {
        return with().filters( filters ).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified sourceDirectory.
     *
     * @param sourceDirectory the new {@code String} to use
     * @return a {@code Build} with the specified sourceDirectory
     */
    @Nonnull
    public Build withSourceDirectory( String sourceDirectory )
    {
        return with().sourceDirectory( sourceDirectory ).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified scriptSourceDirectory.
     *
     * @param scriptSourceDirectory the new {@code String} to use
     * @return a {@code Build} with the specified scriptSourceDirectory
     */
    @Nonnull
    public Build withScriptSourceDirectory( String scriptSourceDirectory )
    {
        return with().scriptSourceDirectory( scriptSourceDirectory ).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified testSourceDirectory.
     *
     * @param testSourceDirectory the new {@code String} to use
     * @return a {@code Build} with the specified testSourceDirectory
     */
    @Nonnull
    public Build withTestSourceDirectory( String testSourceDirectory )
    {
        return with().testSourceDirectory( testSourceDirectory ).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified outputDirectory.
     *
     * @param outputDirectory the new {@code String} to use
     * @return a {@code Build} with the specified outputDirectory
     */
    @Nonnull
    public Build withOutputDirectory( String outputDirectory )
    {
        return with().outputDirectory( outputDirectory ).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified testOutputDirectory.
     *
     * @param testOutputDirectory the new {@code String} to use
     * @return a {@code Build} with the specified testOutputDirectory
     */
    @Nonnull
    public Build withTestOutputDirectory( String testOutputDirectory )
    {
        return with().testOutputDirectory( testOutputDirectory ).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified extensions.
     *
     * @param extensions the new {@code Collection<Extension>} to use
     * @return a {@code Build} with the specified extensions
     */
    @Nonnull
    public Build withExtensions( Collection<Extension> extensions )
    {
        return with().extensions( extensions ).build();
    }

    /**
     * Creates a new {@code Build} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Build}
     */
    @Nonnull
    public static Build newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code Build} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Build}
     */
    @Nonnull
    public static Build newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code Build} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code Build} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code Build} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code Build} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Build from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code Build} builder instance using the specified object as a basis.
     *
     * @param from the {@code Build} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Build from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create Build instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends BuildBase.Builder
    {
        Build base;
        String sourceDirectory;
        String scriptSourceDirectory;
        String testSourceDirectory;
        String outputDirectory;
        String testOutputDirectory;
        Collection<Extension> extensions;

        Builder( boolean withDefaults )
        {
            super( withDefaults );
            if ( withDefaults )
            {
            }
        }

        Builder( Build base, boolean forceCopy )
        {
            super( base, forceCopy );
            if ( forceCopy )
            {
                this.sourceDirectory = base.sourceDirectory;
                this.scriptSourceDirectory = base.scriptSourceDirectory;
                this.testSourceDirectory = base.testSourceDirectory;
                this.outputDirectory = base.outputDirectory;
                this.testOutputDirectory = base.testOutputDirectory;
                this.extensions = base.extensions;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder plugins( Collection<Plugin> plugins )
        {
            this.plugins = plugins;
            return this;
        }

        @Nonnull
        public Builder pluginManagement( PluginManagement pluginManagement )
        {
            this.pluginManagement = pluginManagement;
            return this;
        }

        @Nonnull
        public Builder defaultGoal( String defaultGoal )
        {
            this.defaultGoal = defaultGoal;
            return this;
        }

        @Nonnull
        public Builder resources( Collection<Resource> resources )
        {
            this.resources = resources;
            return this;
        }

        @Nonnull
        public Builder testResources( Collection<Resource> testResources )
        {
            this.testResources = testResources;
            return this;
        }

        @Nonnull
        public Builder directory( String directory )
        {
            this.directory = directory;
            return this;
        }

        @Nonnull
        public Builder finalName( String finalName )
        {
            this.finalName = finalName;
            return this;
        }

        @Nonnull
        public Builder filters( Collection<String> filters )
        {
            this.filters = filters;
            return this;
        }

        @Nonnull
        public Builder sourceDirectory( String sourceDirectory )
        {
            this.sourceDirectory = sourceDirectory;
            return this;
        }

        @Nonnull
        public Builder scriptSourceDirectory( String scriptSourceDirectory )
        {
            this.scriptSourceDirectory = scriptSourceDirectory;
            return this;
        }

        @Nonnull
        public Builder testSourceDirectory( String testSourceDirectory )
        {
            this.testSourceDirectory = testSourceDirectory;
            return this;
        }

        @Nonnull
        public Builder outputDirectory( String outputDirectory )
        {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Nonnull
        public Builder testOutputDirectory( String testOutputDirectory )
        {
            this.testOutputDirectory = testOutputDirectory;
            return this;
        }

        @Nonnull
        public Builder extensions( Collection<Extension> extensions )
        {
            this.extensions = extensions;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public Build build()
        {
            if ( base != null
                    && ( plugins == null || plugins == base.plugins )
                    && ( pluginManagement == null || pluginManagement == base.pluginManagement )
                    && ( defaultGoal == null || defaultGoal == base.defaultGoal )
                    && ( resources == null || resources == base.resources )
                    && ( testResources == null || testResources == base.testResources )
                    && ( directory == null || directory == base.directory )
                    && ( finalName == null || finalName == base.finalName )
                    && ( filters == null || filters == base.filters )
                    && ( sourceDirectory == null || sourceDirectory == base.sourceDirectory )
                    && ( scriptSourceDirectory == null || scriptSourceDirectory == base.scriptSourceDirectory )
                    && ( testSourceDirectory == null || testSourceDirectory == base.testSourceDirectory )
                    && ( outputDirectory == null || outputDirectory == base.outputDirectory )
                    && ( testOutputDirectory == null || testOutputDirectory == base.testOutputDirectory )
                    && ( extensions == null || extensions == base.extensions )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation pluginsLocation = null;
            InputLocation pluginManagementLocation = null;
            InputLocation defaultGoalLocation = null;
            InputLocation resourcesLocation = null;
            InputLocation testResourcesLocation = null;
            InputLocation directoryLocation = null;
            InputLocation finalNameLocation = null;
            InputLocation filtersLocation = null;
            InputLocation sourceDirectoryLocation = null;
            InputLocation scriptSourceDirectoryLocation = null;
            InputLocation testSourceDirectoryLocation = null;
            InputLocation outputDirectoryLocation = null;
            InputLocation testOutputDirectoryLocation = null;
            InputLocation extensionsLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                pluginsLocation = locations.remove( "plugins" );
                pluginManagementLocation = locations.remove( "pluginManagement" );
                defaultGoalLocation = locations.remove( "defaultGoal" );
                resourcesLocation = locations.remove( "resources" );
                testResourcesLocation = locations.remove( "testResources" );
                directoryLocation = locations.remove( "directory" );
                finalNameLocation = locations.remove( "finalName" );
                filtersLocation = locations.remove( "filters" );
                sourceDirectoryLocation = locations.remove( "sourceDirectory" );
                scriptSourceDirectoryLocation = locations.remove( "scriptSourceDirectory" );
                testSourceDirectoryLocation = locations.remove( "testSourceDirectory" );
                outputDirectoryLocation = locations.remove( "outputDirectory" );
                testOutputDirectoryLocation = locations.remove( "testOutputDirectory" );
                extensionsLocation = locations.remove( "extensions" );
            }
            return new Build(
                plugins != null ? plugins : ( base != null ? base.plugins : null ),
                pluginManagement != null ? pluginManagement : ( base != null ? base.pluginManagement : null ),
                defaultGoal != null ? defaultGoal : ( base != null ? base.defaultGoal : null ),
                resources != null ? resources : ( base != null ? base.resources : null ),
                testResources != null ? testResources : ( base != null ? base.testResources : null ),
                directory != null ? directory : ( base != null ? base.directory : null ),
                finalName != null ? finalName : ( base != null ? base.finalName : null ),
                filters != null ? filters : ( base != null ? base.filters : null ),
                sourceDirectory != null ? sourceDirectory : ( base != null ? base.sourceDirectory : null ),
                scriptSourceDirectory != null ? scriptSourceDirectory : ( base != null ? base.scriptSourceDirectory : null ),
                testSourceDirectory != null ? testSourceDirectory : ( base != null ? base.testSourceDirectory : null ),
                outputDirectory != null ? outputDirectory : ( base != null ? base.outputDirectory : null ),
                testOutputDirectory != null ? testOutputDirectory : ( base != null ? base.testOutputDirectory : null ),
                extensions != null ? extensions : ( base != null ? base.extensions : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                pluginsLocation != null ? pluginsLocation : ( base != null ? base.pluginsLocation : null ),
                pluginManagementLocation != null ? pluginManagementLocation : ( base != null ? base.pluginManagementLocation : null ),
                defaultGoalLocation != null ? defaultGoalLocation : ( base != null ? base.defaultGoalLocation : null ),
                resourcesLocation != null ? resourcesLocation : ( base != null ? base.resourcesLocation : null ),
                testResourcesLocation != null ? testResourcesLocation : ( base != null ? base.testResourcesLocation : null ),
                directoryLocation != null ? directoryLocation : ( base != null ? base.directoryLocation : null ),
                finalNameLocation != null ? finalNameLocation : ( base != null ? base.finalNameLocation : null ),
                filtersLocation != null ? filtersLocation : ( base != null ? base.filtersLocation : null ),
                sourceDirectoryLocation != null ? sourceDirectoryLocation : ( base != null ? base.sourceDirectoryLocation : null ),
                scriptSourceDirectoryLocation != null ? scriptSourceDirectoryLocation : ( base != null ? base.scriptSourceDirectoryLocation : null ),
                testSourceDirectoryLocation != null ? testSourceDirectoryLocation : ( base != null ? base.testSourceDirectoryLocation : null ),
                outputDirectoryLocation != null ? outputDirectoryLocation : ( base != null ? base.outputDirectoryLocation : null ),
                testOutputDirectoryLocation != null ? testOutputDirectoryLocation : ( base != null ? base.testOutputDirectoryLocation : null ),
                extensionsLocation != null ? extensionsLocation : ( base != null ? base.extensionsLocation : null )
            );
        }
    }

}
