// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * This is an activator which will detect an operating system's attributes in order
 * to activate its profile.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class ActivationOS
    implements Serializable, InputLocationTracker
{
    /**
     * The name of the operating system to be used to activate the profile. This must be an exact match
     * of the {@code ${os.name}} Java property, such as {@code Windows XP}.
     */
    final String name;
    /**
     * The general family of the OS to be used to activate the profile, such as
     * {@code windows} or {@code unix}.
     */
    final String family;
    /**
     * The architecture of the operating system to be used to activate the
     * profile.
     */
    final String arch;
    /**
     * The version of the operating system to be used to activate the
     * profile.
     */
    final String version;
    /** Location of the xml element for this object. */
    final InputLocation location;
    /** Location of the xml element for the field name. */
    final InputLocation nameLocation;
    /** Location of the xml element for the field family. */
    final InputLocation familyLocation;
    /** Location of the xml element for the field arch. */
    final InputLocation archLocation;
    /** Location of the xml element for the field version. */
    final InputLocation versionLocation;
    /** Other locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    ActivationOS(
        String name,
        String family,
        String arch,
        String version,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation nameLocation,
        InputLocation familyLocation,
        InputLocation archLocation,
        InputLocation versionLocation
    )
    {
        this.name = name;
        this.family = family;
        this.arch = arch;
        this.version = version;
        this.locations = ImmutableCollections.copy( locations );
        this.location = location;
        this.nameLocation = nameLocation;
        this.familyLocation = familyLocation;
        this.archLocation = archLocation;
        this.versionLocation = versionLocation;
    }

    /**
     * The name of the operating system to be used to activate the profile. This must be an exact match
     * of the {@code ${os.name}} Java property, such as {@code Windows XP}.
     *
     * @return a {@code String}
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * The general family of the OS to be used to activate the profile, such as
     * {@code windows} or {@code unix}.
     *
     * @return a {@code String}
     */
    public String getFamily()
    {
        return this.family;
    }

    /**
     * The architecture of the operating system to be used to activate the
     * profile.
     *
     * @return a {@code String}
     */
    public String getArch()
    {
        return this.arch;
    }

    /**
     * The version of the operating system to be used to activate the
     * profile.
     *
     * @return a {@code String}
     */
    public String getVersion()
    {
        return this.version;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "":
                    return location;
                case "name":
                    return nameLocation;
                case "family":
                    return familyLocation;
                case "arch":
                    return archLocation;
                case "version":
                    return versionLocation;
            }
        }
        return locations != null ? locations.get( key ) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code ActivationOS} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code ActivationOS} with the specified name
     */
    @Nonnull
    public ActivationOS withName( String name )
    {
        return with().name( name ).build();
    }
    /**
     * Creates a new {@code ActivationOS} instance using the specified family.
     *
     * @param family the new {@code String} to use
     * @return a {@code ActivationOS} with the specified family
     */
    @Nonnull
    public ActivationOS withFamily( String family )
    {
        return with().family( family ).build();
    }
    /**
     * Creates a new {@code ActivationOS} instance using the specified arch.
     *
     * @param arch the new {@code String} to use
     * @return a {@code ActivationOS} with the specified arch
     */
    @Nonnull
    public ActivationOS withArch( String arch )
    {
        return with().arch( arch ).build();
    }
    /**
     * Creates a new {@code ActivationOS} instance using the specified version.
     *
     * @param version the new {@code String} to use
     * @return a {@code ActivationOS} with the specified version
     */
    @Nonnull
    public ActivationOS withVersion( String version )
    {
        return with().version( version ).build();
    }

    /**
     * Creates a new {@code ActivationOS} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code ActivationOS}
     */
    @Nonnull
    public static ActivationOS newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code ActivationOS} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code ActivationOS}
     */
    @Nonnull
    public static ActivationOS newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code ActivationOS} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code ActivationOS} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code ActivationOS} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code ActivationOS} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( ActivationOS from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code ActivationOS} builder instance using the specified object as a basis.
     *
     * @param from the {@code ActivationOS} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( ActivationOS from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create ActivationOS instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        ActivationOS base;
        String name;
        String family;
        String arch;
        String version;
        Map<Object, InputLocation> locations;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( ActivationOS base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.name = base.name;
                this.family = base.family;
                this.arch = base.arch;
                this.version = base.version;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name( String name )
        {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder family( String family )
        {
            this.family = family;
            return this;
        }

        @Nonnull
        public Builder arch( String arch )
        {
            this.arch = arch;
            return this;
        }

        @Nonnull
        public Builder version( String version )
        {
            this.version = version;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public ActivationOS build()
        {
            if ( base != null
                    && ( name == null || name == base.name )
                    && ( family == null || family == base.family )
                    && ( arch == null || arch == base.arch )
                    && ( version == null || version == base.version )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation nameLocation = null;
            InputLocation familyLocation = null;
            InputLocation archLocation = null;
            InputLocation versionLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                nameLocation = locations.remove( "name" );
                familyLocation = locations.remove( "family" );
                archLocation = locations.remove( "arch" );
                versionLocation = locations.remove( "version" );
            }
            return new ActivationOS(
                name != null ? name : ( base != null ? base.name : null ),
                family != null ? family : ( base != null ? base.family : null ),
                arch != null ? arch : ( base != null ? base.arch : null ),
                version != null ? version : ( base != null ? base.version : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                nameLocation != null ? nameLocation : ( base != null ? base.nameLocation : null ),
                familyLocation != null ? familyLocation : ( base != null ? base.familyLocation : null ),
                archLocation != null ? archLocation : ( base != null ? base.archLocation : null ),
                versionLocation != null ? versionLocation : ( base != null ? base.versionLocation : null )
            );
        }
    }

}
