/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;

public class MappedCollection<U, V>
extends AbstractCollection<U> {
    private final Collection<V> list;
    private final Function<V, U> mapper;

    public MappedCollection(Collection<V> list, Function<V, U> mapper) {
        this.list = list;
        this.mapper = mapper;
    }

    @Override
    public Iterator<U> iterator() {
        final Iterator<V> it = this.list.iterator();
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public U next() {
                return MappedCollection.this.mapper.apply(it.next());
            }
        };
    }

    @Override
    public int size() {
        return this.list.size();
    }
}

