/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.DownloadedArtifact;
import org.apache.maven.api.Session;
import org.apache.maven.api.Version;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.ArtifactResolverException;
import org.apache.maven.api.services.ModelResolver;
import org.apache.maven.api.services.ModelResolverException;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.VersionRangeResolverException;

@Named
@Singleton
public class DefaultModelResolver
implements ModelResolver {
    public ModelSource resolveModel(Session session, String groupId, String artifactId, String version, Consumer<String> resolvedVersion) throws ModelResolverException {
        try {
            ArtifactCoordinates coords = session.createArtifactCoordinates(groupId, artifactId, version, "pom");
            if (coords.getVersionConstraint().getVersionRange() != null && coords.getVersionConstraint().getVersionRange().getUpperBoundary() == null) {
                throw new ModelResolverException(String.format("The requested version range '%s' does not specify an upper bound", version), groupId, artifactId, version);
            }
            List versions = session.resolveVersionRange(coords);
            if (versions.isEmpty()) {
                throw new ModelResolverException(String.format("No versions matched the requested version range '%s'", version), groupId, artifactId, version);
            }
            String newVersion = ((Version)versions.get(versions.size() - 1)).asString();
            if (!version.equals(newVersion)) {
                resolvedVersion.accept(newVersion);
            }
            DownloadedArtifact resolved = session.resolveArtifact(session.createArtifactCoordinates(groupId, artifactId, newVersion, "pom"));
            final Path path = resolved.getPath();
            final String location = groupId + ":" + artifactId + ":" + newVersion;
            return new ModelSource(){

                public ModelSource resolve(ModelSource.ModelLocator modelLocator, String relative) {
                    return null;
                }

                public Path getPath() {
                    return null;
                }

                public InputStream openStream() throws IOException {
                    return Files.newInputStream(path, new OpenOption[0]);
                }

                public String getLocation() {
                    return location;
                }

                public Source resolve(String relative) {
                    return null;
                }
            };
        }
        catch (ArtifactResolverException | VersionRangeResolverException e) {
            throw new ModelResolverException(e.getMessage() + " (remote repositories: " + session.getRemoteRepositories().stream().map(Object::toString).collect(Collectors.joining(", ")) + ")", groupId, artifactId, version, e);
        }
    }
}

