/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.maven.api.services.ModelCache;
import org.apache.maven.api.services.Source;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystemSession;

public class DefaultModelCache
implements ModelCache {
    private static final String KEY = DefaultModelCache.class.getName();
    private final ConcurrentMap<Object, Supplier<?>> cache;

    public static ModelCache newInstance(RepositorySystemSession session, boolean anew) {
        ConcurrentHashMap cache;
        RepositoryCache repositoryCache;
        RepositoryCache repositoryCache2 = repositoryCache = session != null ? session.getCache() : null;
        if (repositoryCache == null) {
            return new DefaultModelCache(new ConcurrentHashMap());
        }
        if (anew) {
            cache = new ConcurrentHashMap();
            repositoryCache.put(session, (Object)KEY, (Object)cache);
        } else {
            cache = (ConcurrentHashMap)repositoryCache.computeIfAbsent(session, (Object)KEY, ConcurrentHashMap::new);
        }
        return new DefaultModelCache(cache);
    }

    public DefaultModelCache() {
        this(new ConcurrentHashMap());
    }

    private DefaultModelCache(ConcurrentMap<Object, Supplier<?>> cache) {
        this.cache = Objects.requireNonNull(cache);
    }

    public <T> T computeIfAbsent(String groupId, String artifactId, String version, String tag, Supplier<T> data) {
        return (T)this.computeIfAbsent(new GavCacheKey(groupId, artifactId, version, tag), data);
    }

    public <T> T computeIfAbsent(Source path, String tag, Supplier<T> data) {
        return (T)this.computeIfAbsent(new SourceCacheKey(path, tag), data);
    }

    protected Object computeIfAbsent(Object key, Supplier<?> data) {
        return this.cache.computeIfAbsent(key, (? super K k) -> new CachingSupplier(data)).get();
    }

    static <T extends Throwable> void uncheckedThrow(Throwable t) throws T {
        throw t;
    }

    static class GavCacheKey {
        private final String gav;
        private final String tag;
        private final int hash;

        GavCacheKey(String groupId, String artifactId, String version, String tag) {
            this(GavCacheKey.gav(groupId, artifactId, version), tag);
        }

        GavCacheKey(String gav, String tag) {
            this.gav = gav;
            this.tag = tag;
            this.hash = Objects.hash(gav, tag);
        }

        private static String gav(String groupId, String artifactId, String version) {
            StringBuilder sb = new StringBuilder();
            if (groupId != null) {
                sb.append(groupId);
            }
            sb.append(":");
            if (artifactId != null) {
                sb.append(artifactId);
            }
            sb.append(":");
            if (version != null) {
                sb.append(version);
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (null == obj || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            GavCacheKey that = (GavCacheKey)obj;
            return Objects.equals(this.gav, that.gav) && Objects.equals(this.tag, that.tag);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return "GavCacheKey[gav='" + this.gav + "', tag='" + this.tag + "']";
        }
    }

    private static final class SourceCacheKey {
        private final Source source;
        private final String tag;
        private final int hash;

        SourceCacheKey(Source source, String tag) {
            this.source = source;
            this.tag = tag;
            this.hash = Objects.hash(source, tag);
        }

        public String toString() {
            return "SourceCacheKey[location=" + this.source.getLocation() + ", tag=" + this.tag + ", path=" + this.source.getPath() + "]";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (null == obj || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            SourceCacheKey that = (SourceCacheKey)obj;
            return Objects.equals(this.source, that.source) && Objects.equals(this.tag, that.tag);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    static class CachingSupplier<T>
    implements Supplier<T> {
        final Supplier<T> supplier;
        volatile Object value;

        CachingSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            Object v = this.value;
            if (v == null) {
                CachingSupplier cachingSupplier = this;
                synchronized (cachingSupplier) {
                    v = this.value;
                    if (v == null) {
                        try {
                            v = this.value = this.supplier.get();
                        }
                        catch (Exception e) {
                            v = this.value = new AltRes(e);
                        }
                    }
                }
            }
            if (v instanceof AltRes) {
                DefaultModelCache.uncheckedThrow(((AltRes)v).t);
            }
            return (T)v;
        }

        static class AltRes {
            final Throwable t;

            AltRes(Throwable t) {
                this.t = t;
            }
        }
    }
}

