/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.maven.api.Dependency;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.Node;
import org.apache.maven.api.PathType;
import org.apache.maven.api.services.DependencyResolverException;
import org.apache.maven.api.services.DependencyResolverResult;
import org.apache.maven.internal.impl.PathModularization;
import org.apache.maven.internal.impl.PathModularizationCache;

class DefaultDependencyResolverResult
implements DependencyResolverResult {
    private final List<Exception> exceptions;
    private final Node root;
    private final List<Node> nodes;
    private final List<Path> paths;
    private final Map<PathType, List<Path>> dispatchedPaths;
    private final Map<Dependency, Path> dependencies;
    private PathModularization outputModules;
    private final PathModularizationCache cache;

    DefaultDependencyResolverResult(PathModularizationCache cache, List<Exception> exceptions, Node root, int count) {
        this.cache = cache;
        this.exceptions = exceptions;
        this.root = root;
        this.nodes = new ArrayList<Node>(count);
        this.paths = new ArrayList<Path>(count);
        this.dispatchedPaths = new LinkedHashMap<PathType, List<Path>>();
        this.dependencies = new LinkedHashMap<Dependency, Path>(count + count / 3);
    }

    private void addPathElement(PathType type, Path path) {
        this.dispatchedPaths.computeIfAbsent(type, t -> new ArrayList()).add(path);
    }

    void addOutputDirectory(Path main, Path test) throws IOException {
        if (this.outputModules != null) {
            throw new IllegalStateException("Output directories must be set first and only once.");
        }
        if (main != null) {
            this.outputModules = this.cache.getModuleInfo(main);
            this.addPathElement((PathType)this.outputModules.getPathType(), main);
        } else {
            this.outputModules = PathModularization.NONE;
        }
        if (test != null) {
            boolean addToClasspath = true;
            PathModularization testModules = this.cache.getModuleInfo(test);
            boolean isModuleHierarchy = this.outputModules.isModuleHierarchy || testModules.isModuleHierarchy;
            for (Object object : this.outputModules.descriptors.values()) {
                String moduleName = DefaultDependencyResolverResult.name(object);
                Path subdir = test;
                if (isModuleHierarchy) {
                    Path path = test.resolve(moduleName);
                    if (!Files.isDirectory(path, new LinkOption[0])) continue;
                    subdir = path;
                }
                this.addPathElement((PathType)JavaPathType.patchModule((String)moduleName), subdir);
                addToClasspath = false;
            }
            for (Map.Entry entry : testModules.descriptors.entrySet()) {
                if (this.outputModules.containsModule(DefaultDependencyResolverResult.name(entry.getValue()))) continue;
                this.addPathElement((PathType)JavaPathType.MODULES, (Path)entry.getKey());
                addToClasspath = false;
            }
            if (addToClasspath) {
                this.addPathElement((PathType)JavaPathType.CLASSES, test);
            }
        }
    }

    void addNode(Node node) {
        this.nodes.add(node);
    }

    void addDependency(Node node, Dependency dep, Predicate<PathType> filter, Path path) throws IOException {
        this.nodes.add(node);
        if (dep == null) {
            return;
        }
        if (this.dependencies.put(dep, path) != null) {
            throw new IllegalStateException("Duplicated key: " + dep);
        }
        if (path == null) {
            return;
        }
        this.paths.add(path);
        Set pathTypes = dep.getType().getPathTypes();
        if (this.containsPatches(pathTypes)) {
            Path main;
            if (this.outputModules == null) {
                this.outputModules = PathModularization.NONE;
            }
            JavaPathType.Modular type = null;
            for (Map.Entry<Path, Object> info : this.cache.getModuleInfo((Path)path).descriptors.entrySet()) {
                String moduleName = DefaultDependencyResolverResult.name(info.getValue());
                type = JavaPathType.patchModule((String)moduleName);
                if (!this.containsModule(moduleName)) {
                    type = this.cache.selectPathType(pathTypes, filter, path).orElse((PathType)type);
                }
                this.addPathElement((PathType)type, info.getKey());
            }
            if (type == null && (main = this.findArtifactPath(dep.getGroupId(), dep.getArtifactId())) != null) {
                for (Map.Entry<Path, Object> info : this.cache.getModuleInfo((Path)main).descriptors.entrySet()) {
                    type = JavaPathType.patchModule((String)DefaultDependencyResolverResult.name(info.getValue()));
                    this.addPathElement((PathType)type, info.getKey());
                }
            }
            if (type != null) {
                return;
            }
        }
        this.addPathElement(this.cache.selectPathType(pathTypes, filter, path).orElse(PathType.UNRESOLVED), path);
    }

    private boolean containsPatches(Set<PathType> types) {
        for (PathType type : types) {
            if (type instanceof JavaPathType.Modular) {
                type = ((JavaPathType.Modular)type).rawType();
            }
            if (!JavaPathType.PATCH_MODULE.equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    private boolean containsModule(String moduleName) throws IOException {
        for (Path path : this.dispatchedPaths.getOrDefault(JavaPathType.MODULES, Collections.emptyList())) {
            if (!this.cache.getModuleInfo(path).containsModule(moduleName)) continue;
            return true;
        }
        return false;
    }

    private Path findArtifactPath(String group, String artifact) throws IOException {
        for (Map.Entry<Dependency, Path> entry : this.dependencies.entrySet()) {
            Dependency dep = entry.getKey();
            if (!group.equals(dep.getGroupId()) || !artifact.equals(dep.getArtifactId())) continue;
            return entry.getValue();
        }
        return null;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public Node getRoot() {
        return this.root;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Path> getPaths() {
        return this.paths;
    }

    public Map<PathType, List<Path>> getDispatchedPaths() {
        return this.dispatchedPaths;
    }

    public Map<Dependency, Path> getDependencies() {
        return this.dependencies;
    }

    public Optional<ModuleDescriptor> getModuleDescriptor(Path dependency) throws IOException {
        Object value = this.cache.getModuleInfo((Path)dependency).descriptors.get(dependency);
        return value instanceof ModuleDescriptor ? Optional.of((ModuleDescriptor)value) : Optional.empty();
    }

    public Optional<String> getModuleName(Path dependency) throws IOException {
        return Optional.ofNullable(DefaultDependencyResolverResult.name(this.cache.getModuleInfo((Path)dependency).descriptors.get(dependency)));
    }

    private static String name(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof ModuleDescriptor) {
            return ((ModuleDescriptor)value).name();
        }
        return null;
    }

    public Optional<String> warningForFilenameBasedAutomodules() {
        try {
            return this.cache.warningForFilenameBasedAutomodules((Collection<Path>)this.dispatchedPaths.get(JavaPathType.MODULES));
        }
        catch (IOException e) {
            throw new DependencyResolverException("Cannot read module information.", (Throwable)e);
        }
    }
}

