/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.di.tool;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.maven.api.di.Named;

@SupportedAnnotationTypes(value={"org.apache.maven.api.di.Named"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class DiIndexProcessor
extends AbstractProcessor {
    private final Set<String> processedClasses = new HashSet<String>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.logMessage(Diagnostic.Kind.NOTE, "Processing " + roundEnv.getRootElements().size() + " classes");
        for (Element element : roundEnv.getElementsAnnotatedWith(Named.class)) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            String className = this.getFullClassName(typeElement);
            this.processedClasses.add(className);
        }
        if (roundEnv.processingOver()) {
            try {
                this.updateFileIfChanged();
            }
            catch (Exception e) {
                this.logError("Error updating file", e);
            }
        }
        return true;
    }

    private String getFullClassName(TypeElement typeElement) {
        Object className = typeElement.getQualifiedName().toString();
        Element enclosingElement = typeElement.getEnclosingElement();
        if (enclosingElement instanceof TypeElement) {
            String enclosingClassName = ((TypeElement)enclosingElement).getQualifiedName().toString();
            className = enclosingClassName + "$" + typeElement.getSimpleName();
        }
        return className;
    }

    private void updateFileIfChanged() throws IOException {
        block20: {
            String path = "META-INF/maven/org.apache.maven.api.di.Inject";
            TreeSet<String> existingClasses = new TreeSet<String>();
            String existingContent = "";
            try {
                FileObject inputFile = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", path);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputFile.openInputStream()));){
                    Object line;
                    StringBuilder contentBuilder = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        if (!((String)line).trim().startsWith("#")) {
                            existingClasses.add(((String)line).trim());
                        }
                        contentBuilder.append((String)line).append("\n");
                    }
                    existingContent = contentBuilder.toString();
                }
            }
            catch (IOException e) {
                this.logMessage(Diagnostic.Kind.NOTE, "Unable to read existing file. Proceeding with empty content.");
            }
            TreeSet<String> allClasses = new TreeSet<String>((Collection<String>)existingClasses);
            allClasses.addAll(this.processedClasses);
            StringBuilder newContentBuilder = new StringBuilder();
            for (String className : allClasses) {
                newContentBuilder.append(className).append("\n");
            }
            String newContent = newContentBuilder.toString();
            if (!newContent.equals(existingContent)) {
                this.logMessage(Diagnostic.Kind.NOTE, "Content has changed. Updating file.");
                try {
                    FileObject outputFile = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", path, new Element[0]);
                    try (Writer writer = outputFile.openWriter();){
                        writer.write(newContent);
                        break block20;
                    }
                }
                catch (IOException e) {
                    this.logError("Failed to write to file", e);
                    throw e;
                }
            }
            this.logMessage(Diagnostic.Kind.NOTE, "Content unchanged. Skipping file update.");
        }
    }

    private void logMessage(Diagnostic.Kind kind, String message) {
        this.processingEnv.getMessager().printMessage(kind, message);
    }

    private void logError(String message, Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String stackTrace = sw.toString();
        String fullMessage = message + "\nException: " + e.getClass().getName() + "\nMessage: " + e.getMessage() + "\nStack trace:\n" + stackTrace;
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, fullMessage);
    }
}

