/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.maven.index.reader.Record;
import org.apache.maven.index.reader.ResourceHandler;
import org.apache.maven.index.reader.WritableResourceHandler;

public final class Utils {
    public static final String INDEX_FILE_PREFIX = "nexus-maven-repository-index";
    public static final DateFormat INDEX_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss.SSS Z");
    public static final String FIELD_SEPARATOR = "|";
    public static final String NOT_AVAILABLE = "NA";
    public static final String UINFO = "u";
    public static final String INFO = "i";
    public static final Pattern FS_PATTERN;

    private Utils() {
    }

    public static Properties loadProperties(ResourceHandler.Resource resource) throws IOException {
        try (InputStream inputStream = resource.read();){
            if (inputStream == null) {
                Properties properties = null;
                return properties;
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
    }

    public static void storeProperties(WritableResourceHandler.WritableResource writableResource, Properties properties) throws IOException {
        try (WritableResourceHandler.WritableResource writableResource2 = writableResource;
             OutputStream outputStream = writableResource.write();){
            properties.store(outputStream, "Maven Indexer Writer");
        }
    }

    public static Record descriptor(String repoId) {
        HashMap<Record.EntryKey, Object> entries = new HashMap<Record.EntryKey, Object>();
        entries.put(Record.REPOSITORY_ID, repoId);
        return new Record(Record.Type.DESCRIPTOR, entries);
    }

    public static Record allGroups(Collection<String> allGroups) {
        HashMap<Record.EntryKey, Object> entries = new HashMap<Record.EntryKey, Object>();
        entries.put(Record.ALL_GROUPS, allGroups.toArray(new String[0]));
        return new Record(Record.Type.ALL_GROUPS, entries);
    }

    public static Record rootGroups(Collection<String> rootGroups) {
        HashMap<Record.EntryKey, Object> entries = new HashMap<Record.EntryKey, Object>();
        entries.put(Record.ROOT_GROUPS, rootGroups.toArray(new String[0]));
        return new Record(Record.Type.ROOT_GROUPS, entries);
    }

    public static String renvl(String v) {
        return NOT_AVAILABLE.equals(v) ? null : v;
    }

    public static String nvl(String v) {
        return v == null ? NOT_AVAILABLE : v;
    }

    public static String rootGroup(String groupId) {
        int n = groupId.indexOf(46);
        if (n > -1) {
            return groupId.substring(0, n);
        }
        return groupId;
    }

    static {
        INDEX_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        FS_PATTERN = Pattern.compile(Pattern.quote(FIELD_SEPARATOR));
    }
}

