/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.idversion;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.idversion.IDVersionTermState;
import org.apache.lucene.codecs.idversion.SingleDocsEnum;
import org.apache.lucene.codecs.idversion.SinglePostingsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;

final class IDVersionPostingsReader
extends PostingsReaderBase {
    IDVersionPostingsReader() {
    }

    @Override
    public void init(IndexInput termsIn, SegmentReadState state) throws IOException {
        CodecUtil.checkIndexHeader(termsIn, "IDVersionPostingsWriterTerms", 1, 1, state.segmentInfo.getId(), state.segmentSuffix);
    }

    @Override
    public BlockTermState newTermState() {
        return new IDVersionTermState();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void decodeTerm(DataInput in, FieldInfo fieldInfo, BlockTermState _termState, boolean absolute) throws IOException {
        IDVersionTermState termState = (IDVersionTermState)_termState;
        termState.docID = in.readVInt();
        termState.idVersion = absolute ? in.readVLong() : (termState.idVersion += in.readZLong());
    }

    @Override
    public PostingsEnum postings(FieldInfo fieldInfo, BlockTermState termState, PostingsEnum reuse, int flags) throws IOException {
        if (PostingsEnum.featureRequested(flags, (short)24)) {
            SinglePostingsEnum posEnum = reuse instanceof SinglePostingsEnum ? (SinglePostingsEnum)reuse : new SinglePostingsEnum();
            IDVersionTermState _termState = (IDVersionTermState)termState;
            posEnum.reset(_termState.docID, _termState.idVersion);
            return posEnum;
        }
        SingleDocsEnum docsEnum = reuse instanceof SingleDocsEnum ? (SingleDocsEnum)reuse : new SingleDocsEnum();
        docsEnum.reset(((IDVersionTermState)termState).docID);
        return docsEnum;
    }

    @Override
    public ImpactsEnum impacts(FieldInfo fieldInfo, BlockTermState state, int flags) throws IOException {
        throw new UnsupportedOperationException("Should never be called, IDVersionSegmentTermsEnum implements impacts directly");
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public void checkIntegrity() throws IOException {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

