/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.creator;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.ZipFile;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.document.Document;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.creator.AbstractIndexCreator;

@Singleton
@Named(value="maven-archetype")
public class MavenArchetypeArtifactInfoIndexCreator
extends AbstractIndexCreator {
    public static final String ID = "maven-archetype";
    private static final String MAVEN_ARCHETYPE_PACKAGING = "maven-archetype";
    private static final String[] ARCHETYPE_XML_LOCATIONS = new String[]{"META-INF/maven/archetype.xml", "META-INF/archetype.xml", "META-INF/maven/archetype-metadata.xml"};

    public MavenArchetypeArtifactInfoIndexCreator() {
        super("maven-archetype", Arrays.asList("min"));
    }

    @Override
    public void populateArtifactInfo(ArtifactContext ac) {
        File artifact = ac.getArtifact();
        ArtifactInfo ai = ac.getArtifactInfo();
        if (artifact != null && artifact.isFile() && !"maven-archetype".equals(ai.getPackaging()) && artifact.getName().endsWith(".jar")) {
            this.checkMavenArchetype(ai, artifact);
        }
    }

    private void checkMavenArchetype(ArtifactInfo ai, File artifact) {
        try (ZipFile zipFile = new ZipFile(artifact);){
            for (String path : ARCHETYPE_XML_LOCATIONS) {
                if (zipFile.getEntry(path) == null) continue;
                ai.setPackaging("maven-archetype");
                return;
            }
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().info("Failed to parse Maven artifact " + artifact.getAbsolutePath() + " due to exception:", e);
            }
            this.getLogger().info("Failed to parse Maven artifact " + artifact.getAbsolutePath() + " due to " + e.getMessage());
        }
    }

    @Override
    public void updateDocument(ArtifactInfo ai, Document doc) {
    }

    @Override
    public boolean updateArtifactInfo(Document doc, ArtifactInfo ai) {
        return false;
    }

    public String toString() {
        return "maven-archetype";
    }

    @Override
    public Collection<IndexerField> getIndexerFields() {
        return Collections.emptyList();
    }
}

