/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.maven.index.Field;
import org.apache.maven.index.IndexerFieldVersion;

public class IndexerField {
    private final Field ontology;
    private final IndexerFieldVersion version;
    private final String key;
    private final FieldType fieldType;
    public static final FieldType KEYWORD_NOT_STORED = new FieldType();
    public static final FieldType KEYWORD_STORED = new FieldType();
    public static final FieldType ANALYZED_NOT_STORED = new FieldType();
    public static final FieldType ANALYZED_STORED = new FieldType();

    public IndexerField(Field ontology, IndexerFieldVersion version, String key, String description, FieldType fieldType) {
        this.ontology = ontology;
        this.version = version;
        this.key = key;
        this.fieldType = fieldType;
        ontology.addIndexerField(this);
    }

    public Field getOntology() {
        return this.ontology;
    }

    public IndexerFieldVersion getVersion() {
        return this.version;
    }

    public String getKey() {
        return this.key;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public boolean isIndexed() {
        return this.fieldType.indexOptions() != IndexOptions.NONE;
    }

    public boolean isKeyword() {
        return this.isIndexed() && !this.fieldType.tokenized();
    }

    public boolean isStored() {
        return this.fieldType.stored();
    }

    public org.apache.lucene.document.Field toField(String value) {
        return new org.apache.lucene.document.Field(this.getKey(), value, (IndexableFieldType)this.getFieldType());
    }

    static {
        KEYWORD_NOT_STORED.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        KEYWORD_NOT_STORED.setStored(false);
        KEYWORD_NOT_STORED.setTokenized(false);
        KEYWORD_NOT_STORED.freeze();
        KEYWORD_STORED.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        KEYWORD_STORED.setStored(true);
        KEYWORD_STORED.setTokenized(false);
        KEYWORD_STORED.freeze();
        ANALYZED_NOT_STORED.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        ANALYZED_NOT_STORED.setStored(false);
        ANALYZED_NOT_STORED.setTokenized(true);
        ANALYZED_NOT_STORED.freeze();
        ANALYZED_STORED.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        ANALYZED_STORED.setStored(true);
        ANALYZED_STORED.setTokenized(true);
        ANALYZED_STORED.freeze();
    }
}

