/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cz;

import org.apache.lucene.analysis.util.StemmerUtil;

public class CzechStemmer {
    public int stem(char[] s2, int len) {
        len = this.removeCase(s2, len);
        if ((len = this.removePossessives(s2, len)) > 0) {
            len = this.normalize(s2, len);
        }
        return len;
    }

    private int removeCase(char[] s2, int len) {
        if (len > 7 && StemmerUtil.endsWith(s2, len, "atech")) {
            return len - 5;
        }
        if (len > 6 && (StemmerUtil.endsWith(s2, len, "\u011btem") || StemmerUtil.endsWith(s2, len, "etem") || StemmerUtil.endsWith(s2, len, "at\u016fm"))) {
            return len - 4;
        }
        if (len > 5 && (StemmerUtil.endsWith(s2, len, "ech") || StemmerUtil.endsWith(s2, len, "ich") || StemmerUtil.endsWith(s2, len, "\u00edch") || StemmerUtil.endsWith(s2, len, "\u00e9ho") || StemmerUtil.endsWith(s2, len, "\u011bmi") || StemmerUtil.endsWith(s2, len, "emi") || StemmerUtil.endsWith(s2, len, "\u00e9mu") || StemmerUtil.endsWith(s2, len, "\u011bte") || StemmerUtil.endsWith(s2, len, "ete") || StemmerUtil.endsWith(s2, len, "\u011bti") || StemmerUtil.endsWith(s2, len, "eti") || StemmerUtil.endsWith(s2, len, "\u00edho") || StemmerUtil.endsWith(s2, len, "iho") || StemmerUtil.endsWith(s2, len, "\u00edmi") || StemmerUtil.endsWith(s2, len, "\u00edmu") || StemmerUtil.endsWith(s2, len, "imu") || StemmerUtil.endsWith(s2, len, "\u00e1ch") || StemmerUtil.endsWith(s2, len, "ata") || StemmerUtil.endsWith(s2, len, "aty") || StemmerUtil.endsWith(s2, len, "\u00fdch") || StemmerUtil.endsWith(s2, len, "ama") || StemmerUtil.endsWith(s2, len, "ami") || StemmerUtil.endsWith(s2, len, "ov\u00e9") || StemmerUtil.endsWith(s2, len, "ovi") || StemmerUtil.endsWith(s2, len, "\u00fdmi"))) {
            return len - 3;
        }
        if (len > 4 && (StemmerUtil.endsWith(s2, len, "em") || StemmerUtil.endsWith(s2, len, "es") || StemmerUtil.endsWith(s2, len, "\u00e9m") || StemmerUtil.endsWith(s2, len, "\u00edm") || StemmerUtil.endsWith(s2, len, "\u016fm") || StemmerUtil.endsWith(s2, len, "at") || StemmerUtil.endsWith(s2, len, "\u00e1m") || StemmerUtil.endsWith(s2, len, "os") || StemmerUtil.endsWith(s2, len, "us") || StemmerUtil.endsWith(s2, len, "\u00fdm") || StemmerUtil.endsWith(s2, len, "mi") || StemmerUtil.endsWith(s2, len, "ou"))) {
            return len - 2;
        }
        if (len > 3) {
            switch (s2[len - 1]) {
                case 'a': 
                case 'e': 
                case 'i': 
                case 'o': 
                case 'u': 
                case 'y': 
                case '\u00e1': 
                case '\u00e9': 
                case '\u00ed': 
                case '\u00fd': 
                case '\u011b': 
                case '\u016f': {
                    return len - 1;
                }
            }
        }
        return len;
    }

    private int removePossessives(char[] s2, int len) {
        if (len > 5 && (StemmerUtil.endsWith(s2, len, "ov") || StemmerUtil.endsWith(s2, len, "in") || StemmerUtil.endsWith(s2, len, "\u016fv"))) {
            return len - 2;
        }
        return len;
    }

    private int normalize(char[] s2, int len) {
        if (StemmerUtil.endsWith(s2, len, "\u010dt")) {
            s2[len - 2] = 99;
            s2[len - 1] = 107;
            return len;
        }
        if (StemmerUtil.endsWith(s2, len, "\u0161t")) {
            s2[len - 2] = 115;
            s2[len - 1] = 107;
            return len;
        }
        switch (s2[len - 1]) {
            case 'c': 
            case '\u010d': {
                s2[len - 1] = 107;
                return len;
            }
            case 'z': 
            case '\u017e': {
                s2[len - 1] = 104;
                return len;
            }
        }
        if (len > 1 && s2[len - 2] == 'e') {
            s2[len - 2] = s2[len - 1];
            return len - 1;
        }
        if (len > 2 && s2[len - 2] == '\u016f') {
            s2[len - 2] = 111;
            return len;
        }
        return len;
    }
}

