/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;
import org.apache.maven.index.context.NexusAnalyzer;

public class NexusIndexWriter
extends IndexWriter {
    public static IndexWriterConfigFactory CONFIG_FACTORY = new IndexWriterConfigFactory(){

        public IndexWriterConfig create(Analyzer analyzer) {
            IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_36, analyzer);
            config.setRAMBufferSizeMB(2.0);
            config.setMergeScheduler(new SerialMergeScheduler());
            return config;
        }
    };

    public NexusIndexWriter(Directory directory, Analyzer analyzer, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        super(directory, CONFIG_FACTORY.create(analyzer).setOpenMode(create ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND));
    }

    public NexusIndexWriter(Directory directory, IndexWriterConfig config) throws CorruptIndexException, LockObtainFailedException, IOException {
        super(directory, config);
    }

    public static IndexWriterConfig defaultConfig() {
        return CONFIG_FACTORY.create(new NexusAnalyzer());
    }

    public static interface IndexWriterConfigFactory {
        public IndexWriterConfig create(Analyzer var1);
    }
}

