/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.file;

import de.schlichtherle.truezip.fs.file.FileEntry;
import de.schlichtherle.truezip.socket.IOPool;
import java.io.File;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class TempFilePool
implements IOPool<FileEntry> {
    static final TempFilePool INSTANCE = new TempFilePool(null, null);
    @Nullable
    private final File dir;
    private final String name;

    TempFilePool(@CheckForNull File dir, @CheckForNull String name) {
        this.dir = dir;
        this.name = null != name ? name + "." : "tzp";
    }

    @Override
    public Buffer allocate() throws IOException {
        return new Buffer(File.createTempFile(this.name, null, this.dir), this);
    }

    @Override
    public void release(IOPool.Entry<FileEntry> resource) throws IOException {
        resource.release();
    }

    @NotThreadSafe
    private static final class Buffer
    extends FileEntry
    implements IOPool.Entry<FileEntry> {
        Buffer(File file, TempFilePool pool) {
            super(file);
            assert (null != file);
            assert (null != pool);
            this.pool = pool;
        }

        @Override
        public void release() throws IOException {
            if (null == this.pool) {
                throw new IllegalStateException(this.getFile() + " (already released)");
            }
            this.pool(null);
        }

        private void pool(@CheckForNull TempFilePool newPool) throws IOException {
            File file;
            TempFilePool oldPool = this.pool;
            this.pool = newPool;
            if (oldPool != newPool && !(file = this.getFile()).delete() && file.exists()) {
                throw new IOException(file + " (cannot delete temporary file)");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.pool(null);
            }
            finally {
                super.finalize();
            }
        }
    }
}

