/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.creator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.IndexerFieldVersion;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.creator.AbstractIndexCreator;
import org.apache.maven.index.util.zip.ZipFacade;
import org.apache.maven.index.util.zip.ZipHandle;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=IndexCreator.class, hint="maven-plugin")
public class MavenPluginArtifactInfoIndexCreator
extends AbstractIndexCreator {
    public static final String ID = "maven-plugin";
    private static final String MAVEN_PLUGIN_PACKAGING = "maven-plugin";
    public static final IndexerField FLD_PLUGIN_PREFIX = new IndexerField(MAVEN.PLUGIN_PREFIX, IndexerFieldVersion.V1, "px", "MavenPlugin prefix (as keyword, stored)", Field.Store.YES, Field.Index.NOT_ANALYZED);
    public static final IndexerField FLD_PLUGIN_GOALS = new IndexerField(MAVEN.PLUGIN_GOALS, IndexerFieldVersion.V1, "gx", "MavenPlugin goals (as keyword, stored)", Field.Store.YES, Field.Index.ANALYZED);

    public MavenPluginArtifactInfoIndexCreator() {
        super("maven-plugin", Arrays.asList("min"));
    }

    @Override
    public void populateArtifactInfo(ArtifactContext ac) {
        File artifact = ac.getArtifact();
        ArtifactInfo ai = ac.getArtifactInfo();
        if (artifact != null && "maven-plugin".equals(ai.packaging) && artifact.getName().endsWith(".jar")) {
            this.checkMavenPlugin(ai, artifact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMavenPlugin(ArtifactInfo ai, File artifact) {
        block17: {
            ZipHandle handle = null;
            try {
                handle = ZipFacade.getZipHandle(artifact);
                String pluginDescriptorPath = "META-INF/maven/plugin.xml";
                if (!handle.hasEntry("META-INF/maven/plugin.xml")) break block17;
                BufferedInputStream is = new BufferedInputStream(handle.getEntryContent("META-INF/maven/plugin.xml"));
                try {
                    PlexusConfiguration[] mojoConfigs;
                    XmlPlexusConfiguration plexusConfig = new XmlPlexusConfiguration(Xpp3DomBuilder.build(new InputStreamReader(is)));
                    ai.prefix = plexusConfig.getChild("goalPrefix").getValue();
                    ai.goals = new ArrayList<String>();
                    for (PlexusConfiguration mojoConfig : mojoConfigs = plexusConfig.getChild("mojos").getChildren("mojo")) {
                        ai.goals.add(mojoConfig.getChild("goal").getValue());
                    }
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (Exception e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().info("Failed to parse Maven artifact " + artifact.getAbsolutePath() + " due to exception:", e);
                } else {
                    this.getLogger().info("Failed to parse Maven artifact " + artifact.getAbsolutePath() + " due to " + e.getMessage());
                }
            }
            finally {
                try {
                    ZipFacade.close(handle);
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void updateDocument(ArtifactInfo ai, Document doc) {
        if (ai.prefix != null) {
            doc.add(FLD_PLUGIN_PREFIX.toField(ai.prefix));
        }
        if (ai.goals != null) {
            doc.add(FLD_PLUGIN_GOALS.toField(ArtifactInfo.lst2str(ai.goals)));
        }
    }

    @Override
    public boolean updateArtifactInfo(Document doc, ArtifactInfo ai) {
        boolean res = false;
        if ("maven-plugin".equals(ai.packaging)) {
            ai.prefix = doc.get(ArtifactInfo.PLUGIN_PREFIX);
            String goals = doc.get(ArtifactInfo.PLUGIN_GOALS);
            if (goals != null) {
                ai.goals = ArtifactInfo.str2lst(goals);
            }
            res = true;
        }
        return res;
    }

    public String toString() {
        return "maven-plugin";
    }

    @Override
    public Collection<IndexerField> getIndexerFields() {
        return Arrays.asList(FLD_PLUGIN_GOALS, FLD_PLUGIN_PREFIX);
    }
}

