/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.file.FileEntry;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Icon;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class FileController<M extends FsModel>
extends FsController<M> {
    private final M model;
    private final File target;

    FileController(M model) {
        if (null != ((FsModel)model).getParent()) {
            throw new IllegalArgumentException();
        }
        URI uri = ((FsModel)model).getMountPoint().getUri();
        if ('\\' == File.separatorChar && null != uri.getRawAuthority()) {
            try {
                uri = new URI(uri.getScheme(), "", "//" + uri.getAuthority() + uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        this.model = model;
        this.target = new File(uri);
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    public FsController<?> getParent() {
        return null;
    }

    @Override
    public Icon getOpenIcon() throws IOException {
        return null;
    }

    @Override
    public Icon getClosedIcon() throws IOException {
        return null;
    }

    @Override
    public boolean isReadOnly() throws IOException {
        return false;
    }

    @Override
    public FileEntry getEntry(FsEntryName name) throws IOException {
        FileEntry entry = new FileEntry(this.target, name);
        return entry.getFile().exists() ? entry : null;
    }

    @Override
    public boolean isReadable(FsEntryName name) throws IOException {
        File file = new File(this.target, name.getPath());
        return file.canRead();
    }

    @Override
    public boolean isWritable(FsEntryName name) throws IOException {
        File file = new File(this.target, name.getPath());
        return FileController.isCreatableOrWritable(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isCreatableOrWritable(File file) {
        try {
            if (file.createNewFile()) {
                return FileController.isCreatableOrWritable(file) && file.delete();
            }
            if (file.canWrite()) {
                boolean ok;
                long time = file.lastModified();
                if (time < 0L) {
                    return false;
                }
                if (!file.setLastModified(time + 1L)) {
                    return false;
                }
                try {
                    RandomAccessFile raf = new RandomAccessFile(file, "rwd");
                    try {
                        boolean empty;
                        int octet = raf.read();
                        if (octet == -1) {
                            octet = 0;
                            empty = true;
                        } else {
                            empty = false;
                        }
                        raf.seek(0L);
                        raf.write(octet);
                        try {
                            raf.seek(0L);
                            int check = raf.read();
                            ok = octet == check;
                        }
                        finally {
                            if (empty) {
                                raf.setLength(0L);
                            }
                        }
                    }
                    finally {
                        raf.close();
                    }
                }
                finally {
                    if (!file.setLastModified(time)) {
                        ok = false;
                    }
                }
                return ok;
            }
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public void setReadOnly(FsEntryName name) throws IOException {
        File file = new File(this.target, name.getPath());
        if (!file.setReadOnly()) {
            throw new IOException();
        }
    }

    @Override
    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value) throws IOException {
        File file = new File(this.target, name.getPath());
        boolean ok = true;
        for (Entry.Access type : types) {
            ok &= Entry.Access.WRITE == type ? file.setLastModified(value) : false;
        }
        return ok;
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return new FileEntry(this.target, name).getInputSocket();
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return new FileEntry(this.target, name).getOutputSocket(options, template);
    }

    @Override
    public void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        long time;
        File file = new File(this.target, name.getPath());
        switch (type) {
            case FILE: {
                if (options.get(FsOutputOption.EXCLUSIVE)) {
                    if (file.createNewFile()) break;
                    throw new IOException(file.getPath() + " (file exists already)");
                }
                new FileOutputStream(file).close();
                break;
            }
            case DIRECTORY: {
                if (file.mkdir()) break;
                throw new IOException(file.getPath() + " (directory exists already)");
            }
            default: {
                throw new IOException(file.getPath() + " (entry type not supported: " + (Object)((Object)type) + ")");
            }
        }
        if (null != template && -1L != (time = template.getTime(Entry.Access.WRITE)) && !file.setLastModified(time)) {
            throw new IOException(file.getPath() + " (cannot set last modification time)");
        }
    }

    @Override
    public void unlink(FsEntryName name) throws IOException {
        File file = new File(this.target, name.getPath());
        if (!file.delete()) {
            throw new IOException(file.getPath() + " (cannot delete)");
        }
    }

    @Override
    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws X {
    }
}

