/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.archive.zip.ZipArchiveEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.zip.RawZipFile;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

@DefaultAnnotation(value={NonNull.class})
public class ZipInputShop
extends RawZipFile<ZipArchiveEntry>
implements InputShop<ZipArchiveEntry> {
    public ZipInputShop(ZipDriver driver, ReadOnlyFile rof) throws IOException {
        super(rof, driver.getCharset(), driver.getPreambled(), driver.getPostambled(), driver);
    }

    @Override
    public int getSize() {
        return super.size();
    }

    @Override
    public InputSocket<ZipArchiveEntry> getInputSocket(final String name) {
        if (null == name) {
            throw new NullPointerException();
        }
        class Input
        extends InputSocket<ZipArchiveEntry> {
            Input() {
            }

            @Override
            public ZipArchiveEntry getLocalTarget() throws IOException {
                ZipArchiveEntry entry = (ZipArchiveEntry)ZipInputShop.this.getEntry(name);
                if (null == entry) {
                    throw new FileNotFoundException(name + " (entry not found)");
                }
                return entry;
            }

            @Override
            public ReadOnlyFile newReadOnlyFile() throws IOException {
                throw new FileNotFoundException(name + " (unsupported operation)");
            }

            @Override
            public InputStream newInputStream() throws IOException {
                Entry entry = this.getPeerTarget();
                return ZipInputShop.this.getInputStream(this.getLocalTarget().getName(), false, !(entry instanceof ZipArchiveEntry) || ((ZipArchiveEntry)entry).getMethod() != 8);
            }
        }
        return new Input();
    }
}

