/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.entry.EntryContainer;
import de.schlichtherle.truezip.entry.EntryFactory;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsUriModifier;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemEvent;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemException;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemOperation;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemTouchListener;
import de.schlichtherle.truezip.fs.archive.FsReadOnlyArchiveFileSystem;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.Link;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.CharConversionException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
class FsArchiveFileSystem<E extends FsArchiveEntry>
implements EntryContainer<FsArchiveFileSystemEntry<E>> {
    private final EntryFactory<E> factory;
    private final Map<String, FsArchiveFileSystemEntry<E>> master;
    private final FsArchiveFileSystemEntry<E> root;
    private boolean touched;
    private LinkedHashSet<FsArchiveFileSystemTouchListener<? super E>> touchListeners = new LinkedHashSet();

    static <AE extends FsArchiveEntry> FsArchiveFileSystem<AE> newArchiveFileSystem(EntryFactory<AE> factory) {
        return new FsArchiveFileSystem<AE>(factory);
    }

    private FsArchiveFileSystem(EntryFactory<E> factory) {
        this.factory = factory;
        this.master = new LinkedHashMap<String, FsArchiveFileSystemEntry<E>>(64);
        this.root = this.newEntryUnchecked(FsEntryName.ROOT.toString(), Entry.Type.DIRECTORY, null);
        for (Entry.Access access : BitField.allOf(Entry.Access.class)) {
            this.root.getEntry().setTime(access, System.currentTimeMillis());
        }
        this.master.put(FsEntryName.ROOT.toString(), this.root);
        try {
            this.touch();
        }
        catch (FsArchiveFileSystemException ex) {
            throw new AssertionError((Object)"veto without a listener!?");
        }
    }

    static <E extends FsArchiveEntry> FsArchiveFileSystem<E> newArchiveFileSystem(EntryFactory<E> factory, EntryContainer<E> archive, @CheckForNull Entry rootTemplate, boolean readOnly) {
        return readOnly ? new FsReadOnlyArchiveFileSystem<E>(archive, factory, rootTemplate) : new FsArchiveFileSystem<E>(factory, archive, rootTemplate);
    }

    FsArchiveFileSystem(EntryFactory<E> factory, EntryContainer<E> archive, @CheckForNull Entry rootTemplate) {
        String path;
        if (null == rootTemplate) {
            throw new NullPointerException();
        }
        if (rootTemplate instanceof FsArchiveFileSystemEntry) {
            throw new IllegalArgumentException();
        }
        this.factory = factory;
        this.master = new LinkedHashMap<String, FsArchiveFileSystemEntry<E>>((int)((float)archive.getSize() / 0.7f) + 1);
        LinkedList<String> paths = new LinkedList<String>();
        Paths.Normalizer normalizer = new Paths.Normalizer('/');
        for (FsArchiveEntry entry : archive) {
            path = Paths.cutTrailingSeparators(normalizer.normalize(entry.getName().replace('\\', '/')), '/');
            this.master.put(path, FsArchiveFileSystemEntry.create(path, entry.getType(), entry));
            paths.add(path);
        }
        this.root = this.newEntryUnchecked(FsEntryName.ROOT.getPath(), Entry.Type.DIRECTORY, rootTemplate);
        this.master.put(FsEntryName.ROOT.getPath(), this.root);
        Checker fsck = new Checker();
        Iterator i = paths.iterator();
        while (i.hasNext()) {
            path = (String)i.next();
            try {
                fsck.fix(new FsEntryName(new URI(null, null, path, null, null), FsUriModifier.CANONICALIZE).getPath());
            }
            catch (URISyntaxException dontFix) {
                // empty catch block
            }
            i.remove();
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isTouched() {
        return this.touched;
    }

    private void touch() throws FsArchiveFileSystemException {
        if (this.touched) {
            return;
        }
        FsArchiveFileSystemEvent event = new FsArchiveFileSystemEvent(this);
        Set<FsArchiveFileSystemTouchListener<E>> listeners = this.getArchiveFileSystemTouchListeners();
        try {
            for (FsArchiveFileSystemTouchListener fsArchiveFileSystemTouchListener : listeners) {
                fsArchiveFileSystemTouchListener.beforeTouch(event);
            }
        }
        catch (IOException ex) {
            throw new FsArchiveFileSystemException(null, "touch vetoed", ex);
        }
        this.touched = true;
        for (FsArchiveFileSystemTouchListener fsArchiveFileSystemTouchListener : listeners) {
            fsArchiveFileSystemTouchListener.afterTouch(event);
        }
    }

    Set<FsArchiveFileSystemTouchListener<? super E>> getArchiveFileSystemTouchListeners() {
        return (Set)this.touchListeners.clone();
    }

    public final void addArchiveFileSystemTouchListener(FsArchiveFileSystemTouchListener<? super E> listener) {
        if (null == listener) {
            throw new NullPointerException();
        }
        this.touchListeners.add(listener);
    }

    public final void removeArchiveFileSystemTouchListener(@Nullable FsArchiveFileSystemTouchListener<? super E> listener) {
        this.touchListeners.remove(listener);
    }

    @Override
    public int getSize() {
        return this.master.size();
    }

    @Override
    public Iterator<FsArchiveFileSystemEntry<E>> iterator() {
        class ArchiveEntryIterator
        implements Iterator<FsArchiveFileSystemEntry<E>> {
            final Iterator<FsArchiveFileSystemEntry<E>> it;

            ArchiveEntryIterator() {
                this.it = FsArchiveFileSystem.this.master.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public FsArchiveFileSystemEntry<E> next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new ArchiveEntryIterator();
    }

    @Nullable
    public final FsArchiveFileSystemEntry<E> getEntry(FsEntryName name) {
        return this.getEntry(name.getPath());
    }

    @Override
    @Nullable
    public FsArchiveFileSystemEntry<E> getEntry(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        FsArchiveFileSystemEntry<E> entry = this.master.get(path);
        return null == entry ? null : entry.clone(this);
    }

    private FsArchiveFileSystemEntry<E> newEntryUnchecked(String path, Entry.Type type, @CheckForNull Entry template) {
        assert (null != type);
        assert (!Paths.isRoot(path) || Entry.Type.DIRECTORY == type);
        assert (!(template instanceof FsArchiveFileSystemEntry));
        try {
            return FsArchiveFileSystemEntry.create(path, type, (FsArchiveEntry)this.factory.newEntry(path, type, template));
        }
        catch (CharConversionException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private FsArchiveFileSystemEntry<E> newEntryChecked(String path, Entry.Type type, @CheckForNull Entry template) throws FsArchiveFileSystemException {
        assert (null != type);
        assert (!Paths.isRoot(path) || Entry.Type.DIRECTORY == type);
        assert (!(template instanceof FsArchiveFileSystemEntry));
        try {
            return FsArchiveFileSystemEntry.create(path, type, (FsArchiveEntry)this.factory.newEntry(path, type, template));
        }
        catch (CharConversionException ex) {
            throw new FsArchiveFileSystemException(path, ex);
        }
    }

    final E copy(E entry) {
        try {
            return (E)((FsArchiveEntry)this.factory.newEntry(entry.getName(), entry.getType(), (Entry)entry));
        }
        catch (CharConversionException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public FsArchiveFileSystemOperation<E> mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, @CheckForNull Entry template) throws FsArchiveFileSystemException {
        String path = name.getPath();
        if (null == type) {
            throw new NullPointerException();
        }
        if (Entry.Type.FILE != type && Entry.Type.DIRECTORY != type) {
            throw new FsArchiveFileSystemException(path, "only FILE and DIRECTORY entries are currently supported");
        }
        FsArchiveFileSystemEntry<E> oldEntry = this.master.get(path);
        if (null != oldEntry) {
            if (options.get(FsOutputOption.EXCLUSIVE)) {
                throw new FsArchiveFileSystemException(path, "entry exists already");
            }
            Entry.Type oldEntryType = oldEntry.getType();
            if (oldEntryType == Entry.Type.DIRECTORY) {
                throw new FsArchiveFileSystemException(path, "directories cannot get replaced");
            }
            if (oldEntryType != type) {
                throw new FsArchiveFileSystemException(path, "entry exists already as a different type");
            }
        }
        while (template instanceof FsArchiveFileSystemEntry) {
            template = ((FsArchiveFileSystemEntry)template).getEntry();
        }
        return new PathLink(path, type, options.get(FsOutputOption.CREATE_PARENTS), template);
    }

    public void unlink(FsEntryName name) throws FsArchiveFileSystemException {
        String path = name.getPath();
        if (name.isRoot()) {
            throw new FsArchiveFileSystemException(path, "(virtual) root directory cannot get unlinked");
        }
        FsArchiveFileSystemEntry<E> entry = this.master.get(path);
        if (entry == null) {
            throw new FsArchiveFileSystemException(path, "archive entry does not exist");
        }
        assert (entry != this.root);
        if (Entry.Type.DIRECTORY == entry.getType() && 0 < entry.getMembers().size()) {
            throw new FsArchiveFileSystemException(path, "directory is not empty");
        }
        this.touch();
        FsArchiveFileSystemEntry<E> entry2 = this.master.remove(path);
        assert (entry == entry2);
        Splitter splitter = new Splitter();
        splitter.split(path);
        String parentPath = splitter.getParentPath();
        FsArchiveFileSystemEntry<E> parent = this.master.get(parentPath);
        assert (parent != null) : "The parent directory of \"" + path + "\" is missing - archive file system is corrupted!";
        boolean ok = parent.remove(splitter.getMemberName());
        assert (ok) : "The parent directory of \"" + path + "\" does not contain this entry - archive file system is corrupted!";
        E ae = parent.getEntry();
        if (ae.getTime(Entry.Access.WRITE) != -1L) {
            ae.setTime(Entry.Access.WRITE, System.currentTimeMillis());
        }
    }

    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value) throws FsArchiveFileSystemException {
        String path = name.getPath();
        if (0L > value) {
            throw new IllegalArgumentException(path + " (negative access time)");
        }
        FsArchiveFileSystemEntry<E> entry = this.master.get(path);
        if (entry == null) {
            throw new FsArchiveFileSystemException(path, "archive entry not found");
        }
        this.touch();
        boolean ok = true;
        for (Entry.Access type : types) {
            ok &= entry.getEntry().setTime(type, value);
        }
        return ok;
    }

    public boolean isWritable(FsEntryName name) {
        return !this.isReadOnly();
    }

    public void setReadOnly(FsEntryName name) throws FsArchiveFileSystemException {
        if (!this.isReadOnly()) {
            throw new FsArchiveFileSystemException(name.getPath(), "cannot set read-only state");
        }
    }

    private static final class SegmentLink<E extends FsArchiveEntry>
    implements Link<FsArchiveFileSystemEntry<E>> {
        final FsArchiveFileSystemEntry<E> entry;
        @CheckForNull
        final String base;

        SegmentLink(FsArchiveFileSystemEntry<E> entry, @CheckForNull String base) {
            this.entry = entry;
            this.base = base;
        }

        @Override
        public FsArchiveFileSystemEntry<E> getTarget() {
            return this.entry;
        }
    }

    private final class PathLink
    implements FsArchiveFileSystemOperation<E> {
        final Splitter splitter = new Splitter();
        final boolean createParents;
        final SegmentLink<E>[] links;
        long time = -1L;

        PathLink(String entryPath, Entry.Type entryType, @CheckForNull boolean createParents, Entry template) throws FsArchiveFileSystemException {
            this.createParents = createParents;
            this.links = this.newSegmentLinks(entryPath, entryType, template, 1);
        }

        private SegmentLink<E>[] newSegmentLinks(String entryPath, Entry.Type entryType, @CheckForNull Entry template, int level) throws FsArchiveFileSystemException {
            SegmentLink[] elements;
            this.splitter.split(entryPath);
            String parentPath = this.splitter.getParentPath();
            String memberName = this.splitter.getMemberName();
            FsArchiveFileSystemEntry parentEntry = (FsArchiveFileSystemEntry)FsArchiveFileSystem.this.master.get(parentPath);
            if (parentEntry != null) {
                if (Entry.Type.DIRECTORY != parentEntry.getType()) {
                    throw new FsArchiveFileSystemException(entryPath, "parent entry must be a directory");
                }
                elements = new SegmentLink[level + 1];
                elements[0] = new SegmentLink(parentEntry, null);
                FsArchiveFileSystemEntry newEntry = FsArchiveFileSystem.this.newEntryChecked(entryPath, entryType, template);
                elements[1] = new SegmentLink(newEntry, memberName);
            } else if (this.createParents) {
                elements = this.newSegmentLinks(parentPath, Entry.Type.DIRECTORY, null, level + 1);
                FsArchiveFileSystemEntry newEntry = FsArchiveFileSystem.this.newEntryChecked(entryPath, entryType, template);
                elements[elements.length - level] = new SegmentLink(newEntry, memberName);
            } else {
                throw new FsArchiveFileSystemException(entryPath, "missing parent directory entry");
            }
            return elements;
        }

        @Override
        public void run() throws FsArchiveFileSystemException {
            assert (2 <= this.links.length);
            FsArchiveFileSystem.this.touch();
            int l = this.links.length;
            FsArchiveFileSystemEntry parent = this.links[0].entry;
            for (int i = 1; i < l; ++i) {
                SegmentLink link = this.links[i];
                FsArchiveFileSystemEntry entry = link.entry;
                String base = link.base;
                assert (Entry.Type.DIRECTORY == parent.getType());
                FsArchiveFileSystem.this.master.put(entry.getName(), entry);
                if (parent.add(base) && -1L != parent.getTime(Entry.Access.WRITE)) {
                    parent.getEntry().setTime(Entry.Access.WRITE, this.getCurrentTimeMillis());
                }
                parent = entry;
            }
            Object entry = ((FsArchiveFileSystemEntry)this.getTarget()).getEntry();
            if (-1L == entry.getTime(Entry.Access.WRITE)) {
                entry.setTime(Entry.Access.WRITE, this.getCurrentTimeMillis());
            }
        }

        private long getCurrentTimeMillis() {
            return 0L <= this.time ? this.time : (this.time = System.currentTimeMillis());
        }

        @Override
        public FsArchiveFileSystemEntry<E> getTarget() {
            return this.links[this.links.length - 1].getTarget();
        }
    }

    private class Checker
    extends Splitter {
        private Checker() {
        }

        void fix(String path) {
            if (Paths.isRoot(path)) {
                return;
            }
            this.split(path);
            String parentPath = this.getParentPath();
            String memberName = this.getMemberName();
            FsArchiveFileSystemEntry parent = (FsArchiveFileSystemEntry)FsArchiveFileSystem.this.master.get(parentPath);
            if (null == parent) {
                parent = FsArchiveFileSystem.this.newEntryUnchecked(parentPath, Entry.Type.DIRECTORY, null);
                FsArchiveFileSystem.this.master.put(parentPath, parent);
            }
            parent.add(memberName);
            this.fix(parentPath);
        }
    }

    private static class Splitter
    extends Paths.Splitter {
        Splitter() {
            super('/');
        }

        @Override
        @NonNull
        public String getParentPath() {
            String parentPath = super.getParentPath();
            return null != parentPath ? parentPath : FsEntryName.ROOT.toString();
        }
    }
}

