/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingManager;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsStatistics;
import de.schlichtherle.truezip.fs.FsStatisticsController;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class FsStatisticsManager
extends FsDecoratingManager<FsManager> {
    private volatile FsStatistics statistics = new FsStatistics(this);

    public FsStatisticsManager(@NonNull FsManager manager) {
        super(manager);
    }

    @Override
    public FsController<?> getController(FsMountPoint mountPoint, final FsCompositeDriver driver) {
        class StatisticsDriver
        implements FsCompositeDriver {
            StatisticsDriver() {
            }

            @Override
            public FsController<?> newController(FsMountPoint mountPoint, FsController<?> parent) {
                assert (null != mountPoint.getParent() ? mountPoint.getParent().equals(((FsModel)parent.getModel()).getMountPoint()) : null == parent);
                FsStatisticsController controller = driver.newController(mountPoint, parent);
                return null != parent && null == parent.getParent() ? new FsStatisticsController(controller, FsStatisticsManager.this) : controller;
            }
        }
        return this.delegate.getController(mountPoint, new StatisticsDriver());
    }

    @NonNull
    public FsStatistics getStatistics() {
        return this.statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super IOException, X> handler) throws X {
        try {
            this.delegate.sync(options, handler);
        }
        finally {
            this.statistics = new FsStatistics(this);
        }
    }
}

