/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsUriModifier;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;

@Immutable
@SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class FsPath
implements Serializable,
Comparable<FsPath> {
    private static final long serialVersionUID = 5798435461242930648L;
    public static final String MOUNT_POINT_SEPARATOR = "!/";
    @NonNull
    private URI uri;
    @Nullable
    private transient FsMountPoint mountPoint;
    @NonNull
    private transient FsEntryName entryName;
    @Nullable
    private volatile transient FsPath hierarchical;

    @NonNull
    public static FsPath create(@NonNull String uri) {
        return FsPath.create(uri, FsUriModifier.NULL);
    }

    @NonNull
    public static FsPath create(@NonNull String uri, @NonNull FsUriModifier modifier) {
        try {
            return new FsPath(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @NonNull
    public static FsPath create(@NonNull URI uri) {
        return FsPath.create(uri, FsUriModifier.NULL);
    }

    @NonNull
    public static FsPath create(@NonNull URI uri, @NonNull FsUriModifier modifier) {
        try {
            return new FsPath(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public FsPath(@NonNull String uri) throws URISyntaxException {
        this.parse(new URI(uri), FsUriModifier.NULL);
    }

    public FsPath(@NonNull String uri, @NonNull FsUriModifier modifier) throws URISyntaxException {
        this.parse(new URI(uri), modifier);
    }

    public FsPath(@NonNull File file) {
        try {
            this.parse(file.toURI(), FsUriModifier.CANONICALIZE);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public FsPath(@NonNull URI uri) throws URISyntaxException {
        this.parse(uri, FsUriModifier.NULL);
    }

    public FsPath(@NonNull URI uri, @NonNull FsUriModifier modifier) throws URISyntaxException {
        this.parse(uri, modifier);
    }

    public FsPath(@CheckForNull FsMountPoint mountPoint, @NonNull FsEntryName entryName) {
        if (null == mountPoint) {
            this.uri = entryName.getUri();
        } else if (mountPoint.getUri().isOpaque()) {
            try {
                this.uri = new URI(mountPoint.toString() + entryName);
            }
            catch (URISyntaxException ex) {
                throw new AssertionError((Object)ex);
            }
        } else {
            this.uri = mountPoint.getUri().resolve(entryName.getUri());
        }
        this.mountPoint = mountPoint;
        this.entryName = entryName;
        assert (this.invariants());
    }

    private void writeObject(@NonNull ObjectOutputStream out) throws IOException {
        out.writeObject(this.uri.toString());
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.parse(new URI(in.readObject().toString()), FsUriModifier.NULL);
        }
        catch (URISyntaxException ex) {
            throw (InvalidObjectException)new InvalidObjectException(ex.toString()).initCause(ex);
        }
    }

    private void parse(@NonNull URI uri, @NonNull FsUriModifier modifier) throws URISyntaxException {
        if (null != uri.getRawFragment()) {
            throw new URISyntaxException(FsPath.quote(uri), "Fragment not allowed");
        }
        if (uri.isOpaque()) {
            URI nuri;
            String ssp = uri.getSchemeSpecificPart();
            int i = ssp.lastIndexOf(MOUNT_POINT_SEPARATOR);
            if (0 > i) {
                throw new URISyntaxException(FsPath.quote(uri), "Missing mount point separator \"!/\"");
            }
            this.mountPoint = new FsMountPoint(new URI(uri.getScheme(), ssp.substring(0, i + 2), null), modifier);
            this.entryName = new FsEntryName(new URI(null, ssp.substring(i + 2), uri.getFragment()), modifier);
            if (FsUriModifier.NULL != modifier && !uri.equals(nuri = new URI(this.mountPoint.toString() + this.entryName))) {
                uri = nuri;
            }
        } else if (uri.isAbsolute()) {
            uri = modifier.modify(uri, FsUriModifier.PostFix.PATH);
            this.mountPoint = new FsMountPoint(uri.resolve("."), FsUriModifier.NULL);
            this.entryName = new FsEntryName(this.mountPoint.getUri().relativize(uri), FsUriModifier.NULL);
        } else {
            this.mountPoint = null;
            this.entryName = new FsEntryName(uri, modifier);
            uri = this.entryName.getUri();
        }
        this.uri = uri;
        assert (this.invariants());
    }

    private static String quote(Object s) {
        return "\"" + s + "\"";
    }

    private boolean invariants() {
        assert (null != this.getUri());
        assert (null == this.getUri().getRawFragment());
        assert (null != this.getMountPoint() == this.getUri().isAbsolute());
        assert (null != this.getEntryName());
        if (this.getUri().isOpaque()) {
            assert (this.getUri().getRawSchemeSpecificPart().contains(MOUNT_POINT_SEPARATOR));
            assert (this.getUri().equals(URI.create(this.getMountPoint().getUri().toString() + this.getEntryName().getUri().toString())));
        } else if (this.getUri().isAbsolute()) {
            assert (this.getUri().normalize() == this.getUri());
            assert (this.getUri().equals(this.getMountPoint().getUri().resolve(this.getEntryName().getUri())));
        } else {
            assert (this.getUri().normalize() == this.getUri());
            assert (this.getEntryName().getUri() == this.getUri());
        }
        return true;
    }

    @Nullable
    public FsMountPoint getMountPoint() {
        return this.mountPoint;
    }

    @NonNull
    public FsEntryName getEntryName() {
        return this.entryName;
    }

    @NonNull
    public URI getUri() {
        return this.uri;
    }

    @NonNull
    public FsPath resolve(@NonNull FsEntryName entryName) {
        return new FsPath(this.mountPoint, new FsEntryName(this.entryName, entryName));
    }

    @NonNull
    public FsPath hierarchicalize() {
        return null != this.hierarchical ? this.hierarchical : (this.hierarchical = !this.uri.isOpaque() ? this : (0 == this.entryName.toString().length() ? FsPath.create(this.mountPoint.hierarchicalize().getUri()) : this.mountPoint.hierarchicalize().resolve(this.entryName)));
    }

    public boolean equals(@CheckForNull Object that) {
        return this == that || that instanceof FsPath && this.uri.equals(((FsPath)that).uri);
    }

    @Override
    public int compareTo(@NonNull FsPath that) {
        return this.uri.compareTo(that.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    @NonNull
    public String toString() {
        return this.uri.toString();
    }
}

