/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingManager;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class FsFilteringManager
extends FsDecoratingManager<FsManager> {
    private final FsMountPoint prefix;

    public FsFilteringManager(@NonNull FsManager manager, @NonNull FsMountPoint prefix) {
        super(manager);
        this.prefix = prefix.hierarchicalize();
    }

    @Override
    public int getSize() {
        return this.getControllers().size();
    }

    @Override
    public Iterator<FsController<?>> iterator() {
        return this.getControllers().iterator();
    }

    private Collection<FsController<?>> getControllers() {
        ArrayList snapshot = new ArrayList((int)((float)this.delegate.getSize() / 0.75f) + 1);
        for (FsController<?> controller : this.delegate) {
            FsMountPoint mountPoint = ((FsModel)controller.getModel()).getMountPoint().hierarchicalize();
            if (!mountPoint.getScheme().equals(this.prefix.getScheme()) || !mountPoint.getUri().getPath().startsWith(this.prefix.getUri().getPath())) continue;
            snapshot.add(controller);
        }
        return snapshot;
    }
}

