/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TIO;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@DefaultAnnotation(value={NonNull.class})
@Immutable
public final class TFileOutputStream
extends DecoratingOutputStream {
    private static final BitField<FsOutputOption> DEFAULT_OPTIONS = BitField.noneOf(FsOutputOption.class);

    public TFileOutputStream(String path) throws FileNotFoundException {
        super(TFileOutputStream.newOutputStream(new TFile(path), false));
    }

    public TFileOutputStream(String path, boolean append) throws FileNotFoundException {
        super(TFileOutputStream.newOutputStream(new TFile(path), append));
    }

    public TFileOutputStream(File file) throws FileNotFoundException {
        super(TFileOutputStream.newOutputStream(file, false));
    }

    public TFileOutputStream(File file, boolean append) throws FileNotFoundException {
        super(TFileOutputStream.newOutputStream(file, append));
    }

    private static OutputStream newOutputStream(File dst, boolean append) throws FileNotFoundException {
        OutputSocket<?> output = TIO.getOutputSocket(dst, DEFAULT_OPTIONS.set(FsOutputOption.APPEND, append).set(FsOutputOption.CREATE_PARENTS, TFile.isLenient()), null);
        try {
            return output.newOutputStream();
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw (FileNotFoundException)new FileNotFoundException(ex.toString()).initCause(ex);
        }
    }
}

