/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.rtf;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Vector;

class WMFWriter {
    private static Record trailer = new Record(0, null);
    private short fileType = (short)2;
    private short headerSize = (short)9;
    private short version = (short)768;
    private int fileSize = this.headerSize + trailer.size();
    private short numOfObjects = 0;
    private int maxRecordSize = trailer.size();
    private short numOfParams = 0;
    private Vector<Record> records = new Vector();

    WMFWriter() {
    }

    void add(Record record) {
        this.records.addElement(record);
        int size = record.size();
        this.fileSize += size;
        if (size > this.maxRecordSize) {
            this.maxRecordSize = size;
        }
    }

    int size() {
        return this.fileSize;
    }

    void write(String fileName) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileName));
        this.write(out);
        out.flush();
        out.close();
    }

    void write(OutputStream out) throws IOException {
        WMFWriter.write16(this.fileType, out);
        WMFWriter.write16(this.headerSize, out);
        WMFWriter.write16(this.version, out);
        WMFWriter.write32(this.fileSize, out);
        WMFWriter.write16(this.numOfObjects, out);
        WMFWriter.write32(this.maxRecordSize, out);
        WMFWriter.write16(this.numOfParams, out);
        int n = this.records.size();
        for (int i = 0; i < n; ++i) {
            Record record = this.records.elementAt(i);
            record.write(out);
        }
        trailer.write(out);
    }

    static void write16(int word, OutputStream out) throws IOException {
        out.write(word);
        out.write(word >> 8);
    }

    static void write32(int dword, OutputStream out) throws IOException {
        out.write(dword);
        out.write(dword >> 8);
        out.write(dword >> 16);
        out.write(dword >> 24);
    }

    void print(Writer out) throws IOException {
        WMFWriter.print16(this.fileType, out);
        WMFWriter.print16(this.headerSize, out);
        WMFWriter.print16(this.version, out);
        WMFWriter.print32(this.fileSize, out);
        WMFWriter.print16(this.numOfObjects, out);
        WMFWriter.print32(this.maxRecordSize, out);
        WMFWriter.print16(this.numOfParams, out);
        out.write(System.getProperty("line.separator"));
        int n = this.records.size();
        for (int i = 0; i < n; ++i) {
            Record record = this.records.elementAt(i);
            record.print(out);
        }
        trailer.print(out);
    }

    static void print16(int word, Writer out) throws IOException {
        byte[] buf = new byte[]{(byte)word, (byte)(word >> 8)};
        WMFWriter.print(buf, 0, 2, out);
    }

    static void print32(int dword, Writer out) throws IOException {
        byte[] buf = new byte[]{(byte)dword, (byte)(dword >> 8), (byte)(dword >> 16), (byte)(dword >> 24)};
        WMFWriter.print(buf, 0, 4, out);
    }

    static void print(byte[] buf, int off, int len, Writer out) throws IOException {
        char[] cbuf = new char[2 * len];
        int j = 0;
        int n = off + len;
        for (int i = off; i < n; ++i) {
            int d = buf[i] >> 4 & 0xF;
            cbuf[j++] = d < 10 ? (char)(48 + d) : (char)(97 + (d - 10));
            d = buf[i] & 0xF;
            cbuf[j++] = d < 10 ? (char)(48 + d) : (char)(97 + (d - 10));
        }
        out.write(cbuf);
    }

    static void print(byte[] buf, int off, int len, Writer out, int lw) throws IOException {
        String ls = System.getProperty("line.separator");
        int i = off;
        while (len > 0) {
            int n = Math.min(len, lw / 2);
            WMFWriter.print(buf, i, n, out);
            out.write(ls);
            len -= n;
            i += n;
        }
    }

    static class DibBitBltRecord
    extends Record {
        static final int P_COUNT = 8;
        static final int P_ROP_L = 0;
        static final int P_ROP_H = 1;
        static final int P_YSRC = 2;
        static final int P_XSRC = 3;
        static final int P_HEIGHT = 4;
        static final int P_WIDTH = 5;
        static final int P_YDST = 6;
        static final int P_XDST = 7;
        private Dib dib;

        DibBitBltRecord(int[] parameters, Dib dib) {
            super(2368, parameters);
            this.size += dib.size();
            this.dib = dib;
        }

        @Override
        void write(OutputStream out) throws IOException {
            super.write(out);
            this.dib.write(out);
        }

        @Override
        void print(Writer out) throws IOException {
            super.print(out);
            this.dib.print(out);
        }
    }

    static class Dib {
        static final int BI_RGB = 0;
        static final int BI_RLE8 = 1;
        static final int BI_RLE4 = 2;
        static final int BI_BITFIELDS = 3;
        final int biSize = 40;
        int biWidth;
        int biHeight;
        final short biPlanes = 1;
        short biBitCount;
        int biCompression;
        int biSizeImage;
        int biXPelsPerMeter;
        int biYPelsPerMeter;
        int biClrUsed;
        int biClrImportant;
        byte[] palette;
        byte[] bitmap;

        Dib() {
        }

        int size() {
            int size = 40;
            if (this.palette != null) {
                size += this.palette.length;
            }
            if (this.bitmap != null) {
                size = this.biSizeImage != 0 ? (size += this.biSizeImage) : (size += this.bitmap.length);
            }
            return size / 2;
        }

        void write(OutputStream out) throws IOException {
            WMFWriter.write32(40, out);
            WMFWriter.write32(this.biWidth, out);
            WMFWriter.write32(this.biHeight, out);
            WMFWriter.write16(1, out);
            WMFWriter.write16(this.biBitCount, out);
            WMFWriter.write32(this.biCompression, out);
            WMFWriter.write32(this.biSizeImage, out);
            WMFWriter.write32(this.biXPelsPerMeter, out);
            WMFWriter.write32(this.biYPelsPerMeter, out);
            WMFWriter.write32(this.biClrUsed, out);
            WMFWriter.write32(this.biClrImportant, out);
            if (this.palette != null) {
                out.write(this.palette);
            }
            if (this.bitmap != null) {
                if (this.biSizeImage != 0) {
                    out.write(this.bitmap, 0, this.biSizeImage);
                } else {
                    out.write(this.bitmap);
                }
            }
        }

        void print(Writer out) throws IOException {
            String ls = System.getProperty("line.separator");
            WMFWriter.print32(40, out);
            WMFWriter.print32(this.biWidth, out);
            WMFWriter.print32(this.biHeight, out);
            WMFWriter.print16(1, out);
            WMFWriter.print16(this.biBitCount, out);
            out.write(ls);
            WMFWriter.print32(this.biCompression, out);
            WMFWriter.print32(this.biSizeImage, out);
            WMFWriter.print32(this.biXPelsPerMeter, out);
            WMFWriter.print32(this.biYPelsPerMeter, out);
            WMFWriter.print32(this.biClrUsed, out);
            WMFWriter.print32(this.biClrImportant, out);
            out.write(ls);
            if (this.palette != null) {
                WMFWriter.print(this.palette, 0, this.palette.length, out, 64);
            }
            if (this.bitmap != null) {
                int len = this.biSizeImage != 0 ? this.biSizeImage : this.bitmap.length;
                WMFWriter.print(this.bitmap, 0, len, out, 76);
            }
        }

        static int rlEncode8(byte[] inBuf, int inOff, int inLen, byte[] outBuf, int outOff) {
            int i1 = inOff;
            int j = outOff;
            int n = inOff + inLen;
            while (i1 < n) {
                int k;
                int i2 = i1 + 1;
                int len = 1;
                while (i2 < n && inBuf[i2] == inBuf[i2 - 1]) {
                    ++i2;
                    ++len;
                }
                if (len > 1) {
                    while (len > 255) {
                        outBuf[j++] = -1;
                        outBuf[j++] = inBuf[i1];
                        len -= 255;
                    }
                    if (len > 0) {
                        outBuf[j++] = (byte)len;
                        outBuf[j++] = inBuf[i1];
                    }
                    i1 = i2;
                    continue;
                }
                ++i2;
                while (i2 < n && inBuf[i2] != inBuf[i2 - 1]) {
                    ++i2;
                    ++len;
                }
                while (len > 255) {
                    outBuf[j++] = 0;
                    outBuf[j++] = -1;
                    for (k = 0; k < 255; ++k) {
                        outBuf[j++] = inBuf[i1++];
                    }
                    outBuf[j++] = 0;
                    len -= 255;
                }
                if (len > 2) {
                    outBuf[j++] = 0;
                    outBuf[j++] = (byte)len;
                    for (k = 0; k < len; ++k) {
                        outBuf[j++] = inBuf[i1++];
                    }
                    if (len % 2 == 0) continue;
                    outBuf[j++] = 0;
                    continue;
                }
                while (len > 0) {
                    outBuf[j++] = 1;
                    outBuf[j++] = inBuf[i1++];
                    --len;
                }
            }
            return j - outOff;
        }
    }

    static class Record {
        protected int size;
        private short function;
        private short[] parameters;

        Record(int function, int[] parameters) {
            this.function = (short)function;
            if (parameters != null) {
                this.parameters = new short[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    this.parameters[i] = (short)parameters[i];
                }
            }
            this.size = 3 + (parameters == null ? 0 : parameters.length);
        }

        int size() {
            return this.size;
        }

        void write(OutputStream out) throws IOException {
            WMFWriter.write32(this.size, out);
            WMFWriter.write16(this.function, out);
            if (this.parameters != null) {
                for (short parameter : this.parameters) {
                    WMFWriter.write16(parameter, out);
                }
            }
        }

        void print(Writer out) throws IOException {
            WMFWriter.print32(this.size, out);
            WMFWriter.print16(this.function, out);
            if (this.parameters != null) {
                for (short parameter : this.parameters) {
                    WMFWriter.print16(parameter, out);
                }
            }
        }
    }
}

