/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.markdown;

import com.vladsch.flexmark.ext.wikilink.internal.WikiLinkLinkResolver;
import com.vladsch.flexmark.html.IndependentLinkResolverFactory;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FlexmarkDoxiaLinkResolver
implements LinkResolver {
    final Pattern pattern = Pattern.compile("^(?![^:]+:)((?:\\./)?(?:\\.\\./)*[^\\.]+).(?:md|markdown)(#[^#\\.]*){0,1}$");

    public FlexmarkDoxiaLinkResolver(LinkResolverContext context) {
    }

    public ResolvedLink resolveLink(Node node, LinkResolverContext context, ResolvedLink link) {
        Matcher matcher;
        if (link.getLinkType() == LinkType.LINK && (matcher = this.pattern.matcher(link.getUrl())).matches()) {
            return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)matcher.replaceAll("$1.html$2"));
        }
        return link;
    }

    public static class Factory
    extends IndependentLinkResolverFactory {
        public Set<Class<? extends LinkResolverFactory>> getBeforeDependents() {
            HashSet<Class<? extends LinkResolverFactory>> set = new HashSet<Class<? extends LinkResolverFactory>>();
            set.add(WikiLinkLinkResolver.Factory.class);
            return set;
        }

        public LinkResolver apply(LinkResolverContext context) {
            return new FlexmarkDoxiaLinkResolver(context);
        }
    }
}

