/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.markdown;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.maven.doxia.module.markdown.MarkdownToDoxiaHtmlSerializer;
import org.apache.maven.doxia.module.xhtml.XhtmlParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.util.IOUtil;
import org.pegdown.PegDownProcessor;
import org.pegdown.ast.RootNode;

public class MarkdownParser
extends XhtmlParser {
    public static final String ROLE_HINT = "markdown";
    protected static final PegDownProcessor PEGDOWN_PROCESSOR = new PegDownProcessor(65527);

    public void parse(Reader source, Sink sink) throws ParseException {
        try {
            RootNode rootNode = PEGDOWN_PROCESSOR.parseMarkdown(IOUtil.toString((Reader)source).toCharArray());
            String markdownAsHtml = new MarkdownToDoxiaHtmlSerializer().toHtml(rootNode);
            super.parse((Reader)new StringReader("<html><body>" + markdownAsHtml + "</body></html>"), sink);
        }
        catch (IOException e) {
            throw new ParseException("Failed reading Markdown source document", (Exception)e);
        }
    }
}

