/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.markdown;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.maven.doxia.module.markdown.MarkdownMarkup;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.AbstractTextSink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.codehaus.plexus.util.StringUtils;

public class MarkdownSink
extends AbstractTextSink
implements MarkdownMarkup {
    private StringBuffer buffer;
    private StringBuilder tableCaptionBuffer;
    private String author;
    private String title;
    private String date;
    private String linkName;
    private boolean startFlag;
    private boolean tableCaptionFlag;
    private boolean tableCellFlag;
    private boolean headerFlag;
    private boolean bufferFlag;
    private boolean itemFlag;
    private boolean verbatimFlag;
    private boolean gridFlag;
    private int cellCount;
    private final PrintWriter writer;
    private int[] cellJustif;
    private String rowLine;
    private boolean headerRow;
    private String listNestingIndent;
    private final Stack<String> listStyles;
    protected Stack<List<String>> inlineStack = new Stack();

    protected MarkdownSink(Writer writer) {
        this.writer = new PrintWriter(writer);
        this.listStyles = new Stack();
        this.init();
    }

    protected StringBuffer getBuffer() {
        return this.buffer;
    }

    protected void setHeadFlag(boolean headFlag) {
        this.headerFlag = headFlag;
    }

    protected void init() {
        super.init();
        this.resetBuffer();
        this.tableCaptionBuffer = new StringBuilder();
        this.listNestingIndent = "";
        this.author = null;
        this.title = null;
        this.date = null;
        this.linkName = null;
        this.startFlag = true;
        this.tableCaptionFlag = false;
        this.tableCellFlag = false;
        this.headerFlag = false;
        this.bufferFlag = false;
        this.itemFlag = false;
        this.verbatimFlag = false;
        this.gridFlag = false;
        this.cellCount = 0;
        this.cellJustif = null;
        this.rowLine = null;
        this.listStyles.clear();
        this.inlineStack.clear();
    }

    protected void resetBuffer() {
        this.buffer = new StringBuffer();
    }

    protected void resetTableCaptionBuffer() {
        this.tableCaptionBuffer = new StringBuilder();
    }

    public void head() {
        boolean startFlag = this.startFlag;
        this.init();
        this.headerFlag = true;
        this.startFlag = startFlag;
    }

    public void head_() {
        this.headerFlag = false;
        if (!this.startFlag) {
            this.write(EOL);
        }
        if (this.title != null) {
            this.write("title: " + this.title + EOL);
        }
        if (this.author != null) {
            this.write("author: " + this.author + EOL);
        }
        if (this.date != null) {
            this.write("date: " + this.date + EOL);
        }
    }

    public void title_() {
        if (this.buffer.length() > 0) {
            this.title = this.buffer.toString();
            this.resetBuffer();
        }
    }

    public void author_() {
        if (this.buffer.length() > 0) {
            this.author = this.buffer.toString();
            this.resetBuffer();
        }
    }

    public void date_() {
        if (this.buffer.length() > 0) {
            this.date = this.buffer.toString();
            this.resetBuffer();
        }
    }

    public void section1_() {
        this.write(EOL);
    }

    public void section2_() {
        this.write(EOL);
    }

    public void section3_() {
        this.write(EOL);
    }

    public void section4_() {
        this.write(EOL);
    }

    public void section5_() {
        this.write(EOL);
    }

    private void sectionTitle(int level) {
        this.write(EOL + StringUtils.repeat((String)"#", (int)(level + 1)) + ' ');
    }

    public void sectionTitle1() {
        this.sectionTitle(1);
    }

    public void sectionTitle1_() {
        this.write(EOL + EOL);
    }

    public void sectionTitle2() {
        this.sectionTitle(2);
    }

    public void sectionTitle2_() {
        this.write(EOL + EOL);
    }

    public void sectionTitle3() {
        this.sectionTitle(3);
    }

    public void sectionTitle3_() {
        this.write(EOL + EOL);
    }

    public void sectionTitle4() {
        this.sectionTitle(4);
    }

    public void sectionTitle4_() {
        this.write(EOL + EOL);
    }

    public void sectionTitle5() {
        this.sectionTitle(5);
    }

    public void sectionTitle5_() {
        this.write(EOL + EOL);
    }

    public void list() {
        this.listNestingIndent = this.listNestingIndent + " ";
        this.listStyles.push("-");
        this.write(EOL);
    }

    public void list_() {
        this.write(EOL);
        this.listNestingIndent = StringUtils.chomp((String)this.listNestingIndent, (String)" ");
        this.listStyles.pop();
        this.itemFlag = false;
    }

    public void listItem() {
        this.numberedListItem();
        this.itemFlag = true;
    }

    public void listItem_() {
        this.write(EOL);
        this.itemFlag = false;
    }

    public void numberedList(int numbering) {
        String style;
        this.listNestingIndent = this.listNestingIndent + " ";
        this.write(EOL);
        switch (numbering) {
            case 2: {
                style = String.valueOf('A');
                break;
            }
            case 1: {
                style = String.valueOf('a');
                break;
            }
            case 4: {
                style = String.valueOf('I');
                break;
            }
            case 3: {
                style = String.valueOf('i');
                break;
            }
            default: {
                style = String.valueOf('1');
            }
        }
        this.listStyles.push(style);
    }

    public void numberedList_() {
        this.write(EOL);
        this.listNestingIndent = StringUtils.chomp((String)this.listNestingIndent, (String)" ");
        this.listStyles.pop();
        this.itemFlag = false;
    }

    public void numberedListItem() {
        String style = this.listStyles.peek();
        this.write(EOL + this.listNestingIndent + style + ' ');
        this.itemFlag = true;
    }

    public void numberedListItem_() {
        this.write(EOL);
        this.itemFlag = false;
    }

    public void definitionList() {
        this.listNestingIndent = this.listNestingIndent + " ";
        this.listStyles.push("");
        this.write(EOL);
    }

    public void definitionList_() {
        this.write(EOL);
        this.listNestingIndent = StringUtils.chomp((String)this.listNestingIndent, (String)" ");
        this.listStyles.pop();
        this.itemFlag = false;
    }

    public void definedTerm() {
        this.write(EOL + " [");
    }

    public void definedTerm_() {
        this.write("] ");
    }

    public void definition() {
        this.itemFlag = true;
    }

    public void definition_() {
        this.write(EOL);
        this.itemFlag = false;
    }

    public void pageBreak() {
        this.write(EOL + '\f' + EOL);
    }

    public void paragraph() {
        if (!this.tableCellFlag) {
            if (this.itemFlag) {
                this.write(EOL + EOL + "  " + this.listNestingIndent);
            } else {
                this.write(EOL + " ");
            }
        }
    }

    public void paragraph_() {
        if (!this.tableCellFlag) {
            this.write(EOL + EOL);
        }
    }

    public void verbatim(SinkEventAttributes attributes) {
        this.write(EOL);
        this.verbatimFlag = true;
        this.write(EOL + "```" + EOL);
    }

    public void verbatim_() {
        this.write(EOL + "```" + EOL);
        this.verbatimFlag = false;
    }

    public void horizontalRule() {
        this.write(EOL + HORIZONTAL_RULE_MARKUP + EOL);
    }

    public void table() {
        this.write(EOL);
    }

    public void table_() {
        if (this.tableCaptionBuffer.length() > 0) {
            this.text(this.tableCaptionBuffer.toString() + EOL);
        }
        this.resetTableCaptionBuffer();
    }

    public void tableRows(int[] justification, boolean grid) {
        this.cellJustif = null;
        this.gridFlag = grid;
        this.headerRow = true;
    }

    public void tableRows_() {
        this.cellJustif = null;
        this.gridFlag = false;
    }

    public void tableRow() {
        this.bufferFlag = true;
        this.cellCount = 0;
    }

    public void tableRow_() {
        this.bufferFlag = false;
        this.buildRowLine();
        this.write(TABLE_ROW_SEPARATOR_MARKUP);
        this.write(this.buffer.toString());
        this.resetBuffer();
        this.write(EOL);
        if (this.headerRow) {
            this.write(this.rowLine);
            this.headerRow = false;
        }
        this.cellCount = 0;
    }

    private void buildRowLine() {
        StringBuilder rLine = new StringBuilder(TABLE_ROW_SEPARATOR_MARKUP);
        for (int i = 0; i < this.cellCount; ++i) {
            if (this.cellJustif != null) {
                switch (this.cellJustif[i]) {
                    case 1: {
                        rLine.append(TABLE_COL_LEFT_ALIGNED_MARKUP);
                        break;
                    }
                    case 2: {
                        rLine.append(TABLE_COL_RIGHT_ALIGNED_MARKUP);
                        break;
                    }
                    default: {
                        rLine.append(TABLE_COL_DEFAULT_ALIGNED_MARKUP);
                        break;
                    }
                }
                continue;
            }
            rLine.append(TABLE_COL_DEFAULT_ALIGNED_MARKUP);
        }
        rLine.append(EOL);
        this.rowLine = rLine.toString();
    }

    public void tableCell() {
        this.tableCell(false);
    }

    public void tableHeaderCell() {
        this.tableCell(true);
    }

    public void tableCell(boolean headerRow) {
        this.tableCellFlag = true;
    }

    public void tableCell_() {
        this.endTableCell();
    }

    public void tableHeaderCell_() {
        this.endTableCell();
    }

    private void endTableCell() {
        this.tableCellFlag = false;
        this.buffer.append(TABLE_CELL_SEPARATOR_MARKUP);
        ++this.cellCount;
    }

    public void tableCaption() {
        this.tableCaptionFlag = true;
    }

    public void tableCaption_() {
        this.tableCaptionFlag = false;
    }

    public void figureCaption_() {
        this.write(EOL);
    }

    public void figureGraphics(String name) {
        this.write("<img src=\"" + name + "\" />");
    }

    public void anchor(String name) {
    }

    public void anchor_() {
    }

    public void link(String name) {
        if (!this.headerFlag) {
            this.write("[");
            this.linkName = name;
        }
    }

    public void link_() {
        if (!this.headerFlag) {
            this.write("](");
            this.text(this.linkName.startsWith("#") ? this.linkName.substring(1) : this.linkName);
            this.write(")");
            this.linkName = null;
        }
    }

    public void link(String name, String target) {
        if (!this.headerFlag) {
            this.write("[");
        }
    }

    public void inline() {
        this.inline(null);
    }

    public void inline(SinkEventAttributes attributes) {
        if (!this.headerFlag) {
            ArrayList<String> tags = new ArrayList<String>();
            if (attributes != null) {
                if (attributes.containsAttribute((Object)"semantics", (Object)"italic")) {
                    this.write("_");
                    tags.add(0, "_");
                }
                if (attributes.containsAttribute((Object)"semantics", (Object)"bold")) {
                    this.write("**");
                    tags.add(0, "**");
                }
                if (attributes.containsAttribute((Object)"semantics", (Object)"code")) {
                    this.write("`");
                    tags.add(0, "`");
                }
            }
            this.inlineStack.push(tags);
        }
    }

    public void inline_() {
        if (!this.headerFlag) {
            for (String tag : this.inlineStack.pop()) {
                this.write(tag);
            }
        }
    }

    public void italic() {
        this.inline(SinkEventAttributeSet.Semantics.ITALIC);
    }

    public void italic_() {
        this.inline_();
    }

    public void bold() {
        this.inline(SinkEventAttributeSet.Semantics.BOLD);
    }

    public void bold_() {
        this.inline_();
    }

    public void monospaced() {
        this.inline(SinkEventAttributeSet.Semantics.CODE);
    }

    public void monospaced_() {
        this.inline_();
    }

    public void lineBreak() {
        if (this.headerFlag || this.bufferFlag) {
            this.buffer.append(EOL);
        } else if (this.verbatimFlag) {
            this.write(EOL);
        } else {
            this.write('\\' + EOL);
        }
    }

    public void nonBreakingSpace() {
        if (this.headerFlag || this.bufferFlag) {
            this.buffer.append(NON_BREAKING_SPACE_MARKUP);
        } else {
            this.write(NON_BREAKING_SPACE_MARKUP);
        }
    }

    public void text(String text) {
        if (this.tableCaptionFlag) {
            this.tableCaptionBuffer.append(text);
        } else if (this.headerFlag || this.bufferFlag) {
            this.buffer.append(text);
        } else if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    public void rawText(String text) {
        this.write(text);
    }

    public void comment(String comment) {
        this.rawText((this.startFlag ? "" : EOL) + "<!-- " + comment + " -->");
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        this.getLog().warn((CharSequence)("Unknown Sink event '" + name + "', ignoring!"));
    }

    protected void write(String text) {
        this.startFlag = false;
        if (this.tableCellFlag) {
            this.buffer.append(text);
        } else {
            this.writer.write(MarkdownSink.unifyEOLs((String)text));
        }
    }

    protected void content(String text) {
        this.write(MarkdownSink.escapeMarkdown(text));
    }

    protected void verbatimContent(String text) {
        this.write(text);
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
        this.init();
    }

    private static String escapeMarkdown(String text) {
        if (text == null) {
            return "";
        }
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        block3: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '*': 
                case '+': 
                case '<': 
                case '=': 
                case '>': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': 
                case '~': {
                    buffer.append('\\');
                    buffer.append(c);
                    continue block3;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }
}

