/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.markdown;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.util.TextCollectingVisitor;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.definition.DefinitionExtension;
import com.vladsch.flexmark.ext.escaped.character.EscapedCharacterExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.typographic.TypographicExtension;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.input.CharSequenceReader;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.markup.TextMarkup;
import org.apache.maven.doxia.module.markdown.FlexmarkDoxiaLinkResolver;
import org.apache.maven.doxia.module.xhtml.XhtmlParser;
import org.apache.maven.doxia.parser.AbstractTextParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;

@Component(role=org.apache.maven.doxia.parser.Parser.class, hint="markdown")
public class MarkdownParser
extends AbstractTextParser
implements TextMarkup {
    public static final String ROLE_HINT = "markdown";
    private static final Pattern METADATA_SECTION_PATTERN = Pattern.compile("\\A^\\s*(?:title|author|date|address|affiliation|copyright|email|keywords|language|phone|subtitle)[ \\t]*:[ \\t]*[^\\r\\n]*[ \\t]*$[\\r\\n]+(?:^[ \\t]*[^:\\r\\n]+[ \\t]*:[ \\t]*[^\\r\\n]*[ \\t]*$[\\r\\n]+)*", 10);
    private static final Pattern METADATA_ENTRY_PATTERN = Pattern.compile("^[ \\t]*([^:\\r\\n]+?)[ \\t]*:[ \\t]*([^\\r\\n]*)[ \\t]*$", 8);
    @Requirement
    private MarkdownHtmlParser parser;
    private static final Parser FLEXMARK_PARSER;
    private static final HtmlRenderer FLEXMARK_HTML_RENDERER;

    public void parse(Reader source, Sink sink, String reference) throws ParseException {
        try {
            CharSequence html = this.toHtml(source);
            this.parser.parse((Reader)new CharSequenceReader(html), sink);
        }
        catch (IOException e) {
            throw new ParseException("Failed reading Markdown source document", (Exception)e);
        }
    }

    CharSequence toHtml(Reader source) throws IOException {
        String text = IOUtil.toString((Reader)source);
        StringBuilder html = new StringBuilder(1000);
        html.append("<html>");
        html.append("<head>");
        if (text.startsWith("---")) {
            text = text.replaceFirst("---", "").replaceFirst("---", "");
        }
        Matcher metadataMatcher = METADATA_SECTION_PATTERN.matcher(text);
        boolean haveTitle = false;
        if (metadataMatcher.find()) {
            Matcher entryMatcher = METADATA_ENTRY_PATTERN.matcher(metadataMatcher.group(0));
            while (entryMatcher.find()) {
                String key = entryMatcher.group(1);
                String value = entryMatcher.group(2);
                if ("title".equalsIgnoreCase(key)) {
                    haveTitle = true;
                    html.append("<title>");
                    html.append(HtmlTools.escapeHTML((String)value, (boolean)false));
                    html.append("</title>");
                    continue;
                }
                html.append("<meta name='");
                html.append(HtmlTools.escapeHTML((String)key));
                html.append("' content='");
                html.append(HtmlTools.escapeHTML((String)value));
                html.append("' />");
            }
            text = text.substring(metadataMatcher.end(0));
        }
        Document documentRoot = FLEXMARK_PARSER.parse(text);
        if (!haveTitle && documentRoot.hasChildren()) {
            Node firstNode;
            for (firstNode = documentRoot.getFirstChild(); firstNode != null && firstNode instanceof HtmlCommentBlock; firstNode = firstNode.getNext()) {
            }
            if (firstNode != null && firstNode instanceof Heading) {
                html.append("<title>");
                TextCollectingVisitor collectingVisitor = new TextCollectingVisitor(new Class[0]);
                String headingText = collectingVisitor.collectAndGetText(firstNode);
                html.append(HtmlTools.escapeHTML((String)headingText, (boolean)false));
                html.append("</title>");
            }
        }
        html.append("</head>");
        html.append("<body>");
        FLEXMARK_HTML_RENDERER.render((Node)documentRoot, (Appendable)html);
        html.append("</body>");
        html.append("</html>");
        return html;
    }

    static {
        MutableDataSet flexmarkOptions = new MutableDataSet();
        flexmarkOptions.set(Parser.EXTENSIONS, Arrays.asList(EscapedCharacterExtension.create(), AbbreviationExtension.create(), AutolinkExtension.create(), DefinitionExtension.create(), TypographicExtension.create(), TablesExtension.create(), WikiLinkExtension.create(), StrikethroughExtension.create()));
        flexmarkOptions.set(TypographicExtension.SINGLE_QUOTE_UNMATCHED, (Object)"&apos;");
        flexmarkOptions.set(HtmlRenderer.HTML_BLOCK_OPEN_TAG_EOL, (Object)false);
        flexmarkOptions.set(HtmlRenderer.HTML_BLOCK_CLOSE_TAG_EOL, (Object)false);
        flexmarkOptions.set(HtmlRenderer.MAX_TRAILING_BLANK_LINES, (Object)-1);
        FLEXMARK_PARSER = Parser.builder((DataHolder)flexmarkOptions).build();
        FLEXMARK_HTML_RENDERER = HtmlRenderer.builder((DataHolder)flexmarkOptions).linkResolverFactory((LinkResolverFactory)new FlexmarkDoxiaLinkResolver.Factory()).build();
    }

    @Component(role=MarkdownHtmlParser.class)
    public static class MarkdownHtmlParser
    extends XhtmlParser {
        protected void init() {
            super.init();
            this.boxed = true;
        }

        protected boolean baseEndTag(XmlPullParser parser, Sink sink) {
            boolean visited = super.baseEndTag(parser, sink);
            if (!visited && parser.getName().equals(HtmlMarkup.DIV.toString())) {
                this.handleUnknown(parser, sink, 3);
                visited = true;
            }
            return visited;
        }

        protected boolean baseStartTag(XmlPullParser parser, Sink sink) {
            boolean visited = super.baseStartTag(parser, sink);
            if (!visited && parser.getName().equals(HtmlMarkup.DIV.toString())) {
                this.handleUnknown(parser, sink, 2);
                this.boxed = true;
                visited = true;
            }
            return visited;
        }
    }
}

