/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.itext;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import java.awt.Color;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.doxia.module.itext.ITextFont;
import org.apache.maven.doxia.module.itext.ITextHeader;
import org.apache.maven.doxia.module.itext.ITextUtil;
import org.apache.maven.doxia.module.itext.SinkActionContext;
import org.apache.maven.doxia.sink.SinkAdapter;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public final class ITextSink
extends SinkAdapter {
    public static final String DTD = "http://itext.sourceforge.net/itext.dtd";
    public static final String DOCTYPE = "ITEXT SYSTEM \"http://itext.sourceforge.net/itext.dtd\"";
    public static final String DEFAULT_CHAPTER_TITLE_LEADING = "36.0";
    public static final String DEFAULT_SECTION_TITLE_LEADING = "24.0";
    private ClassLoader currentClassLoader;
    private SinkActionContext actionContext;
    private Writer writer;
    private XMLWriter xmlWriter;
    private boolean writeStart;
    private ITextHeader header;
    private ITextFont font;
    private int numberDepth = 0;
    private int depth = 0;
    private String tableCaption = null;

    public ITextSink(Writer writer) {
        this.writer = writer;
        this.actionContext = new SinkActionContext();
        this.font = new ITextFont();
        this.header = new ITextHeader();
        this.xmlWriter = new PrettyPrintXMLWriter(this.writer, "UTF-8", null);
        this.writeStart = true;
    }

    public ITextSink(PrettyPrintXMLWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
        this.actionContext = new SinkActionContext();
        this.font = new ITextFont();
        this.header = new ITextHeader();
        this.writeStart = false;
    }

    public ClassLoader getClassLoader() {
        return this.currentClassLoader;
    }

    public void setClassLoader(ClassLoader cl) {
        this.currentClassLoader = cl;
    }

    public void close() {
        IOUtil.close((Writer)this.writer);
    }

    public void flush() {
        super.flush();
    }

    public void head_() {
        this.actionContext.release();
    }

    public void head() {
        this.actionContext.setAction(3);
    }

    public void author_() {
        this.actionContext.release();
    }

    public void author() {
        this.actionContext.setAction(1);
    }

    public void date_() {
        this.actionContext.release();
    }

    public void date() {
        this.actionContext.setAction(2);
    }

    public void title_() {
        this.actionContext.release();
    }

    public void title() {
        this.actionContext.setAction(0);
    }

    public void body_() {
        if (this.writeStart) {
            this.writeEndElement();
            this.writeEndElement();
        }
        this.actionContext.release();
    }

    public void body() {
        if (this.writeStart) {
            this.writeStartElement("itext");
            this.writeAddAttribute("title", this.header.getTitle());
            this.writeAddAttribute("author", this.header.getAuthors());
            this.writeAddAttribute("creationdate", this.header.getDate());
            this.writeAddAttribute("subject", this.header.getTitle());
            this.writeAddAttribute("keywords", "");
            this.writeAddAttribute("producer", "Generated with Doxia by " + System.getProperty("user.name"));
            this.writeAddAttribute("pagesize", ITextUtil.getPageSize(ITextUtil.getDefaultPageSize()));
            this.writeStartElement("chapter");
            this.writeAddAttribute("numberdepth", this.numberDepth);
            this.writeAddAttribute("depth", this.depth);
            this.writeAddAttribute("indent", "0.0");
            this.writeStartElement("title");
            this.writeAddAttribute("leading", DEFAULT_CHAPTER_TITLE_LEADING);
            this.writeAddAttribute("font", "Helvetica");
            this.writeAddAttribute("size", ITextFont.getSectionFontSize(0));
            this.writeAddAttribute("fontstyle", "bold");
            this.writeAddAttribute("blue", ITextFont.DEFAULT_FONT_COLOR_BLUE);
            this.writeAddAttribute("green", ITextFont.DEFAULT_FONT_COLOR_GREEN);
            this.writeAddAttribute("red", ITextFont.DEFAULT_FONT_COLOR_RED);
            this.writeAddAttribute("align", "Center");
            this.writeStartElement("chunk");
            this.writeAddAttribute("font", "Helvetica");
            this.writeAddAttribute("size", ITextFont.getSectionFontSize(0));
            this.writeAddAttribute("fontstyle", "bold");
            this.writeAddAttribute("blue", ITextFont.DEFAULT_FONT_COLOR_BLUE);
            this.writeAddAttribute("green", ITextFont.DEFAULT_FONT_COLOR_GREEN);
            this.writeAddAttribute("red", ITextFont.DEFAULT_FONT_COLOR_RED);
            this.write(this.header.getTitle());
            this.writeEndElement();
            this.writeEndElement();
        }
        this.actionContext.setAction(4);
    }

    public void sectionTitle() {
        this.actionContext.release();
    }

    public void sectionTitle_() {
        this.actionContext.setAction(10);
    }

    public void section1_() {
        this.writeEndElement();
        --this.numberDepth;
        this.depth = 0;
        this.actionContext.release();
    }

    public void section1() {
        ++this.numberDepth;
        this.depth = 1;
        this.writeStartElement("section");
        this.writeAddAttribute("numberdepth", this.numberDepth);
        this.writeAddAttribute("depth", this.depth);
        this.writeAddAttribute("indent", "0.0");
        this.lineBreak();
        this.actionContext.setAction(20);
    }

    public void sectionTitle1_() {
        this.writeEndElement();
        this.font.setSize(12.0f);
        this.bold_();
        this.actionContext.release();
    }

    public void sectionTitle1() {
        this.font.setSize(ITextFont.getSectionFontSize(1));
        this.font.setColor(Color.BLACK);
        this.bold();
        this.writeStartElement("title");
        this.writeAddAttribute("leading", DEFAULT_SECTION_TITLE_LEADING);
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.actionContext.setAction(11);
    }

    public void section2_() {
        this.writeEndElement();
        --this.numberDepth;
        this.depth = 0;
        this.actionContext.release();
    }

    public void section2() {
        ++this.numberDepth;
        this.depth = 1;
        this.writeStartElement("section");
        this.writeAddAttribute("numberdepth", this.numberDepth);
        this.writeAddAttribute("depth", this.depth);
        this.writeAddAttribute("indent", "0.0");
        this.lineBreak();
        this.actionContext.setAction(21);
    }

    public void sectionTitle2_() {
        this.writeEndElement();
        this.font.setSize(12.0f);
        this.bold_();
        this.actionContext.release();
    }

    public void sectionTitle2() {
        this.font.setSize(ITextFont.getSectionFontSize(2));
        this.font.setColor(Color.BLACK);
        this.bold();
        this.writeStartElement("title");
        this.writeAddAttribute("leading", DEFAULT_SECTION_TITLE_LEADING);
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.actionContext.setAction(12);
    }

    public void section3_() {
        this.writeEndElement();
        --this.numberDepth;
        this.depth = 1;
        this.actionContext.release();
    }

    public void section3() {
        ++this.numberDepth;
        this.depth = 1;
        this.writeStartElement("section");
        this.writeAddAttribute("numberdepth", this.numberDepth);
        this.writeAddAttribute("depth", this.depth);
        this.writeAddAttribute("indent", "0.0");
        this.lineBreak();
        this.actionContext.setAction(22);
    }

    public void sectionTitle3_() {
        this.writeEndElement();
        this.font.setSize(12.0f);
        this.bold_();
        this.actionContext.release();
    }

    public void sectionTitle3() {
        this.font.setSize(ITextFont.getSectionFontSize(3));
        this.font.setColor(Color.BLACK);
        this.bold();
        this.writeStartElement("title");
        this.writeAddAttribute("leading", DEFAULT_SECTION_TITLE_LEADING);
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.actionContext.setAction(13);
    }

    public void section4_() {
        this.writeEndElement();
        --this.numberDepth;
        this.depth = 1;
        this.actionContext.release();
    }

    public void section4() {
        ++this.numberDepth;
        this.depth = 1;
        this.writeStartElement("section");
        this.writeAddAttribute("numberdepth", this.numberDepth);
        this.writeAddAttribute("depth", this.depth);
        this.writeAddAttribute("indent", "0.0");
        this.lineBreak();
        this.actionContext.setAction(23);
    }

    public void sectionTitle4_() {
        this.writeEndElement();
        this.font.setSize(12.0f);
        this.bold_();
        this.actionContext.release();
    }

    public void sectionTitle4() {
        this.font.setSize(ITextFont.getSectionFontSize(4));
        this.font.setColor(Color.BLACK);
        this.bold();
        this.writeStartElement("title");
        this.writeAddAttribute("leading", DEFAULT_SECTION_TITLE_LEADING);
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.actionContext.setAction(14);
    }

    public void section5_() {
        this.writeEndElement();
        --this.numberDepth;
        this.depth = 1;
        this.actionContext.release();
    }

    public void section5() {
        ++this.numberDepth;
        this.depth = 1;
        this.writeStartElement("section");
        this.writeAddAttribute("numberdepth", this.numberDepth);
        this.writeAddAttribute("depth", this.depth);
        this.writeAddAttribute("indent", "0.0");
        this.lineBreak();
        this.actionContext.setAction(24);
    }

    public void sectionTitle5_() {
        this.writeEndElement();
        this.font.setSize(12.0f);
        this.bold_();
        this.actionContext.release();
    }

    public void sectionTitle5() {
        this.font.setSize(ITextFont.getSectionFontSize(5));
        this.font.setColor(Color.BLACK);
        this.bold();
        this.writeStartElement("title");
        this.writeAddAttribute("leading", DEFAULT_SECTION_TITLE_LEADING);
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.actionContext.setAction(15);
    }

    public void paragraph_() {
        if (this.actionContext.getCurrentAction() == 40 || this.actionContext.getCurrentAction() == 41 || this.actionContext.getCurrentAction() == 43) {
            return;
        }
        this.writeEndElement();
        this.actionContext.release();
    }

    public void paragraph() {
        if (this.actionContext.getCurrentAction() == 40 || this.actionContext.getCurrentAction() == 41 || this.actionContext.getCurrentAction() == 43) {
            return;
        }
        this.writeStartElement("paragraph");
        this.writeStartElement("newline");
        this.writeEndElement();
        this.actionContext.setAction(44);
    }

    public void list_() {
        this.writeEndElement();
        this.writeEndElement();
        this.actionContext.release();
    }

    public void list() {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.writeStartElement("list");
        this.writeAddAttribute("numbered", Boolean.FALSE.toString());
        this.writeAddAttribute("symbolindent", "15");
        this.actionContext.setAction(45);
    }

    public void listItem_() {
        this.writeEndElement();
        this.actionContext.release();
    }

    public void listItem() {
        this.writeStartElement("listitem");
        this.writeAddAttribute("indentationleft", "20.0");
        this.actionContext.setAction(40);
    }

    public void numberedList_() {
        this.writeEndElement();
        this.writeEndElement();
        this.actionContext.release();
    }

    public void numberedList(int numbering) {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.writeStartElement("list");
        this.writeAddAttribute("numbered", Boolean.TRUE.toString());
        this.writeAddAttribute("symbolindent", "20");
        switch (numbering) {
            case 2: {
                this.writeAddAttribute("lettered", Boolean.TRUE.toString());
                this.writeAddAttribute("first", 65);
                break;
            }
            case 1: {
                this.writeAddAttribute("lettered", Boolean.TRUE.toString());
                this.writeAddAttribute("first", 97);
                break;
            }
            case 4: {
                this.writeAddAttribute("lettered", Boolean.TRUE.toString());
                this.writeAddAttribute("first", 73);
                break;
            }
            case 3: {
                this.writeAddAttribute("lettered", Boolean.TRUE.toString());
                this.writeAddAttribute("first", 105);
                break;
            }
            default: {
                this.writeAddAttribute("lettered", Boolean.FALSE.toString());
            }
        }
        this.actionContext.setAction(42);
    }

    public void numberedListItem_() {
        this.writeEndElement();
        this.actionContext.release();
    }

    public void numberedListItem() {
        this.writeStartElement("listitem");
        this.writeAddAttribute("indentationleft", "20");
        this.actionContext.setAction(41);
    }

    public void definitionList_() {
        this.actionContext.release();
    }

    public void definitionList() {
        this.actionContext.setAction(30);
    }

    public void definedTerm_() {
        this.writeEndElement();
        this.writeEndElement();
        this.writeEndElement();
        this.writeEndElement();
        this.actionContext.release();
    }

    public void definedTerm() {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.writeStartElement("table");
        this.writeAddAttribute("columns", "1");
        this.writeAddAttribute("left", Boolean.FALSE.toString());
        this.writeAddAttribute("right", Boolean.FALSE.toString());
        this.writeAddAttribute("top", Boolean.FALSE.toString());
        this.writeAddAttribute("bottom", Boolean.FALSE.toString());
        this.writeAddAttribute("align", "Center");
        this.writeAddAttribute("width", "100%");
        this.writeAddAttribute("cellpadding", "0");
        this.writeStartElement("row");
        this.writeStartElement("cell");
        this.writeAddAttribute("left", Boolean.FALSE.toString());
        this.writeAddAttribute("right", Boolean.FALSE.toString());
        this.writeAddAttribute("top", Boolean.FALSE.toString());
        this.writeAddAttribute("bottom", Boolean.FALSE.toString());
        this.actionContext.setAction(32);
    }

    public void definition_() {
        this.writeEndElement();
        this.writeEndElement();
        this.writeEndElement();
        this.writeEndElement();
        this.actionContext.release();
    }

    public void definition() {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.writeStartElement("table");
        this.writeAddAttribute("columns", "2");
        this.writeAddAttribute("left", Boolean.FALSE.toString());
        this.writeAddAttribute("right", Boolean.FALSE.toString());
        this.writeAddAttribute("top", Boolean.FALSE.toString());
        this.writeAddAttribute("bottom", Boolean.FALSE.toString());
        this.writeAddAttribute("align", "Center");
        this.writeAddAttribute("width", "100%");
        this.writeAddAttribute("widths", "20.0;80.0");
        this.writeAddAttribute("cellsfitpage", Boolean.TRUE.toString());
        this.writeAddAttribute("cellpadding", "5");
        this.writeStartElement("row");
        this.writeStartElement("cell");
        this.writeAddAttribute("left", Boolean.FALSE.toString());
        this.writeAddAttribute("right", Boolean.FALSE.toString());
        this.writeAddAttribute("top", Boolean.FALSE.toString());
        this.writeAddAttribute("bottom", Boolean.FALSE.toString());
        this.write("");
        this.writeEndElement();
        this.writeStartElement("cell");
        this.writeAddAttribute("left", Boolean.FALSE.toString());
        this.writeAddAttribute("right", Boolean.FALSE.toString());
        this.writeAddAttribute("top", Boolean.FALSE.toString());
        this.writeAddAttribute("bottom", Boolean.FALSE.toString());
        this.actionContext.setAction(43);
    }

    public void definitionListItem_() {
        this.actionContext.release();
    }

    public void definitionListItem() {
        this.actionContext.setAction(31);
    }

    public void table_() {
        this.writeEndElement();
        this.writeEndElement();
        this.actionContext.release();
        if (this.tableCaption != null) {
            this.writeStartElement("paragraph");
            this.writeAddAttribute("align", "Center");
            this.write(this.tableCaption);
            this.writeEndElement();
            this.tableCaption = null;
        }
    }

    public void table() {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.writeStartElement("table");
        this.writeAddAttribute("left", Boolean.TRUE.toString());
        this.writeAddAttribute("right", Boolean.TRUE.toString());
        this.writeAddAttribute("top", Boolean.TRUE.toString());
        this.writeAddAttribute("bottom", Boolean.TRUE.toString());
        this.writeAddAttribute("align", "Center");
        this.writeAddAttribute("width", "100.0%");
        this.writeAddAttribute("tablefitspage", Boolean.TRUE.toString());
        this.writeAddAttribute("cellsfitpage", Boolean.TRUE.toString());
        this.writeAddAttribute("cellpadding", "10");
        this.actionContext.setAction(50);
    }

    public void tableCaption_() {
        this.actionContext.release();
    }

    public void tableCaption() {
        this.actionContext.setAction(51);
    }

    public void tableCell_() {
        this.writeEndElement();
        this.actionContext.release();
    }

    public void tableCell() {
        this.writeStartElement("cell");
        this.writeAddAttribute("left", Boolean.TRUE.toString());
        this.writeAddAttribute("right", Boolean.TRUE.toString());
        this.writeAddAttribute("top", Boolean.TRUE.toString());
        this.writeAddAttribute("bottom", Boolean.TRUE.toString());
        this.writeAddAttribute("horizontalalign", "Left");
        this.actionContext.setAction(52);
    }

    public void tableCell(String width) {
        this.actionContext.setAction(52);
    }

    public void tableHeaderCell_() {
        this.writeEndElement();
        this.actionContext.release();
    }

    public void tableHeaderCell() {
        this.writeStartElement("cell");
        this.writeAddAttribute("left", Boolean.TRUE.toString());
        this.writeAddAttribute("right", Boolean.TRUE.toString());
        this.writeAddAttribute("top", Boolean.TRUE.toString());
        this.writeAddAttribute("bottom", Boolean.TRUE.toString());
        this.writeAddAttribute("header", Boolean.TRUE.toString());
        this.writeAddAttribute("bgred", Color.GRAY.getRed());
        this.writeAddAttribute("bgblue", Color.GRAY.getBlue());
        this.writeAddAttribute("bggreen", Color.GRAY.getGreen());
        this.writeAddAttribute("horizontalalign", "Center");
        this.actionContext.setAction(53);
    }

    public void tableHeaderCell(String width) {
        this.actionContext.setAction(53);
    }

    public void tableRow_() {
        this.writeEndElement();
        this.actionContext.release();
    }

    public void tableRow() {
        this.writeStartElement("row");
        this.actionContext.setAction(54);
    }

    public void tableRows_() {
        this.actionContext.release();
    }

    public void tableRows(int[] justification, boolean grid) {
        this.writeAddAttribute("columns", justification.length);
        this.actionContext.setAction(55);
    }

    public void verbatim_() {
        this.writeEndElement();
        this.writeEndElement();
        this.writeEndElement();
        this.writeEndElement();
        this.actionContext.release();
    }

    public void verbatim(boolean boxed) {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.writeStartElement("table");
        this.writeAddAttribute("columns", "1");
        this.writeAddAttribute("left", Boolean.TRUE.toString());
        this.writeAddAttribute("right", Boolean.TRUE.toString());
        this.writeAddAttribute("top", Boolean.TRUE.toString());
        this.writeAddAttribute("bottom", Boolean.TRUE.toString());
        this.writeAddAttribute("align", "Center");
        this.writeAddAttribute("tablefitspage", Boolean.TRUE.toString());
        this.writeAddAttribute("cellsfitpage", Boolean.TRUE.toString());
        this.writeAddAttribute("cellpadding", "10");
        this.writeAddAttribute("width", "100.0%");
        this.writeStartElement("row");
        this.writeStartElement("cell");
        this.writeAddAttribute("left", Boolean.TRUE.toString());
        this.writeAddAttribute("right", Boolean.TRUE.toString());
        this.writeAddAttribute("top", Boolean.TRUE.toString());
        this.writeAddAttribute("bottom", Boolean.TRUE.toString());
        this.actionContext.setAction(60);
    }

    public void figure_() {
        this.writeEndElement();
        this.writeEndElement();
        this.actionContext.release();
    }

    public void figure() {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.writeStartElement("image");
        this.actionContext.setAction(70);
    }

    public void figureCaption_() {
        this.actionContext.release();
    }

    public void figureCaption() {
        this.actionContext.setAction(71);
    }

    public void figureGraphics(String name) {
        String urlName = null;
        if (name.toLowerCase().startsWith("http://") || name.toLowerCase().startsWith("https://")) {
            urlName = name;
        } else if (this.getClassLoader() != null) {
            if (this.getClassLoader().getResource(name) != null) {
                urlName = this.getClassLoader().getResource(name).toString();
            }
        } else if (ITextSink.class.getClassLoader().getResource(name) != null) {
            urlName = ITextSink.class.getClassLoader().getResource(name).toString();
        }
        if (urlName == null) {
            System.err.println("The image " + name + " not found in the class loader. Try to call setClassLoader(ClassLoader) before.");
            return;
        }
        float width = 0.0f;
        float height = 0.0f;
        try {
            Image image = Image.getInstance((URL)new URL(urlName));
            image.scaleToFit(ITextUtil.getDefaultPageSize().width() / 2.0f, ITextUtil.getDefaultPageSize().height() / 2.0f);
            width = image.plainWidth();
            height = image.plainHeight();
        }
        catch (BadElementException e) {
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        this.writeAddAttribute("url", urlName);
        this.writeAddAttribute("align", "Middle");
        this.writeAddAttribute("plainwidth", String.valueOf(width));
        this.writeAddAttribute("plainheight", String.valueOf(height));
        this.actionContext.setAction(72);
    }

    public void bold_() {
        this.font.removeBold();
    }

    public void bold() {
        this.font.addBold();
    }

    public void italic_() {
        this.font.removeItalic();
    }

    public void italic() {
        this.font.addItalic();
    }

    public void monospaced_() {
        this.font.setMonoSpaced(false);
    }

    public void monospaced() {
        this.font.setMonoSpaced(true);
    }

    public void link_() {
        this.writeEndElement();
        this.font.setColor(Color.BLACK);
        this.font.removeUnderlined();
        this.actionContext.release();
    }

    public void link(String name) {
        this.font.setColor(Color.BLUE);
        this.font.addUnderlined();
        this.writeStartElement("anchor");
        this.writeAddAttribute("reference", HtmlTools.escapeHTML((String)name));
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.actionContext.setAction(80);
    }

    public void anchor_() {
        this.writeEndElement();
        this.actionContext.release();
    }

    public void anchor(String name) {
        this.writeStartElement("anchor");
        this.writeAddAttribute("name", HtmlTools.encodeId((String)name));
        this.actionContext.setAction(81);
    }

    public void lineBreak() {
        if (this.actionContext.getCurrentAction() == 1 || this.actionContext.getCurrentAction() == 2 || this.actionContext.getCurrentAction() == 0) {
            return;
        }
        this.writeStartElement("newline");
        this.writeEndElement();
    }

    public void nonBreakingSpace() {
        this.write(" ");
    }

    public void pageBreak() {
        this.writeStartElement("newpage");
        this.writeEndElement();
    }

    public void horizontalRule() {
        this.writeStartElement("paragraph");
        this.writeStartElement("horizontalrule");
        this.writeEndElement();
        this.writeEndElement();
    }

    public void rawText(String text) {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.write(text, false);
        this.writeEndElement();
    }

    public void text(String text) {
        switch (this.actionContext.getCurrentAction()) {
            case 82: {
                break;
            }
            case 3: {
                break;
            }
            case 1: {
                this.header.addAuthor(text);
                break;
            }
            case 2: {
                this.header.setDate(text);
                break;
            }
            case 0: {
                this.header.setTitle(text);
                break;
            }
            case 11: {
                this.writeStartElement("chunk");
                this.writeAddAttribute("font", this.font.getFontName());
                this.writeAddAttribute("size", this.font.getFontSize());
                this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                this.writeAddAttribute("blue", this.font.getFontColorBlue());
                this.writeAddAttribute("green", this.font.getFontColorGreen());
                this.writeAddAttribute("red", this.font.getFontColorRed());
                this.write(text);
                this.writeEndElement();
                break;
            }
            case 12: {
                this.writeStartElement("chunk");
                this.writeAddAttribute("font", this.font.getFontName());
                this.writeAddAttribute("size", this.font.getFontSize());
                this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                this.writeAddAttribute("blue", this.font.getFontColorBlue());
                this.writeAddAttribute("green", this.font.getFontColorGreen());
                this.writeAddAttribute("red", this.font.getFontColorRed());
                this.write(text);
                this.writeEndElement();
                break;
            }
            case 13: {
                this.writeStartElement("chunk");
                this.writeAddAttribute("font", this.font.getFontName());
                this.writeAddAttribute("size", this.font.getFontSize());
                this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                this.writeAddAttribute("blue", this.font.getFontColorBlue());
                this.writeAddAttribute("green", this.font.getFontColorGreen());
                this.writeAddAttribute("red", this.font.getFontColorRed());
                this.write(text);
                this.writeEndElement();
                break;
            }
            case 14: {
                this.writeStartElement("chunk");
                this.writeAddAttribute("font", this.font.getFontName());
                this.writeAddAttribute("size", this.font.getFontSize());
                this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                this.writeAddAttribute("blue", this.font.getFontColorBlue());
                this.writeAddAttribute("green", this.font.getFontColorGreen());
                this.writeAddAttribute("red", this.font.getFontColorRed());
                this.write(text);
                this.writeEndElement();
                break;
            }
            case 15: {
                this.writeStartElement("chunk");
                this.writeAddAttribute("font", this.font.getFontName());
                this.writeAddAttribute("size", this.font.getFontSize());
                this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                this.writeAddAttribute("blue", this.font.getFontColorBlue());
                this.writeAddAttribute("green", this.font.getFontColorGreen());
                this.writeAddAttribute("red", this.font.getFontColorRed());
                this.write(text);
                this.writeEndElement();
                break;
            }
            case 40: {
                this.writeStartElement("chunk");
                this.writeAddAttribute("font", this.font.getFontName());
                this.writeAddAttribute("size", this.font.getFontSize());
                this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                this.writeAddAttribute("blue", this.font.getFontColorBlue());
                this.writeAddAttribute("green", this.font.getFontColorGreen());
                this.writeAddAttribute("red", this.font.getFontColorRed());
                this.write(text);
                this.writeEndElement();
                break;
            }
            case 41: {
                this.writeStartElement("chunk");
                this.writeAddAttribute("font", this.font.getFontName());
                this.writeAddAttribute("size", this.font.getFontSize());
                this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                this.writeAddAttribute("blue", this.font.getFontColorBlue());
                this.writeAddAttribute("green", this.font.getFontColorGreen());
                this.writeAddAttribute("red", this.font.getFontColorRed());
                this.write(text);
                this.writeEndElement();
                break;
            }
            case 32: {
                this.writeStartElement("chunk");
                this.writeAddAttribute("font", this.font.getFontName());
                this.writeAddAttribute("size", this.font.getFontSize());
                this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                this.writeAddAttribute("blue", this.font.getFontColorBlue());
                this.writeAddAttribute("green", this.font.getFontColorGreen());
                this.writeAddAttribute("red", this.font.getFontColorRed());
                this.write(text);
                this.writeEndElement();
                break;
            }
            case 43: {
                this.writeStartElement("chunk");
                this.writeAddAttribute("font", this.font.getFontName());
                this.writeAddAttribute("size", this.font.getFontSize());
                this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                this.writeAddAttribute("blue", this.font.getFontColorBlue());
                this.writeAddAttribute("green", this.font.getFontColorGreen());
                this.writeAddAttribute("red", this.font.getFontColorRed());
                this.write(text);
                this.writeEndElement();
                break;
            }
            case 50: {
                break;
            }
            case 54: {
                break;
            }
            case 53: {
                this.writeStartElement("chunk");
                this.writeAddAttribute("font", this.font.getFontName());
                this.writeAddAttribute("size", this.font.getFontSize());
                this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                this.writeAddAttribute("blue", this.font.getFontColorBlue());
                this.writeAddAttribute("green", this.font.getFontColorGreen());
                this.writeAddAttribute("red", this.font.getFontColorRed());
                this.write(text);
                this.writeEndElement();
                break;
            }
            case 52: {
                this.writeStartElement("chunk");
                this.writeAddAttribute("font", this.font.getFontName());
                this.writeAddAttribute("size", this.font.getFontSize());
                this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                this.writeAddAttribute("blue", this.font.getFontColorBlue());
                this.writeAddAttribute("green", this.font.getFontColorGreen());
                this.writeAddAttribute("red", this.font.getFontColorRed());
                this.write(text);
                this.writeEndElement();
                break;
            }
            case 51: {
                this.tableCaption = text;
                break;
            }
            case 60: {
                LineNumberReader lnr = new LineNumberReader(new StringReader(text));
                try {
                    String line;
                    while ((line = lnr.readLine()) != null) {
                        this.writeStartElement("chunk");
                        this.writeAddAttribute("font", this.font.getFontName());
                        this.writeAddAttribute("size", this.font.getFontSize());
                        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                        this.writeAddAttribute("blue", this.font.getFontColorBlue());
                        this.writeAddAttribute("green", this.font.getFontColorGreen());
                        this.writeAddAttribute("red", this.font.getFontColorRed());
                        this.write("<![CDATA[", true);
                        line = StringUtils.replace((String)line, (String)"<![CDATA[", (String)"< ![CDATA[");
                        line = StringUtils.replace((String)line, (String)"]]>", (String)"]] >");
                        this.write(line, true, false);
                        this.write("]]>", true);
                        this.writeEndElement();
                        this.lineBreak();
                    }
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException("IOException: ", e);
                }
            }
            case 70: 
            case 72: {
                break;
            }
            case 71: {
                this.writeAddAttribute("alt", text);
                break;
            }
            case 80: {
                this.writeStartElement("chunk");
                this.writeAddAttribute("font", this.font.getFontName());
                this.writeAddAttribute("size", this.font.getFontSize());
                this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                this.writeAddAttribute("blue", this.font.getFontColorBlue());
                this.writeAddAttribute("green", this.font.getFontColorGreen());
                this.writeAddAttribute("red", this.font.getFontColorRed());
                this.write(text);
                this.writeEndElement();
                break;
            }
            case 81: {
                this.writeStartElement("chunk");
                this.writeAddAttribute("font", this.font.getFontName());
                this.writeAddAttribute("size", this.font.getFontSize());
                this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                this.writeAddAttribute("blue", this.font.getFontColorBlue());
                this.writeAddAttribute("green", this.font.getFontColorGreen());
                this.writeAddAttribute("red", this.font.getFontColorRed());
                this.write(text);
                this.writeEndElement();
                break;
            }
            case 10: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            default: {
                this.writeStartElement("chunk");
                this.writeAddAttribute("font", this.font.getFontName());
                this.writeAddAttribute("size", this.font.getFontSize());
                this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                this.writeAddAttribute("blue", this.font.getFontColorBlue());
                this.writeAddAttribute("green", this.font.getFontColorGreen());
                this.writeAddAttribute("red", this.font.getFontColorRed());
                this.write(text);
                this.writeEndElement();
            }
        }
    }

    private void writeStartElement(String tag) {
        this.xmlWriter.startElement(tag);
    }

    private void writeAddAttribute(String key, String value) {
        this.xmlWriter.addAttribute(key, value);
    }

    private void writeAddAttribute(String key, int value) {
        this.xmlWriter.addAttribute(key, String.valueOf(value));
    }

    private void writeEndElement() {
        this.xmlWriter.endElement();
    }

    private void write(String aString) {
        this.write(aString, false);
    }

    private void write(String aString, boolean escapeHtml) {
        this.write(aString, escapeHtml, true);
    }

    private void write(String aString, boolean escapeHtml, boolean trim) {
        if (aString == null) {
            return;
        }
        if (trim) {
            aString = StringUtils.replace((String)aString, (String)"\n", (String)"");
            LineNumberReader lnr = new LineNumberReader(new StringReader(aString));
            StringBuffer sb = new StringBuffer();
            try {
                String line;
                while ((line = lnr.readLine()) != null) {
                    sb.append(ITextSink.beautifyPhrase(line.trim()));
                    sb.append(" ");
                }
                aString = sb.toString();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (aString.trim().length() == 0) {
                return;
            }
        }
        if (escapeHtml) {
            this.xmlWriter.writeMarkup(aString);
        } else {
            this.xmlWriter.writeText(aString);
        }
    }

    private static String beautifyPhrase(String aString) {
        String[] strings = StringUtils.split((String)aString, (String)" ");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i].trim().length() == 0) continue;
            sb.append(strings[i].trim());
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    private void startChunk(String fontName, int fontSize, String fontStyle, int fontColorBlue, int fontColorGreen, int fontColorRed, String localDestination) {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", fontName);
        this.writeAddAttribute("size", fontSize);
        this.writeAddAttribute("fontstyle", fontStyle);
        this.writeAddAttribute("blue", fontColorBlue);
        this.writeAddAttribute("green", fontColorGreen);
        this.writeAddAttribute("red", fontColorRed);
    }
}

