/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.apt;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.text.AttributeSet;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.macro.manager.MacroNotFoundException;
import org.apache.maven.doxia.markup.Markup;
import org.apache.maven.doxia.module.apt.AptMarkup;
import org.apache.maven.doxia.module.apt.AptParseException;
import org.apache.maven.doxia.module.apt.AptReaderSource;
import org.apache.maven.doxia.module.apt.AptSource;
import org.apache.maven.doxia.module.apt.AptUtils;
import org.apache.maven.doxia.parser.AbstractTextParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkAdapter;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class AptParser
extends AbstractTextParser
implements AptMarkup {
    private static final int TITLE = 0;
    private static final int SECTION1 = 1;
    private static final int SECTION2 = 2;
    private static final int SECTION3 = 3;
    private static final int SECTION4 = 4;
    private static final int SECTION5 = 5;
    private static final int PARAGRAPH = 6;
    private static final int VERBATIM = 7;
    private static final int FIGURE = 8;
    private static final int TABLE = 9;
    private static final int LIST_ITEM = 10;
    private static final int NUMBERED_LIST_ITEM = 11;
    private static final int DEFINITION_LIST_ITEM = 12;
    private static final int HORIZONTAL_RULE = 13;
    private static final int PG_BREAK = 14;
    private static final int LIST_BREAK = 15;
    private static final int MACRO = 16;
    private static final int COMMENT_BLOCK = 17;
    private static final String[] TYPE_NAMES = new String[]{"TITLE", "SECTION1", "SECTION2", "SECTION3", "SECTION4", "SECTION5", "PARAGRAPH", "VERBATIM", "FIGURE", "TABLE", "LIST_ITEM", "NUMBERED_LIST_ITEM", "DEFINITION_LIST_ITEM", "HORIZONTAL_RULE", "PG_BREAK", "LIST_BREAK", "MACRO", "COMMENT_BLOCK"};
    protected static final char[] SPACES = new char[85];
    public static final int TAB_WIDTH = 8;
    private AptSource source;
    private Block block;
    private String blockFileName;
    private int blockLineNumber;
    protected String sourceContent;
    protected Sink sink;
    protected String line;
    protected Map warnMessages;
    private static final int NUMBER_OF_SPACES = 85;

    public void parse(Reader source, Sink sink) throws ParseException {
        try {
            try {
                StringWriter contentWriter = new StringWriter();
                IOUtil.copy((Reader)source, (Writer)contentWriter);
                this.sourceContent = contentWriter.toString();
            }
            catch (IOException e) {
                throw new AptParseException("IOException: " + e.getMessage(), e);
            }
            this.source = new AptReaderSource(new StringReader(this.sourceContent));
            this.sink = sink;
            sink.enableLogging(this.getLog());
            this.blockFileName = null;
            this.blockLineNumber = -1;
            this.nextLine();
            this.nextBlock(true);
            this.traverseHead();
            this.traverseBody();
            this.source = null;
            this.sink = null;
        }
        catch (AptParseException ape) {
            throw new AptParseException(ape.getMessage(), (Exception)((Object)ape), this.getSourceName(), this.getSourceLineNumber(), -1);
        }
        if (this.getLog().isWarnEnabled() && this.warnMessages != null && !this.isSecondParsing()) {
            Iterator it = this.warnMessages.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Set set = (Set)entry.getValue();
                Iterator it2 = set.iterator();
                while (it2.hasNext()) {
                    String msg = (String)it2.next();
                    this.getLog().warn((CharSequence)msg);
                }
            }
            this.warnMessages = null;
        }
    }

    public String getSourceName() {
        return this.blockFileName;
    }

    public int getSourceLineNumber() {
        return this.blockLineNumber;
    }

    protected void nextLine() throws AptParseException {
        this.line = this.source.getNextLine();
    }

    /*
     * Unable to fully structure code
     */
    protected void doTraverseText(String text, int begin, int end, Sink sink) throws AptParseException {
        anchor = false;
        link = false;
        italic = false;
        bold = false;
        monospaced = false;
        buffer = new StringBuffer(end - begin);
        block20: for (i = begin; i < end; ++i) {
            c = text.charAt(i);
            switch (c) {
                case '\\': {
                    if (i + 1 >= end) ** GOTO lbl84
                    escaped = text.charAt(i + 1);
                    switch (escaped) {
                        case ' ': {
                            ++i;
                            AptParser.flushTraversed(buffer, sink);
                            sink.nonBreakingSpace();
                            continue block20;
                        }
                        case '\n': 
                        case '\r': {
                            ++i;
                            while (i + 1 < end && Character.isWhitespace(text.charAt(i + 1))) {
                                ++i;
                            }
                            AptParser.flushTraversed(buffer, sink);
                            sink.lineBreak();
                            continue block20;
                        }
                        case '*': 
                        case '+': 
                        case '-': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '{': 
                        case '|': 
                        case '}': 
                        case '~': {
                            ++i;
                            buffer.append(escaped);
                            continue block20;
                        }
                        case 'x': {
                            if (i + 3 >= end || !AptParser.isHexChar(text.charAt(i + 2)) || !AptParser.isHexChar(text.charAt(i + 3))) ** GOTO lbl45
                            value = 63;
                            try {
                                value = Integer.parseInt(text.substring(i + 2, i + 4), 16);
                            }
                            catch (NumberFormatException e) {
                                if (!this.getLog().isDebugEnabled()) ** GOTO lbl41
                                this.getLog().debug((CharSequence)("Not a number: " + text.substring(i + 2, i + 4)));
                            }
lbl41:
                            // 3 sources

                            i += 3;
                            buffer.append((char)value);
                            continue block20;
lbl45:
                            // 1 sources

                            buffer.append('\\');
                            continue block20;
                        }
                        case 'u': {
                            if (i + 5 >= end || !AptParser.isHexChar(text.charAt(i + 2)) || !AptParser.isHexChar(text.charAt(i + 3)) || !AptParser.isHexChar(text.charAt(i + 4)) || !AptParser.isHexChar(text.charAt(i + 5))) ** GOTO lbl61
                            value = 63;
                            try {
                                value = Integer.parseInt(text.substring(i + 2, i + 6), 16);
                            }
                            catch (NumberFormatException e) {
                                if (!this.getLog().isDebugEnabled()) ** GOTO lbl57
                                this.getLog().debug((CharSequence)("Not a number: " + text.substring(i + 2, i + 6)));
                            }
lbl57:
                            // 3 sources

                            i += 5;
                            buffer.append((char)value);
                            continue block20;
lbl61:
                            // 1 sources

                            buffer.append('\\');
                            continue block20;
                        }
                    }
                    if (!AptParser.isOctalChar(escaped)) ** GOTO lbl81
                    octalChars = 1;
                    if (AptParser.isOctalChar(AptParser.charAt(text, end, i + 2))) {
                        ++octalChars;
                        if (AptParser.isOctalChar(AptParser.charAt(text, end, i + 3))) {
                            ++octalChars;
                        }
                    }
                    value = 63;
                    try {
                        value = Integer.parseInt(text.substring(i + 1, i + 1 + octalChars), 8);
                    }
                    catch (NumberFormatException e) {
                        if (!this.getLog().isDebugEnabled()) ** GOTO lbl77
                        this.getLog().debug((CharSequence)("Not a number: " + text.substring(i + 1, i + 1 + octalChars)));
                    }
lbl77:
                    // 3 sources

                    i += octalChars;
                    buffer.append((char)value);
                    continue block20;
lbl81:
                    // 1 sources

                    buffer.append('\\');
                    continue block20;
lbl84:
                    // 1 sources

                    buffer.append('\\');
                    continue block20;
                }
                case '{': {
                    if (!anchor && !link) {
                        if (i + 1 < end && text.charAt(i + 1) == '{') {
                            link = true;
                            AptParser.flushTraversed(buffer, sink);
                            linkAnchor = null;
                            if (++i + 1 < end && text.charAt(i + 1) == '{') {
                                ++i;
                                buf = new StringBuffer();
                                i = AptParser.skipTraversedLinkAnchor(text, i + 1, end, buf);
                                linkAnchor = buf.toString();
                            }
                            if (linkAnchor == null) {
                                linkAnchor = this.getTraversedLink(text, i + 1, end);
                            }
                            if (AptUtils.isInternalLink(linkAnchor)) {
                                linkAnchor = "#" + linkAnchor;
                            }
                            if ((hashIndex = linkAnchor.indexOf("#")) != -1 && !AptUtils.isExternalLink(linkAnchor)) {
                                hash = linkAnchor.substring(hashIndex + 1);
                                if (hash.endsWith(".html") && !hash.startsWith("./")) {
                                    msg = "Ambiguous link: '" + hash + "'. If this is a local link, prepend \"./\"!";
                                    this.logMessage("ambiguousLink", msg);
                                }
                                if (!DoxiaUtils.isValidId((String)hash)) {
                                    linkAnchor = linkAnchor.substring(0, hashIndex) + "#" + DoxiaUtils.encodeId((String)hash, (boolean)true);
                                    msg = "Modified invalid link: '" + hash + "' to '" + linkAnchor + "'";
                                    this.logMessage("modifiedLink", msg);
                                }
                            }
                            sink.link(linkAnchor);
                            continue block20;
                        }
                        anchor = true;
                        AptParser.flushTraversed(buffer, sink);
                        linkAnchor = this.getTraversedAnchor(text, i + 1, end);
                        linkAnchor = AptUtils.encodeAnchor(linkAnchor);
                        sink.anchor(linkAnchor);
                        continue block20;
                    }
                    buffer.append(c);
                    continue block20;
                }
                case '}': {
                    if (link && i + 1 < end && text.charAt(i + 1) == '}') {
                        ++i;
                        link = false;
                        AptParser.flushTraversed(buffer, sink);
                        sink.link_();
                        continue block20;
                    }
                    if (anchor) {
                        anchor = false;
                        AptParser.flushTraversed(buffer, sink);
                        sink.anchor_();
                        continue block20;
                    }
                    buffer.append(c);
                    continue block20;
                }
                case '<': {
                    if (!(italic || bold || monospaced)) {
                        if (i + 1 < end && text.charAt(i + 1) == '<') {
                            if (i + 2 < end && text.charAt(i + 2) == '<') {
                                i += 2;
                                monospaced = true;
                                AptParser.flushTraversed(buffer, sink);
                                sink.monospaced();
                                continue block20;
                            }
                            ++i;
                            bold = true;
                            AptParser.flushTraversed(buffer, sink);
                            sink.bold();
                            continue block20;
                        }
                        italic = true;
                        AptParser.flushTraversed(buffer, sink);
                        sink.italic();
                        continue block20;
                    }
                    buffer.append(c);
                    continue block20;
                }
                case '>': {
                    if (monospaced && i + 2 < end && text.charAt(i + 1) == '>' && text.charAt(i + 2) == '>') {
                        i += 2;
                        monospaced = false;
                        AptParser.flushTraversed(buffer, sink);
                        sink.monospaced_();
                        continue block20;
                    }
                    if (bold && i + 1 < end && text.charAt(i + 1) == '>') {
                        ++i;
                        bold = false;
                        AptParser.flushTraversed(buffer, sink);
                        sink.bold_();
                        continue block20;
                    }
                    if (italic) {
                        italic = false;
                        AptParser.flushTraversed(buffer, sink);
                        sink.italic_();
                        continue block20;
                    }
                    buffer.append(c);
                    continue block20;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        buffer.append(' ');
                        while (i + 1 < end && Character.isWhitespace(text.charAt(i + 1))) {
                            ++i;
                        }
                        continue block20;
                    }
                    buffer.append(c);
                }
            }
        }
        if (monospaced) {
            throw new AptParseException("missing '" + AptParser.MONOSPACED_END_MARKUP + "'");
        }
        if (bold) {
            throw new AptParseException("missing '" + AptParser.BOLD_END_MARKUP + "'");
        }
        if (italic) {
            throw new AptParseException("missing '" + AptParser.ITALIC_END_MARKUP + "'");
        }
        if (link) {
            throw new AptParseException("missing '" + AptParser.LINK_END_MARKUP + "'");
        }
        if (anchor) {
            throw new AptParseException("missing '" + AptParser.ANCHOR_END_MARKUP + "'");
        }
        AptParser.flushTraversed(buffer, sink);
    }

    protected static char charAt(String string, int length, int i) {
        return i < length ? string.charAt(i) : (char)'\u0000';
    }

    protected static int skipSpace(String string, int length, int i) {
        block3: while (i < length) {
            switch (string.charAt(i)) {
                case '\t': 
                case ' ': {
                    break;
                }
                default: {
                    break block3;
                }
            }
            ++i;
        }
        return i;
    }

    protected static String replaceAll(String string, String oldSub, String newSub) {
        int end;
        StringBuffer replaced = new StringBuffer();
        int oldSubLength = oldSub.length();
        int begin = 0;
        while ((end = string.indexOf(oldSub, begin)) >= 0) {
            if (end > begin) {
                replaced.append(string.substring(begin, end));
            }
            replaced.append(newSub);
            begin = end + oldSubLength;
        }
        if (begin < string.length()) {
            replaced.append(string.substring(begin));
        }
        return replaced.toString();
    }

    private void traverseHead() throws AptParseException {
        this.sink.head();
        if (this.block != null && this.block.getType() == 0) {
            this.block.traverse();
            this.nextBlock();
        }
        this.sink.head_();
    }

    private void traverseBody() throws AptParseException {
        this.sink.body();
        if (this.block != null) {
            this.traverseSectionBlocks();
        }
        while (this.block != null) {
            this.traverseSection(0);
        }
        this.sink.body_();
    }

    private void traverseSection(int level) throws AptParseException {
        if (this.block == null) {
            return;
        }
        int type = 1 + level;
        this.expectedBlock(type);
        switch (level) {
            case 0: {
                this.sink.section1();
                break;
            }
            case 1: {
                this.sink.section2();
                break;
            }
            case 2: {
                this.sink.section3();
                break;
            }
            case 3: {
                this.sink.section4();
                break;
            }
            case 4: {
                this.sink.section5();
                break;
            }
        }
        this.block.traverse();
        this.nextBlock();
        this.traverseSectionBlocks();
        while (this.block != null && this.block.getType() > type) {
            this.traverseSection(level + 1);
        }
        switch (level) {
            case 0: {
                this.sink.section1_();
                break;
            }
            case 1: {
                this.sink.section2_();
                break;
            }
            case 2: {
                this.sink.section3_();
                break;
            }
            case 3: {
                this.sink.section4_();
                break;
            }
            case 4: {
                this.sink.section5_();
                break;
            }
        }
    }

    private void traverseSectionBlocks() throws AptParseException {
        block7: while (this.block != null) {
            switch (this.block.getType()) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 13: 
                case 14: 
                case 16: 
                case 17: {
                    this.block.traverse();
                    this.nextBlock();
                    continue block7;
                }
                case 10: {
                    this.traverseList();
                    continue block7;
                }
                case 11: {
                    this.traverseNumberedList();
                    continue block7;
                }
                case 12: {
                    this.traverseDefinitionList();
                    continue block7;
                }
                case 15: {
                    this.nextBlock();
                    continue block7;
                }
            }
            break;
        }
    }

    private void traverseList() throws AptParseException {
        if (this.block == null) {
            return;
        }
        this.expectedBlock(10);
        int listIndent = this.block.getIndent();
        this.sink.list();
        this.sink.listItem();
        this.block.traverse();
        this.nextBlock();
        block8: while (this.block != null) {
            int blockIndent = this.block.getIndent();
            switch (this.block.getType()) {
                case 6: {
                    if (blockIndent < listIndent) break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 13: 
                case 14: 
                case 16: {
                    this.block.traverse();
                    this.nextBlock();
                    continue block8;
                }
                case 10: {
                    if (blockIndent < listIndent) break;
                    if (blockIndent > listIndent) {
                        this.traverseList();
                        continue block8;
                    }
                    this.sink.listItem_();
                    this.sink.listItem();
                    this.block.traverse();
                    this.nextBlock();
                    continue block8;
                }
                case 11: {
                    if (blockIndent < listIndent) break;
                    this.traverseNumberedList();
                    continue block8;
                }
                case 12: {
                    if (blockIndent < listIndent) break;
                    this.traverseDefinitionList();
                    continue block8;
                }
                case 15: {
                    if (blockIndent >= listIndent) {
                        this.nextBlock();
                    } else {
                        break;
                    }
                }
            }
            break;
        }
        this.sink.listItem_();
        this.sink.list_();
    }

    private void traverseNumberedList() throws AptParseException {
        if (this.block == null) {
            return;
        }
        this.expectedBlock(11);
        int listIndent = this.block.getIndent();
        this.sink.numberedList(((NumberedListItem)this.block).getNumbering());
        this.sink.numberedListItem();
        this.block.traverse();
        this.nextBlock();
        block8: while (this.block != null) {
            int blockIndent = this.block.getIndent();
            switch (this.block.getType()) {
                case 6: {
                    if (blockIndent < listIndent) break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 13: 
                case 14: {
                    this.block.traverse();
                    this.nextBlock();
                    continue block8;
                }
                case 10: {
                    if (blockIndent < listIndent) break;
                    this.traverseList();
                    continue block8;
                }
                case 11: {
                    if (blockIndent < listIndent) break;
                    if (blockIndent > listIndent) {
                        this.traverseNumberedList();
                        continue block8;
                    }
                    this.sink.numberedListItem_();
                    this.sink.numberedListItem();
                    this.block.traverse();
                    this.nextBlock();
                    continue block8;
                }
                case 12: {
                    if (blockIndent < listIndent) break;
                    this.traverseDefinitionList();
                    continue block8;
                }
                case 15: {
                    if (blockIndent >= listIndent) {
                        this.nextBlock();
                    } else {
                        break;
                    }
                }
            }
            break;
        }
        this.sink.numberedListItem_();
        this.sink.numberedList_();
    }

    private void traverseDefinitionList() throws AptParseException {
        if (this.block == null) {
            return;
        }
        this.expectedBlock(12);
        int listIndent = this.block.getIndent();
        this.sink.definitionList();
        this.sink.definitionListItem();
        this.block.traverse();
        this.nextBlock();
        block8: while (this.block != null) {
            int blockIndent = this.block.getIndent();
            switch (this.block.getType()) {
                case 6: {
                    if (blockIndent < listIndent) break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 13: 
                case 14: {
                    this.block.traverse();
                    this.nextBlock();
                    continue block8;
                }
                case 10: {
                    if (blockIndent < listIndent) break;
                    this.traverseList();
                    continue block8;
                }
                case 11: {
                    if (blockIndent < listIndent) break;
                    this.traverseNumberedList();
                    continue block8;
                }
                case 12: {
                    if (blockIndent < listIndent) break;
                    if (blockIndent > listIndent) {
                        this.traverseDefinitionList();
                        continue block8;
                    }
                    this.sink.definition_();
                    this.sink.definitionListItem_();
                    this.sink.definitionListItem();
                    this.block.traverse();
                    this.nextBlock();
                    continue block8;
                }
                case 15: {
                    if (blockIndent >= listIndent) {
                        this.nextBlock();
                    } else {
                        break;
                    }
                }
            }
            break;
        }
        this.sink.definition_();
        this.sink.definitionListItem_();
        this.sink.definitionList_();
    }

    private void nextBlock() throws AptParseException {
        this.nextBlock(false);
    }

    private void nextBlock(boolean firstBlock) throws AptParseException {
        int i;
        int indent;
        int length;
        block20: while (true) {
            if (this.line == null) {
                this.block = null;
                return;
            }
            length = this.line.length();
            indent = 0;
            block21: for (i = 0; i < length; ++i) {
                switch (this.line.charAt(i)) {
                    case ' ': {
                        ++indent;
                        continue block21;
                    }
                    case '\t': {
                        indent += 8;
                        continue block21;
                    }
                    default: {
                        break block20;
                    }
                }
            }
            if (i != length) continue;
            this.nextLine();
        }
        this.blockFileName = this.source.getName();
        this.blockLineNumber = this.source.getLineNumber();
        this.block = null;
        switch (this.line.charAt(i)) {
            case '*': {
                if (indent == 0) {
                    if (AptParser.charAt(this.line, length, i + 1) == '-' && AptParser.charAt(this.line, length, i + 2) == '-') {
                        this.block = new Table(indent, this.line);
                        break;
                    }
                    if (AptParser.charAt(this.line, length, i + 1) == '*') {
                        if (AptParser.charAt(this.line, length, i + 2) == '*') {
                            if (AptParser.charAt(this.line, length, i + 3) == '*') {
                                this.block = new Section5(indent, this.line);
                                break;
                            }
                            this.block = new Section4(indent, this.line);
                            break;
                        }
                        this.block = new Section3(indent, this.line);
                        break;
                    }
                    this.block = new Section2(indent, this.line);
                    break;
                }
                this.block = new ListItem(indent, this.line);
                break;
            }
            case '[': {
                if (AptParser.charAt(this.line, length, i + 1) == ']') {
                    this.block = new ListBreak(indent, this.line);
                    break;
                }
                if (indent == 0) {
                    this.block = new Figure(indent, this.line);
                    break;
                }
                if (AptParser.charAt(this.line, length, i + 1) == '[') {
                    int numbering;
                    switch (AptParser.charAt(this.line, length, i + 2)) {
                        case 'a': {
                            numbering = 1;
                            break;
                        }
                        case 'A': {
                            numbering = 2;
                            break;
                        }
                        case 'i': {
                            numbering = 3;
                            break;
                        }
                        case 'I': {
                            numbering = 4;
                            break;
                        }
                        default: {
                            numbering = 0;
                        }
                    }
                    this.block = new NumberedListItem(indent, this.line, numbering);
                    break;
                }
                this.block = new DefinitionListItem(indent, this.line);
                break;
            }
            case '-': {
                if (AptParser.charAt(this.line, length, i + 1) != '-' || AptParser.charAt(this.line, length, i + 2) != '-') break;
                if (indent == 0) {
                    this.block = new Verbatim(indent, this.line);
                    break;
                }
                if (!firstBlock) break;
                this.block = new Title(indent, this.line);
                break;
            }
            case '+': {
                if (indent != 0 || AptParser.charAt(this.line, length, i + 1) != '-' || AptParser.charAt(this.line, length, i + 2) != '-') break;
                this.block = new Verbatim(indent, this.line);
                break;
            }
            case '=': {
                if (indent != 0 || AptParser.charAt(this.line, length, i + 1) != '=' || AptParser.charAt(this.line, length, i + 2) != '=') break;
                this.block = new HorizontalRule(indent, this.line);
                break;
            }
            case '\f': {
                if (indent != 0) break;
                this.block = new PageBreak(indent, this.line);
                break;
            }
            case '%': {
                if (indent != 0 || AptParser.charAt(this.line, length, i + 1) != '{') break;
                this.block = new MacroBlock(indent, this.line);
                break;
            }
            case '~': {
                if (AptParser.charAt(this.line, length, i + 1) != '~') break;
                this.block = new Comment(this.line.substring(i + 2).trim());
                break;
            }
        }
        if (this.block == null) {
            this.block = indent == 0 ? new Section1(indent, this.line) : new Paragraph(indent, this.line);
        }
    }

    private void expectedBlock(int type) throws AptParseException {
        int blockType = this.block.getType();
        if (blockType != type) {
            throw new AptParseException("expected " + TYPE_NAMES[type] + ", found " + TYPE_NAMES[blockType]);
        }
    }

    private static boolean isOctalChar(char c) {
        return c >= '0' && c <= '7';
    }

    private static boolean isHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static void flushTraversed(StringBuffer buffer, Sink sink) {
        if (buffer.length() > 0) {
            sink.text(buffer.toString());
            buffer.setLength(0);
        }
    }

    private static int skipTraversedLinkAnchor(String text, int begin, int end, StringBuffer linkAnchor) throws AptParseException {
        int i;
        block4: for (i = begin; i < end; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '}': {
                    break block4;
                }
                case '\\': {
                    if (i + 1 < end) {
                        linkAnchor.append(text.charAt(++i));
                        continue block4;
                    }
                    linkAnchor.append('\\');
                    continue block4;
                }
                default: {
                    linkAnchor.append(c);
                }
            }
        }
        if (i == end) {
            throw new AptParseException("missing '}'");
        }
        return i;
    }

    private String getTraversedLink(String text, int begin, int end) throws AptParseException {
        char c;
        int i;
        int previous2 = 123;
        int previous = 123;
        for (i = begin; i < end && ((c = text.charAt(i)) != '}' || previous != 125 || previous2 == 92); ++i) {
            previous2 = previous;
            previous = c;
        }
        if (i == end) {
            throw new AptParseException("missing '{{'");
        }
        return this.doGetTraversedLink(text, begin, i - 1);
    }

    private String getTraversedAnchor(String text, int begin, int end) throws AptParseException {
        char c;
        int i;
        int previous = 123;
        for (i = begin; i < end && ((c = text.charAt(i)) != '}' || previous == 92); ++i) {
            previous = c;
        }
        if (i == end) {
            throw new AptParseException("missing '}'");
        }
        return this.doGetTraversedLink(text, begin, i);
    }

    private String doGetTraversedLink(String text, int begin, int end) throws AptParseException {
        final StringBuffer buffer = new StringBuffer(end - begin);
        SinkAdapter linkSink = new SinkAdapter(){

            public void lineBreak() {
                buffer.append(' ');
            }

            public void nonBreakingSpace() {
                buffer.append(' ');
            }

            public void text(String text) {
                buffer.append(text);
            }
        };
        this.doTraverseText(text, begin, end, (Sink)linkSink);
        return buffer.toString().trim();
    }

    private void logMessage(String key, String msg) {
        TreeSet<String> set;
        msg = "[APT Parser] " + msg;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)msg);
            return;
        }
        if (this.warnMessages == null) {
            this.warnMessages = new HashMap();
        }
        if ((set = (TreeSet<String>)this.warnMessages.get(key)) == null) {
            set = new TreeSet<String>();
        }
        set.add(msg);
        this.warnMessages.put(key, set);
    }

    static {
        for (int i = 0; i < 85; ++i) {
            AptParser.SPACES[i] = 32;
        }
    }

    private class MacroBlock
    extends Block {
        public MacroBlock(int indent, String firstLine) throws AptParseException {
            super(16, indent);
            this.text = firstLine;
        }

        public void traverse() throws AptParseException {
            if (AptParser.this.isSecondParsing()) {
                return;
            }
            String s = this.text;
            s = s.substring(2, s.length() - 1);
            s = this.escapeForMacro(s);
            String[] params = StringUtils.split((String)s, (String)"|");
            String macroId = params[0];
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            for (int i = 1; i < params.length; ++i) {
                String[] param = StringUtils.split((String)params[i], (String)"=");
                String key = this.unescapeForMacro(param[0]);
                String value = this.unescapeForMacro(param[1]);
                parameters.put(key, value);
            }
            parameters.put("sourceContent", AptParser.this.sourceContent);
            AptParser aptParser = new AptParser();
            aptParser.setSecondParsing(true);
            aptParser.enableLogging(AptParser.this.getLog());
            parameters.put("parser", aptParser);
            MacroRequest request = new MacroRequest(parameters, AptParser.this.getBasedir());
            try {
                AptParser.this.executeMacro(macroId, request, AptParser.this.sink);
            }
            catch (MacroExecutionException e) {
                throw new AptParseException("Unable to execute macro in the APT document", (Exception)((Object)e));
            }
            catch (MacroNotFoundException e) {
                throw new AptParseException("Unable to find macro used in the APT document", (Exception)((Object)e));
            }
        }

        private String escapeForMacro(String s) {
            if (s == null || s.length() < 1) {
                return s;
            }
            String result = s;
            result = StringUtils.replace((String)result, (String)"\\=", (String)"\u0011");
            result = StringUtils.replace((String)result, (String)"\\|", (String)"\u0012");
            return result;
        }

        private String unescapeForMacro(String s) {
            if (s == null || s.length() < 1) {
                return s;
            }
            String result = s;
            result = StringUtils.replace((String)result, (String)"\u0011", (String)"=");
            result = StringUtils.replace((String)result, (String)"\u0012", (String)"|");
            return result;
        }
    }

    private class PageBreak
    extends Block {
        public PageBreak(int indent, String firstLine) throws AptParseException {
            super(14, indent, firstLine);
        }

        public void traverse() throws AptParseException {
            AptParser.this.sink.pageBreak();
        }
    }

    private class HorizontalRule
    extends Block {
        public HorizontalRule(int indent, String firstLine) throws AptParseException {
            super(13, indent, firstLine);
        }

        public void traverse() throws AptParseException {
            AptParser.this.sink.horizontalRule();
        }
    }

    private class DefinitionListItem
    extends Block {
        public DefinitionListItem(int indent, String firstLine) throws AptParseException {
            super(12, indent, firstLine);
        }

        public void traverse() throws AptParseException {
            int i = this.skipSpaceFrom(0);
            int j = this.skipFromLeftToRightBracket(i);
            AptParser.this.sink.definedTerm();
            this.traverseText(i + 1, j);
            AptParser.this.sink.definedTerm_();
            j = this.skipSpaceFrom(j + 1);
            if (j == this.textLength) {
                // empty if block
            }
            AptParser.this.sink.definition();
            this.traverseText(j);
        }
    }

    private class NumberedListItem
    extends Block {
        private int numbering;

        public NumberedListItem(int indent, String firstLine, int number) throws AptParseException {
            super(11, indent, firstLine);
            this.numbering = number;
        }

        public int getNumbering() {
            return this.numbering;
        }

        public void traverse() throws AptParseException {
            this.traverseText(this.skipItemNumber());
        }

        private int skipItemNumber() throws AptParseException {
            char c;
            int i;
            int prevChar = 32;
            for (i = this.skipSpaceFrom(0); i < this.textLength && ((c = this.text.charAt(i)) != ']' || prevChar != 93); ++i) {
                prevChar = c;
            }
            if (i == this.textLength) {
                throw new AptParseException("missing ']]'");
            }
            return this.skipSpaceFrom(i + 1);
        }
    }

    private class ListItem
    extends Block {
        public ListItem(int indent, String firstLine) throws AptParseException {
            super(10, indent, firstLine);
        }

        public void traverse() throws AptParseException {
            this.traverseText(this.skipLeadingBullets());
        }
    }

    private class Table
    extends Block {
        public Table(int indent, String firstLine) throws AptParseException {
            super(9, indent, firstLine);
        }

        public void traverse() throws AptParseException {
            int captionIndex = -1;
            int nextLineIndex = 0;
            int init = 2;
            int[] justification = null;
            int rows = 0;
            int columns = 0;
            StringBuffer[] cells = null;
            boolean[] headers = null;
            AptParser.this.sink.table();
            block0: while (nextLineIndex < this.textLength) {
                String line;
                int i = this.text.indexOf("*--", nextLineIndex);
                if (i < 0) {
                    captionIndex = nextLineIndex;
                    break;
                }
                i = this.text.indexOf(10, nextLineIndex);
                if (i < 0) {
                    line = this.text.substring(nextLineIndex);
                    nextLineIndex = this.textLength;
                } else {
                    line = this.text.substring(nextLineIndex, i);
                    nextLineIndex = i + 1;
                }
                int lineLength = line.length();
                if (line.indexOf("*--") == 0) {
                    if (init == 2) {
                        init = 1;
                        justification = this.parseJustification(line, lineLength);
                        columns = justification.length;
                        cells = new StringBuffer[columns];
                        headers = new boolean[columns];
                        for (i = 0; i < columns; ++i) {
                            cells[i] = new StringBuffer();
                            headers[i] = false;
                        }
                        continue;
                    }
                    if (this.traverseRow(cells, headers, justification)) {
                        ++rows;
                    }
                    justification = this.parseJustification(line, lineLength);
                    continue;
                }
                if (init == 1) {
                    init = 0;
                    boolean grid = AptParser.charAt(line, lineLength, 0) == '|';
                    AptParser.this.sink.tableRows(justification, grid);
                }
                line = AptParser.replaceAll(line, "\\|", "\\u007C");
                StringTokenizer cellLines = new StringTokenizer(line, "|", true);
                i = 0;
                boolean processedGrid = false;
                while (cellLines.hasMoreTokens()) {
                    String cellLine = cellLines.nextToken();
                    if ("|".equals(cellLine)) {
                        if (processedGrid) {
                            headers[i] = true;
                            continue;
                        }
                        processedGrid = true;
                        headers[i] = false;
                        continue;
                    }
                    processedGrid = false;
                    cellLine = AptParser.replaceAll(cellLine, "\\", "\\u00A0");
                    cellLine = AptParser.replaceAll(cellLine, "\\u00A0~", "\\~");
                    cellLine = AptParser.replaceAll(cellLine, "\\u00A0=", "\\=");
                    cellLine = AptParser.replaceAll(cellLine, "\\u00A0-", "\\-");
                    cellLine = AptParser.replaceAll(cellLine, "\\u00A0+", "\\+");
                    cellLine = AptParser.replaceAll(cellLine, "\\u00A0*", "\\*");
                    cellLine = AptParser.replaceAll(cellLine, "\\u00A0[", "\\[");
                    cellLine = AptParser.replaceAll(cellLine, "\\u00A0]", "\\]");
                    cellLine = AptParser.replaceAll(cellLine, "\\u00A0<", "\\<");
                    cellLine = AptParser.replaceAll(cellLine, "\\u00A0>", "\\>");
                    cellLine = AptParser.replaceAll(cellLine, "\\u00A0{", "\\{");
                    cellLine = AptParser.replaceAll(cellLine, "\\u00A0}", "\\}");
                    cellLine = AptParser.replaceAll(cellLine, "\\u00A0\\u00A0", "\\\\");
                    cellLine = cellLine.trim();
                    StringBuffer cell = cells[i];
                    if (cellLine.length() > 0) {
                        if (cell.toString().trim().endsWith("\\u00A0")) {
                            cell.append("\\\n");
                        } else if (cell.length() != 0) {
                            cell.append(" ");
                        }
                        cell.append(cellLine);
                    }
                    if (++i != columns) continue;
                    continue block0;
                }
            }
            if (rows == 0) {
                throw new AptParseException("no table rows");
            }
            AptParser.this.sink.tableRows_();
            if (captionIndex >= 0) {
                AptParser.this.sink.tableCaption();
                AptParser.this.doTraverseText(this.text, captionIndex, this.textLength, AptParser.this.sink);
                AptParser.this.sink.tableCaption_();
            }
            AptParser.this.sink.table_();
        }

        private int[] parseJustification(String jline, int lineLength) throws AptParseException {
            int columns = 0;
            block8: for (int i = 2; i < lineLength; ++i) {
                switch (jline.charAt(i)) {
                    case '*': 
                    case '+': 
                    case ':': {
                        ++columns;
                        continue block8;
                    }
                }
            }
            if (columns == 0) {
                throw new AptParseException("no columns specified");
            }
            int[] justification = new int[columns];
            columns = 0;
            block9: for (int i = 2; i < lineLength; ++i) {
                switch (jline.charAt(i)) {
                    case '*': {
                        justification[columns++] = 0;
                        continue block9;
                    }
                    case '+': {
                        justification[columns++] = 1;
                        continue block9;
                    }
                    case ':': {
                        justification[columns++] = 2;
                        continue block9;
                    }
                }
            }
            return justification;
        }

        private boolean traverseRow(StringBuffer[] cells, boolean[] headers, int[] justification) throws AptParseException {
            int i;
            boolean traversed = false;
            for (i = 0; i < cells.length; ++i) {
                if (cells[i].length() <= 0) continue;
                traversed = true;
                break;
            }
            if (traversed) {
                AptParser.this.sink.tableRow();
                for (i = 0; i < cells.length; ++i) {
                    SinkEventAttributes justif;
                    StringBuffer cell = cells[i];
                    switch (justification[i]) {
                        case 0: {
                            justif = SinkEventAttributeSet.CENTER;
                            break;
                        }
                        case 1: {
                            justif = SinkEventAttributeSet.LEFT;
                            break;
                        }
                        case 2: {
                            justif = SinkEventAttributeSet.RIGHT;
                            break;
                        }
                        default: {
                            justif = SinkEventAttributeSet.LEFT;
                        }
                    }
                    SinkEventAttributeSet event = new SinkEventAttributeSet();
                    event.addAttributes((AttributeSet)justif);
                    if (headers[i]) {
                        AptParser.this.sink.tableHeaderCell((SinkEventAttributes)event);
                    } else {
                        AptParser.this.sink.tableCell((SinkEventAttributes)event);
                    }
                    if (cell.length() > 0) {
                        AptParser.this.doTraverseText(cell.toString(), 0, cell.length(), AptParser.this.sink);
                        cell.setLength(0);
                    }
                    if (headers[i]) {
                        AptParser.this.sink.tableHeaderCell_();
                        continue;
                    }
                    AptParser.this.sink.tableCell_();
                }
                AptParser.this.sink.tableRow_();
            }
            return traversed;
        }
    }

    private class Figure
    extends Block {
        public Figure(int indent, String firstLine) throws AptParseException {
            super(8, indent, firstLine);
        }

        public void traverse() throws AptParseException {
            AptParser.this.sink.figure();
            int i = this.skipFromLeftToRightBracket(0);
            AptParser.this.sink.figureGraphics(this.text.substring(1, i));
            i = this.skipSpaceFrom(i + 1);
            if (i < this.textLength) {
                AptParser.this.sink.figureCaption();
                this.traverseText(i);
                AptParser.this.sink.figureCaption_();
            }
            AptParser.this.sink.figure_();
        }
    }

    private class Verbatim
    extends Block {
        private boolean boxed;

        public Verbatim(int indent, String firstLine) throws AptParseException {
            super(7, indent, null);
            StringBuffer buffer = new StringBuffer();
            char firstChar = firstLine.charAt(0);
            boolean bl = this.boxed = firstChar == '+';
            while (AptParser.this.line != null) {
                String l = AptParser.this.line;
                int length = l.length();
                if (AptParser.charAt(l, length, 0) == firstChar && AptParser.charAt(l, length, 1) == '-' && AptParser.charAt(l, length, 2) == '-') {
                    AptParser.this.nextLine();
                    break;
                }
                int column = 0;
                for (int i = 0; i < length; ++i) {
                    char c = l.charAt(i);
                    if (c == '\t') {
                        int prevColumn = column;
                        column = (column + 1 + 8 - 1) / 8 * 8;
                        buffer.append(SPACES, 0, column - prevColumn);
                        continue;
                    }
                    ++column;
                    buffer.append(c);
                }
                buffer.append(Markup.EOL);
                AptParser.this.nextLine();
            }
            this.textLength = buffer.length();
            if (this.textLength > 0) {
                --this.textLength;
                buffer.setLength(this.textLength);
            }
            this.text = buffer.toString();
        }

        public void traverse() throws AptParseException {
            AptParser.this.sink.verbatim((SinkEventAttributes)(this.boxed ? SinkEventAttributeSet.BOXED : null));
            AptParser.this.sink.text(this.text);
            AptParser.this.sink.verbatim_();
        }
    }

    private class Comment
    extends Block {
        public Comment(String line) throws AptParseException {
            super(17, 0, line);
        }

        public void traverse() throws AptParseException {
            AptParser.this.sink.comment(this.text);
        }
    }

    private class Paragraph
    extends Block {
        public Paragraph(int indent, String firstLine) throws AptParseException {
            super(6, indent, firstLine);
        }

        public void traverse() throws AptParseException {
            AptParser.this.sink.paragraph();
            this.traverseText(this.skipSpaceFrom(0));
            AptParser.this.sink.paragraph_();
        }
    }

    private class Section5
    extends Section {
        public Section5(int indent, String firstLine) throws AptParseException {
            super(5, indent, firstLine);
        }

        public void Title() {
            AptParser.this.sink.sectionTitle5();
        }

        public void Title_() {
            AptParser.this.sink.sectionTitle5_();
        }
    }

    private class Section4
    extends Section {
        public Section4(int indent, String firstLine) throws AptParseException {
            super(4, indent, firstLine);
        }

        public void Title() {
            AptParser.this.sink.sectionTitle4();
        }

        public void Title_() {
            AptParser.this.sink.sectionTitle4_();
        }
    }

    private class Section3
    extends Section {
        public Section3(int indent, String firstLine) throws AptParseException {
            super(3, indent, firstLine);
        }

        public void Title() {
            AptParser.this.sink.sectionTitle3();
        }

        public void Title_() {
            AptParser.this.sink.sectionTitle3_();
        }
    }

    private class Section2
    extends Section {
        public Section2(int indent, String firstLine) throws AptParseException {
            super(2, indent, firstLine);
        }

        public void Title() {
            AptParser.this.sink.sectionTitle2();
        }

        public void Title_() {
            AptParser.this.sink.sectionTitle2_();
        }
    }

    private class Section1
    extends Section {
        public Section1(int indent, String firstLine) throws AptParseException {
            super(1, indent, firstLine);
        }

        public void Title() {
            AptParser.this.sink.sectionTitle1();
        }

        public void Title_() {
            AptParser.this.sink.sectionTitle1_();
        }
    }

    private abstract class Section
    extends Block {
        public Section(int type, int indent, String firstLine) throws AptParseException {
            super(type, indent, firstLine);
        }

        public void traverse() throws AptParseException {
            this.Title();
            this.traverseText(this.skipLeadingBullets());
            this.Title_();
        }

        public abstract void Title();

        public abstract void Title_();
    }

    private class Title
    extends Block {
        public Title(int indent, String firstLine) throws AptParseException {
            super(0, indent, firstLine);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void traverse() throws AptParseException {
            StringTokenizer lines = new StringTokenizer(this.text, Markup.EOL);
            int separator = -1;
            boolean firstLine = true;
            boolean title = false;
            boolean author = false;
            boolean date = false;
            block15: while (lines.hasMoreTokens()) {
                int lineLength;
                String line = lines.nextToken().trim();
                if (AptParser.charAt(line, lineLength = line.length(), 0) == '-' && AptParser.charAt(line, lineLength, 1) == '-' && AptParser.charAt(line, lineLength, 2) == '-') {
                    switch (separator) {
                        case 0: {
                            if (!title) throw new AptParseException("missing title");
                            AptParser.this.sink.title_();
                            break;
                        }
                        case 1: {
                            if (!author) break;
                            AptParser.this.sink.author_();
                            break;
                        }
                        case 2: {
                            break block15;
                        }
                    }
                    ++separator;
                    firstLine = true;
                    continue;
                }
                if (firstLine) {
                    firstLine = false;
                    switch (separator) {
                        case 0: {
                            title = true;
                            AptParser.this.sink.title();
                            break;
                        }
                        case 1: {
                            author = true;
                            AptParser.this.sink.author();
                            break;
                        }
                        case 2: {
                            date = true;
                            AptParser.this.sink.date();
                            break;
                        }
                    }
                } else {
                    AptParser.this.sink.lineBreak();
                }
                AptParser.this.doTraverseText(line, 0, lineLength, AptParser.this.sink);
            }
            switch (separator) {
                case 0: {
                    if (!title) throw new AptParseException("missing title");
                    AptParser.this.sink.title_();
                    return;
                }
                case 1: {
                    if (!author) return;
                    AptParser.this.sink.author_();
                    return;
                }
                case 2: {
                    if (!date) return;
                    AptParser.this.sink.date_();
                    return;
                }
            }
        }
    }

    private class ListBreak
    extends Block {
        public ListBreak(int indent, String firstLine) throws AptParseException {
            super(15, indent, firstLine);
        }

        public void traverse() throws AptParseException {
            throw new AptParseException("internal error: traversing list break");
        }
    }

    private abstract class Block {
        protected int type;
        protected int indent;
        protected String text;
        protected int textLength;

        public Block(int type, int indent) throws AptParseException {
            this(type, indent, null);
        }

        public Block(int type, int indent, String firstLine) throws AptParseException {
            this.type = type;
            this.indent = indent;
            AptParser.this.nextLine();
            if (firstLine == null) {
                this.text = null;
                this.textLength = 0;
            } else {
                StringBuffer buffer = new StringBuffer(firstLine);
                while (AptParser.this.line != null) {
                    String l = AptParser.this.line;
                    int length = l.length();
                    int i = 0;
                    if ((i = AptParser.skipSpace(l, length, i)) == length) {
                        AptParser.this.nextLine();
                        break;
                    }
                    if (AptParser.charAt(l, length, i) == '~' && AptParser.charAt(l, length, i + 1) == '~' || type == 17) break;
                    buffer.append(Markup.EOL);
                    buffer.append(l);
                    AptParser.this.nextLine();
                }
                this.text = buffer.toString();
                this.textLength = this.text.length();
            }
        }

        public final int getType() {
            return this.type;
        }

        public final int getIndent() {
            return this.indent;
        }

        public abstract void traverse() throws AptParseException;

        protected void traverseText(int begin) throws AptParseException {
            this.traverseText(begin, this.text.length());
        }

        protected void traverseText(int begin, int end) throws AptParseException {
            AptParser.this.doTraverseText(this.text, begin, end, AptParser.this.sink);
        }

        protected int skipLeadingBullets() {
            int i;
            for (i = this.skipSpaceFrom(0); i < this.textLength && this.text.charAt(i) == '*'; ++i) {
            }
            return this.skipSpaceFrom(i);
        }

        protected int skipFromLeftToRightBracket(int i) throws AptParseException {
            char c;
            int previous = 91;
            ++i;
            while (i < this.textLength && ((c = this.text.charAt(i)) != ']' || previous == 92)) {
                previous = c;
                ++i;
            }
            if (i == this.textLength) {
                throw new AptParseException("missing ']'");
            }
            return i;
        }

        protected final int skipSpaceFrom(int i) {
            return AptParser.skipSpace(this.text, this.textLength, i);
        }
    }
}

