/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.internal.MavenPluginConfigurationValidator;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.slf4j.Logger;

abstract class AbstractMavenPluginParametersValidator
implements MavenPluginConfigurationValidator {
    private static final List<String> IGNORED_PROPERTY_VALUES = Arrays.asList("basedir", "executedProject", "localRepository", "mojo", "mojoExecution", "plugin", "project", "reactorProjects", "session", "settings");
    private static final List<String> IGNORED_PROPERTY_PREFIX = Arrays.asList("mojo.", "pom.", "plugin.", "project.", "session.", "settings.");

    AbstractMavenPluginParametersValidator() {
    }

    protected abstract Logger getLogger();

    protected static boolean isValueSet(PlexusConfiguration config, ExpressionEvaluator expressionEvaluator) {
        if (config == null) {
            return false;
        }
        if (config.getChildCount() > 0) {
            return true;
        }
        String strValue = config.getValue();
        if (strValue == null || strValue.isEmpty()) {
            return false;
        }
        if (AbstractMavenPluginParametersValidator.isIgnoredProperty(strValue)) {
            return false;
        }
        try {
            return expressionEvaluator.evaluate(strValue) != null;
        }
        catch (ExpressionEvaluationException expressionEvaluationException) {
            return false;
        }
    }

    private static boolean isIgnoredProperty(String strValue) {
        if (!strValue.startsWith("${")) {
            return false;
        }
        String propertyName = strValue.replace("${", "").replace("}", "");
        if (IGNORED_PROPERTY_VALUES.contains(propertyName)) {
            return true;
        }
        return IGNORED_PROPERTY_PREFIX.stream().anyMatch(propertyName::startsWith);
    }

    protected abstract String getParameterLogReason(Parameter var1);

    protected void logParameter(Parameter parameter) {
        MessageBuilder messageBuilder = MessageUtils.buffer().warning((Object)"Parameter '").warning((Object)parameter.getName()).warning((Object)Character.valueOf('\''));
        if (parameter.getExpression() != null) {
            String userProperty = parameter.getExpression().replace("${", "'").replace('}', '\'');
            messageBuilder.warning((Object)" (user property ").warning((Object)userProperty).warning((Object)")");
        }
        messageBuilder.warning((Object)" ").warning((Object)this.getParameterLogReason(parameter));
        this.getLogger().warn(messageBuilder.toString());
    }
}

